/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighterKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "highlightProperty", "", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "idea-analysis"})
public final class PropertiesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (expression2.getParent() instanceof KtThisExpression) {
            return;
        }
        DeclarationDescriptor target = (DeclarationDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target instanceof SyntheticFieldDescriptor) {
            PsiElement psiElement2 = (PsiElement)expression2;
            TextAttributesKey textAttributesKey = KotlinHighlightingColors.BACKING_FIELD_VARIABLE;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"BACKING_FIELD_VARIABLE");
            NameHighlighterKt.highlightName(this.holder, psiElement2, textAttributesKey);
            return;
        }
        if (!(target instanceof PropertyDescriptor)) {
            return;
        }
        this.highlightProperty((PsiElement)expression2, (PropertyDescriptor)target);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElement psiElement2 = property2.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement2;
        VariableDescriptor propertyDescriptor = (VariableDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property2);
        if (propertyDescriptor instanceof PropertyDescriptor) {
            PsiElement psiElement3 = nameIdentifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nameIdentifier");
            this.highlightProperty(psiElement3, (PropertyDescriptor)propertyDescriptor);
        }
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement2;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor != null) {
            PsiElement psiElement3 = nameIdentifier;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nameIdentifier");
            this.highlightProperty(psiElement3, propertyDescriptor);
        }
        super.visitParameter(parameter);
    }

    private final void highlightProperty(PsiElement elementToHighlight, PropertyDescriptor descriptor2) {
        TextAttributesKey attributesKey;
        TextAttributesKey textAttributesKey = attributesKey = DynamicCallsKt.isDynamic(descriptor2) ? KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL : (descriptor2.getExtensionReceiverParameter() != null ? KotlinHighlightingColors.EXTENSION_PROPERTY : (DescriptorUtils.isStaticDeclaration(descriptor2) ? KotlinHighlightingColors.PACKAGE_PROPERTY : KotlinHighlightingColors.INSTANCE_PROPERTY));
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"attributesKey");
        NameHighlighterKt.highlightName(this.holder, elementToHighlight, textAttributesKey);
    }

    public PropertiesHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

