/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt$findChildrenComments$;
import org.jetbrains.kotlin.idea.injection.KotlinLanguageInjectionSupportKt$findCommentsBeforeElement$;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\u0013H\u0002\u001a \u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002\u001a\u0012\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u000fH\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\u000fH\u0002\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"KOTLIN_SUPPORT_ID", "", "getKOTLIN_SUPPORT_ID", "()Ljava/lang/String;", "LINE_LANGUAGE_REGEXP_COMMENT", "Lkotlin/text/Regex;", "getLINE_LANGUAGE_REGEXP_COMMENT", "()Lkotlin/text/Regex;", "addInjectionInstructionInCode", "", "language", "Lcom/intellij/lang/Language;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "canInjectWithAnnotation", "Lcom/intellij/psi/PsiElement;", "checkIsValidPlaceForInjectionWithLineComment", "statement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtElement;", "extractLanguageFromInjectAnnotation", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "findAnnotationInjection", "findElementToInjectWithAnnotation", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "findElementToInjectWithComment", "prevWalker", "", "element", "scope", "findChildrenComments", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiComment;", "findCommentsBeforeElement", "firstNonCommentChild", "idea"})
public final class KotlinLanguageInjectionSupportKt {
    @NonNls
    @NotNull
    private static final String KOTLIN_SUPPORT_ID = "kotlin";
    @NotNull
    private static final Regex LINE_LANGUAGE_REGEXP_COMMENT;

    @NotNull
    public static final String getKOTLIN_SUPPORT_ID() {
        return KOTLIN_SUPPORT_ID;
    }

    @NotNull
    public static final Regex getLINE_LANGUAGE_REGEXP_COMMENT() {
        return LINE_LANGUAGE_REGEXP_COMMENT;
    }

    @Nullable
    public static final String extractLanguageFromInjectAnnotation(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkParameterIsNotNull((Object)annotationEntry2, (String)"annotationEntry");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.firstOrNull(annotationEntry2.getValueArguments());
        if (valueArgument == null) {
            return null;
        }
        ValueArgument firstArgument = valueArgument;
        KtExpression ktExpression = firstArgument.getArgumentExpression();
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression firstStringArgument = ktStringTemplateExpression;
        KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])firstStringArgument.getEntries());
        if (ktStringTemplateEntry == null) {
            return null;
        }
        KtStringTemplateEntry firstStringEntry = ktStringTemplateEntry;
        return firstStringEntry.getText();
    }

    private static final KtAnnotationEntry findAnnotationInjection(KtElement host) {
        KtModifierListOwner ktModifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(host);
        if (ktModifierListOwner == null) {
            return null;
        }
        KtModifierListOwner modifierListOwner = ktModifierListOwner;
        KtModifierList ktModifierList = modifierListOwner.getModifierList();
        if (ktModifierList == null) {
            return null;
        }
        KtModifierList modifierList = ktModifierList;
        if (PsiUtilsKt.getStartOffset((PsiElement)host) < PsiUtilsKt.getEndOffset((PsiElement)modifierList)) {
            return null;
        }
        return ModifierListModifactorKt.findAnnotation(modifierListOwner, new FqName("org.intellij.lang.annotations.Language"));
    }

    private static final boolean canInjectWithAnnotation(PsiElement host) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module2.getProject());
        return javaPsiFacade.findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2)) != null;
    }

    private static final KtModifierListOwner findElementToInjectWithAnnotation(KtElement host) {
        return (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtModifierListOwner.class, (boolean)false, (Class[])new Class[]{KtBlockExpression.class, KtParameterList.class, KtTypeParameterList.class});
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final KtExpression findElementToInjectWithComment(KtElement host) {
        Object element$iv;
        Object v1;
        boolean bl;
        KtBlockExpression ktBlockExpression = (KtBlockExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)host), KtBlockExpression.class, (boolean)true, (Class[])new Class[]{KtDeclaration.class});
        if (ktBlockExpression == null) return null;
        KtBlockExpression parentBlockExpression = ktBlockExpression;
        Iterable $receiver$iv = parentBlockExpression.getStatements();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) {
                v1 = null;
                return v1;
            }
            element$iv = iterator2.next();
            KtExpression statement = (KtExpression)element$iv;
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statement), (PsiElement)((PsiElement)host), (boolean)false)) {
                KtExpression ktExpression = statement;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"statement");
                if (KotlinLanguageInjectionSupportKt.checkIsValidPlaceForInjectionWithLineComment(ktExpression, host)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v1 = element$iv;
        return v1;
    }

    private static final boolean addInjectionInstructionInCode(Language language, PsiLanguageInjectionHost host) {
        PsiLanguageInjectionHost psiLanguageInjectionHost = host;
        if (!(psiLanguageInjectionHost instanceof KtElement)) {
            psiLanguageInjectionHost = null;
        }
        KtElement ktElement = (KtElement)psiLanguageInjectionHost;
        if (ktElement == null) {
            return false;
        }
        KtElement ktHost = ktElement;
        Project project = ktHost.getProject();
        KtModifierListOwner modifierListOwner = KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(ktHost);
        if (modifierListOwner != null && KotlinLanguageInjectionSupportKt.canInjectWithAnnotation((PsiElement)ktHost)) {
            ApplicationUtilsKt.executeWriteCommand(project, "Add injection annotation", (Function0<Unit>)((Function0)new Function0<Unit>(modifierListOwner, language){
                final /* synthetic */ KtModifierListOwner $modifierListOwner;
                final /* synthetic */ Language $language;

                public final void invoke() {
                    ModifierListModifactorKt.addAnnotation$default(this.$modifierListOwner, new FqName("org.intellij.lang.annotations.Language"), "\"" + this.$language.getID() + "\"", null, null, 12, null);
                }
                {
                    this.$modifierListOwner = ktModifierListOwner;
                    this.$language = language;
                    super(0);
                }
            }));
            return true;
        }
        KtModifierListOwner ktModifierListOwner = modifierListOwner;
        if (ktModifierListOwner == null || (ktModifierListOwner = KotlinLanguageInjectionSupportKt.firstNonCommentChild(ktModifierListOwner)) == null) {
            ktModifierListOwner = (PsiElement)KotlinLanguageInjectionSupportKt.findElementToInjectWithComment(ktHost);
        }
        if (ktModifierListOwner == null) {
            return false;
        }
        KtModifierListOwner commentBeforeAnchor = ktModifierListOwner;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        PsiComment injectComment = psiFactory.createComment("//language=" + language.getID());
        ApplicationUtilsKt.executeWriteCommand(project, "Add injection comment", (Function0<Unit>)((Function0)new Function0<Unit>((PsiElement)commentBeforeAnchor, injectComment){
            final /* synthetic */ PsiElement $commentBeforeAnchor;
            final /* synthetic */ PsiComment $injectComment;

            public final void invoke() {
                this.$commentBeforeAnchor.getParent().addBefore((PsiElement)this.$injectComment, this.$commentBeforeAnchor);
            }
            {
                this.$commentBeforeAnchor = psiElement2;
                this.$injectComment = psiComment;
                super(0);
            }
        }));
        return true;
    }

    private static final boolean checkIsValidPlaceForInjectionWithLineComment(KtExpression statement, KtElement host) {
        int statementStartOffset = PsiUtilsKt.getStartOffset((PsiElement)statement);
        int hostStart = PsiUtilsKt.getStartOffset((PsiElement)host);
        if (hostStart < statementStartOffset || hostStart - statementStartOffset > 120) {
            return false;
        }
        if (hostStart - statementStartOffset > 2) {
            boolean bl;
            block4: {
                Sequence $receiver$iv = SequencesKt.takeWhile((Sequence)SequencesKt.asSequence(KotlinLanguageInjectionSupportKt.prevWalker((PsiElement)host, (PsiElement)statement)), (Function1)checkIsValidPlaceForInjectionWithLineComment.1.INSTANCE);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)it).isValidHost() && !StringUtil.isEmptyOrSpaces((String)((PsiLanguageInjectionHost)it).getText()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    private static final Sequence<PsiComment> findChildrenComments(@NotNull PsiElement $receiver) {
        Sequence $receiver$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default($receiver.getFirstChild(), false, false, 3, null), (Function1)findChildrenComments.1.INSTANCE);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)findChildrenComments$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence2;
    }

    private static final Sequence<PsiComment> findCommentsBeforeElement(@NotNull PsiElement $receiver) {
        Sequence $receiver$iv = SequencesKt.takeWhile(PsiUtilsKt.siblings($receiver, false, false), (Function1)findCommentsBeforeElement.1.INSTANCE);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)findCommentsBeforeElement$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence2;
    }

    private static final PsiElement firstNonCommentChild(@NotNull PsiElement $receiver) {
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings$default($receiver.getFirstChild(), false, false, 3, null), (Function1)firstNonCommentChild.1.INSTANCE));
    }

    private static final Iterator<PsiElement> prevWalker(PsiElement element2, PsiElement scope2) {
        return new Iterator<PsiElement>(scope2, element2){
            private PsiElement e;
            final /* synthetic */ PsiElement $scope;
            final /* synthetic */ PsiElement $element;

            public boolean hasNext() {
                return true;
            }

            @Nullable
            public PsiElement next() {
                PsiElement current = this.e;
                if (current == null || current == this.$scope) {
                    return null;
                }
                PsiElement prev2 = current.getPrevSibling();
                if (prev2 != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev2);
                    return this.e;
                }
                PsiElement parent2 = current.getParent();
                this.e = parent2 == this.$scope || parent2 instanceof PsiFile ? null : parent2;
                return this.e;
            }
            {
                this.$scope = $captured_local_variable$0;
                this.$element = $captured_local_variable$1;
                this.e = $captured_local_variable$1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    static {
        KOTLIN_SUPPORT_ID = KOTLIN_SUPPORT_ID;
        LINE_LANGUAGE_REGEXP_COMMENT = new Regex("//\\s*language=[\\w-]+");
    }

    public static final /* synthetic */ boolean access$addInjectionInstructionInCode(@NotNull Language language, @NotNull PsiLanguageInjectionHost host) {
        return KotlinLanguageInjectionSupportKt.addInjectionInstructionInCode(language, host);
    }

    @Nullable
    public static final /* synthetic */ KtAnnotationEntry access$findAnnotationInjection(@NotNull KtElement host) {
        return KotlinLanguageInjectionSupportKt.findAnnotationInjection(host);
    }

    @Nullable
    public static final /* synthetic */ KtModifierListOwner access$findElementToInjectWithAnnotation(@NotNull KtElement host) {
        return KotlinLanguageInjectionSupportKt.findElementToInjectWithAnnotation(host);
    }

    @NotNull
    public static final /* synthetic */ Sequence access$findChildrenComments(@NotNull PsiElement $receiver) {
        return KotlinLanguageInjectionSupportKt.findChildrenComments($receiver);
    }

    @Nullable
    public static final /* synthetic */ KtExpression access$findElementToInjectWithComment(@NotNull KtElement host) {
        return KotlinLanguageInjectionSupportKt.findElementToInjectWithComment(host);
    }

    @NotNull
    public static final /* synthetic */ Sequence access$findCommentsBeforeElement(@NotNull PsiElement $receiver) {
        return KotlinLanguageInjectionSupportKt.findCommentsBeforeElement($receiver);
    }
}

