/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "typeParameter", "upperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lorg/jetbrains/kotlin/types/KotlinType;)V", "renderedUpperBound", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Factory", "idea"})
public final class AddGenericUpperBoundFix
extends KotlinQuickFixAction<KtTypeParameter> {
    private final String renderedUpperBound;
    public static final Factory Factory = new Factory(null);

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                KtTypeParameter ktTypeParameter;
                object = (KtTypeParameter)this.getElement();
                if (object == null) break block2;
                KtTypeParameter it = ktTypeParameter = object;
                object = "Add '" + this.renderedUpperBound + "' as upper bound for " + it.getName();
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return "Add generic upper bound";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtTypeParameter ktTypeParameter = (KtTypeParameter)this.getElement();
        if (ktTypeParameter == null) {
            return false;
        }
        KtTypeParameter element2 = ktTypeParameter;
        if (!super.isAvailable(project, editor, file2)) {
            return false;
        }
        return element2.getName() != null && element2.getExtendsBound() == null;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        KtTypeReference insertedTypeReference;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtTypeParameter ktTypeParameter = (KtTypeParameter)this.getElement();
        if (ktTypeParameter == null) {
            return;
        }
        KtTypeParameter element2 = ktTypeParameter;
        boolean bl2 = bl = element2.getExtendsBound() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Don't know what to do with existing bounds";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtTypeReference typeReference = new KtPsiFactory(project, false, 2, null).createType(this.renderedUpperBound);
        KtTypeReference ktTypeReference = element2.setExtendsBound(typeReference);
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtTypeReference ktTypeReference2 = insertedTypeReference = ktTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"insertedTypeReference");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktTypeReference2, null, 2, null);
    }

    public AddGenericUpperBoundFix(@NotNull KtTypeParameter typeParameter, @NotNull KotlinType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        super((PsiElement)typeParameter);
        this.renderedUpperBound = IdeDescriptorRenderers.SOURCE_CODE.renderType(upperBound);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "argument", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "createActionsByInferenceData", "", "inferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "doCreateActions", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinIntentionActionsFactory {
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.UPPER_BOUND_VIOLATED)) {
                DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)Errors.UPPER_BOUND_VIOLATED.cast(diagnostic);
                Object b = upperBoundViolated.getB();
                Intrinsics.checkExpressionValueIsNotNull(b, (String)"upperBoundViolated.b");
                KotlinType kotlinType = (KotlinType)b;
                Object a = upperBoundViolated.getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"upperBoundViolated.a");
                list2 = CollectionsKt.listOfNotNull((Object)this.createAction(kotlinType, (KotlinType)a));
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED)) {
                InferenceErrorData inferenceData;
                InferenceErrorData inferenceErrorData = inferenceData = (InferenceErrorData)((DiagnosticWithParameters1)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)inferenceErrorData, (String)"inferenceData");
                list2 = this.createActionsByInferenceData(inferenceErrorData);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntentionAction> createActionsByInferenceData(InferenceErrorData inferenceData) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ConstraintSystem successfulConstraintSystem = ConstraintSystemUtilsKt.filterConstraintsOut(inferenceData.constraintSystem, ConstraintPositionKind.TYPE_BOUND_POSITION);
            if (!successfulConstraintSystem.getStatus().isSuccessful()) {
                return CollectionsKt.emptyList();
            }
            TypeSubstitutor resultingSubstitutor2 = successfulConstraintSystem.getResultingSubstitutor();
            Iterable iterable = $receiver$iv = (Iterable)inferenceData.descriptor.getTypeParameters();
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                IntentionAction intentionAction;
                IntentionAction intentionAction2;
                Object element$iv$iv = element$iv$iv$iv;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
                if (ConstraintsUtil.checkUpperBoundIsSatisfied(successfulConstraintSystem, typeParameterDescriptor, inferenceData.call, true)) {
                    intentionAction2 = null;
                } else if ((KotlinType)CollectionsKt.singleOrNull(typeParameterDescriptor.getUpperBounds()) == null) {
                    intentionAction2 = null;
                } else if (resultingSubstitutor2.substitute(typeParameterDescriptor.getDefaultType(), Variance.INVARIANT) == null) {
                    intentionAction2 = null;
                } else {
                    KotlinType upperBound;
                    KotlinType argument2;
                    KotlinType kotlinType = argument2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"argument");
                    intentionAction2 = Factory.createAction(kotlinType, upperBound);
                }
                if (intentionAction2 == null) continue;
                IntentionAction it$iv$iv = intentionAction = intentionAction2;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final IntentionAction createAction(KotlinType argument2, KotlinType upperBound) {
            if (!upperBound.getConstructor().isDenotable()) {
                return null;
            }
            ClassifierDescriptor classifierDescriptor = argument2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            if (typeParameterDescriptor == null) {
                return null;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor2);
            if (!(psiElement2 instanceof KtTypeParameter)) {
                psiElement2 = null;
            }
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement2;
            if (ktTypeParameter == null) {
                return null;
            }
            KtTypeParameter typeParameterDeclaration = ktTypeParameter;
            return new AddGenericUpperBoundFix(typeParameterDeclaration, upperBound);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

