/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveFilesOrDirectories.MoveKotlinFileHandler;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016JQ\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002JD\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J1\u0010&\u001a\u00020\n2\u000e\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00132\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140)H\u0016\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/KotlinMoveDirectoryWithClassesHelper;", "Lcom/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesHelper;", "()V", "fileHandler", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler;", "fileToMoveContext", "", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/KotlinMoveDirectoryWithClassesHelper$MoveContext;", "afterMove", "", "newElement", "Lcom/intellij/psi/PsiElement;", "beforeMove", "psiFile", "findUsages", "filesToMove", "", "directoriesToMove", "", "Lcom/intellij/psi/PsiDirectory;", "result", "Lcom/intellij/usageView/UsageInfo;", "searchInComments", "", "searchInNonJavaFiles", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/Collection;[Lcom/intellij/psi/PsiDirectory;Ljava/util/Collection;ZZLcom/intellij/openapi/project/Project;)V", "getOrCreateMoveContextMap", "move", "file", "moveDestination", "oldToNewElementsMapping", "movedFiles", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "postProcessUsages", "usages", "newDirMapper", "Lcom/intellij/util/Function;", "([Lcom/intellij/usageView/UsageInfo;Lcom/intellij/util/Function;)V", "FileUsagesWrapper", "MoveContext", "idea"})
public final class KotlinMoveDirectoryWithClassesHelper
extends MoveDirectoryWithClassesHelper {
    private final MoveKotlinFileHandler fileHandler = new MoveKotlinFileHandler();
    private Map<PsiFile, MoveContext> fileToMoveContext;

    private final Map<PsiFile, MoveContext> getOrCreateMoveContextMap() {
        Map map2 = this.fileToMoveContext;
        if (map2 == null) {
            HashMap hashMap;
            HashMap $receiver = hashMap = new HashMap();
            this.fileToMoveContext = $receiver;
            KotlinRefactoringUtilKt.invokeOnceOnCommandFinish((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ KotlinMoveDirectoryWithClassesHelper this$0;
                {
                    this.this$0 = kotlinMoveDirectoryWithClassesHelper;
                    super(0);
                }

                public final void invoke() {
                    KotlinMoveDirectoryWithClassesHelper.access$setFileToMoveContext$p(this.this$0, null);
                }
            }));
            map2 = hashMap;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    public void findUsages(@NotNull Collection<PsiFile> filesToMove, @NotNull PsiDirectory[] directoriesToMove, @NotNull Collection<UsageInfo> result2, boolean searchInComments, boolean searchInNonJavaFiles, @NotNull Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(filesToMove, (String)"filesToMove");
        Intrinsics.checkParameterIsNotNull((Object)directoriesToMove, (String)"directoriesToMove");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Iterable iterable = filesToMove;
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object item$iv : $receiver$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv;
            Collection<UsageInfo> collection = result2;
            FileUsagesWrapper fileUsagesWrapper = new FileUsagesWrapper((PsiFile)it, this.fileHandler.findUsages((PsiFile)it, null, searchInComments, searchInNonJavaFiles), null);
            collection.add(fileUsagesWrapper);
        }
    }

    public void beforeMove(@NotNull PsiFile psiFile) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
    }

    public boolean move(@NotNull PsiFile file2, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewElementsMapping2, @NotNull List<PsiFile> movedFiles, @Nullable RefactoringElementListener listener2) {
        block3: {
            PsiPackage moveContextMap;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)moveDestination, (String)"moveDestination");
            Intrinsics.checkParameterIsNotNull(oldToNewElementsMapping2, (String)"oldToNewElementsMapping");
            Intrinsics.checkParameterIsNotNull(movedFiles, (String)"movedFiles");
            if (!(file2 instanceof KtFile)) {
                return false;
            }
            MoveKotlinDeclarationsProcessor moveDeclarationsProcessor = this.fileHandler.initMoveProcessor(file2, moveDestination);
            PsiPackage psiPackage = moveContextMap = this.getOrCreateMoveContextMap();
            MoveContext moveContext = new MoveContext(moveDestination, this.fileHandler.findInternalUsages$idea((KtFile)file2, moveDestination), moveDeclarationsProcessor);
            psiPackage.put((PsiFile)file2, (MoveContext)moveContext);
            if (moveDeclarationsProcessor == null) break block3;
            PsiPackage psiPackage2 = PackageUtilsKt.getPackage(moveDestination);
            if (psiPackage2 != null) {
                PsiPackage newPackage = psiPackage = psiPackage2;
                KtPackageDirective ktPackageDirective = ((KtFile)file2).getPackageDirective();
                if (ktPackageDirective != null) {
                    ktPackageDirective.setFqName(UtilsKt.quoteIfNeeded(new FqName(newPackage.getQualifiedName())));
                }
            }
        }
        return true;
    }

    public void afterMove(@NotNull PsiElement newElement) {
        Intrinsics.checkParameterIsNotNull((Object)newElement, (String)"newElement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void postProcessUsages(@NotNull UsageInfo[] usages2, @NotNull Function<PsiDirectory, PsiDirectory> newDirMapper) {
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        Intrinsics.checkParameterIsNotNull(newDirMapper, (String)"newDirMapper");
        Map<PsiFile, MoveContext> map2 = this.fileToMoveContext;
        if (map2 == null) {
            return;
        }
        Map<PsiFile, MoveContext> fileToMoveContext = map2;
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ArrayList usagesToProcessAfterMove = new ArrayList();
            Object[] objectArray = usages2;
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                if (!(element$iv$iv instanceof FileUsagesWrapper)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                MoveKotlinDeclarationsProcessor moveDeclarationsProcessor;
                PsiFile movedFile;
                MoveContext moveContext;
                FileUsagesWrapper it = (FileUsagesWrapper)((Object)element$iv);
                PsiFile file2 = it.getPsiFile();
                if (fileToMoveContext.get(file2) == null) {
                    continue;
                }
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file2, (PsiDirectory)moveContext.getNewParent());
                if (moveContext.getMoveDeclarationsProcessor() == null) {
                    continue;
                }
                if (moveContext.getNewParent().findFile(file2.getName()) == null) {
                    continue;
                }
                Collection collection = usagesToProcessAfterMove;
                PsiFile psiFile = movedFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"movedFile");
                FileUsagesWrapper fileUsagesWrapper = new FileUsagesWrapper(psiFile, CollectionsKt.plus((Collection)it.getUsages(), (Object)((Object)moveContext.getInternalUsages())), moveDeclarationsProcessor);
                collection.add(fileUsagesWrapper);
            }
            $receiver$iv = usagesToProcessAfterMove;
            for (Object element$iv : $receiver$iv) {
                FileUsagesWrapper it = (FileUsagesWrapper)((Object)element$iv);
                List<UsageInfo> list2 = it.getUsages();
                MoveKotlinDeclarationsProcessor moveKotlinDeclarationsProcessor = it.getMoveDeclarationsProcessor();
                if (moveKotlinDeclarationsProcessor == null) {
                    Intrinsics.throwNpe();
                }
                this.fileHandler.retargetUsages(list2, moveKotlinDeclarationsProcessor);
            }
        }
        finally {
            this.fileToMoveContext = null;
        }
    }

    @Nullable
    public static final /* synthetic */ Map access$getFileToMoveContext$p(KotlinMoveDirectoryWithClassesHelper $this) {
        return $this.fileToMoveContext;
    }

    public static final /* synthetic */ void access$setFileToMoveContext$p(KotlinMoveDirectoryWithClassesHelper $this, @Nullable Map map2) {
        $this.fileToMoveContext = map2;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/KotlinMoveDirectoryWithClassesHelper$FileUsagesWrapper;", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "usages", "", "moveDeclarationsProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "(Lcom/intellij/psi/PsiFile;Ljava/util/List;Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;)V", "getMoveDeclarationsProcessor", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getUsages", "()Ljava/util/List;", "idea"})
    private static final class FileUsagesWrapper
    extends UsageInfo {
        @NotNull
        private final PsiFile psiFile;
        @NotNull
        private final List<UsageInfo> usages;
        @Nullable
        private final MoveKotlinDeclarationsProcessor moveDeclarationsProcessor;

        @NotNull
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final List<UsageInfo> getUsages() {
            return this.usages;
        }

        @Nullable
        public final MoveKotlinDeclarationsProcessor getMoveDeclarationsProcessor() {
            return this.moveDeclarationsProcessor;
        }

        public FileUsagesWrapper(@NotNull PsiFile psiFile, @NotNull List<? extends UsageInfo> usages2, @Nullable MoveKotlinDeclarationsProcessor moveDeclarationsProcessor) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
            super(psiFile);
            this.psiFile = psiFile;
            this.usages = usages2;
            this.moveDeclarationsProcessor = moveDeclarationsProcessor;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/KotlinMoveDirectoryWithClassesHelper$MoveContext;", "", "newParent", "Lcom/intellij/psi/PsiDirectory;", "internalUsages", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$InternalUsagesWrapper;", "moveDeclarationsProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "(Lcom/intellij/psi/PsiDirectory;Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$InternalUsagesWrapper;Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;)V", "getInternalUsages", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveFilesOrDirectories/MoveKotlinFileHandler$InternalUsagesWrapper;", "getMoveDeclarationsProcessor", "()Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsProcessor;", "getNewParent", "()Lcom/intellij/psi/PsiDirectory;", "idea"})
    private static final class MoveContext {
        @NotNull
        private final PsiDirectory newParent;
        @NotNull
        private final MoveKotlinFileHandler.InternalUsagesWrapper internalUsages;
        @Nullable
        private final MoveKotlinDeclarationsProcessor moveDeclarationsProcessor;

        @NotNull
        public final PsiDirectory getNewParent() {
            return this.newParent;
        }

        @NotNull
        public final MoveKotlinFileHandler.InternalUsagesWrapper getInternalUsages() {
            return this.internalUsages;
        }

        @Nullable
        public final MoveKotlinDeclarationsProcessor getMoveDeclarationsProcessor() {
            return this.moveDeclarationsProcessor;
        }

        public MoveContext(@NotNull PsiDirectory newParent, @NotNull MoveKotlinFileHandler.InternalUsagesWrapper internalUsages, @Nullable MoveKotlinDeclarationsProcessor moveDeclarationsProcessor) {
            Intrinsics.checkParameterIsNotNull((Object)newParent, (String)"newParent");
            Intrinsics.checkParameterIsNotNull((Object)((Object)internalUsages), (String)"internalUsages");
            this.newParent = newParent;
            this.internalUsages = internalUsages;
            this.moveDeclarationsProcessor = moveDeclarationsProcessor;
        }
    }
}

