/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/structureView/KotlinStructureElementPresentation;", "Lcom/intellij/navigation/ColoredItemPresentation;", "Lcom/intellij/navigation/LocationPresentation;", "isInherited", "", "navigatablePsiElement", "Lcom/intellij/psi/NavigatablePsiElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(ZLcom/intellij/psi/NavigatablePsiElement;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "elementText", "", "icon", "Ljavax/swing/Icon;", "locationString", "getElementAttributesKey", "getElementIcon", "getElementLocationString", "getElementText", "getIcon", "unused", "getLocationPrefix", "getLocationString", "getLocationSuffix", "getPresentableText", "getTextAttributesKey", "withRightArrow", "str", "idea-analysis"})
public final class KotlinStructureElementPresentation
implements ColoredItemPresentation,
LocationPresentation {
    private final TextAttributesKey attributesKey;
    private final String elementText;
    private final String locationString;
    private final Icon icon;
    private final boolean isInherited;

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.attributesKey;
    }

    @Nullable
    public String getPresentableText() {
        return this.elementText;
    }

    @Nullable
    public String getLocationString() {
        return this.locationString;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.icon;
    }

    @NotNull
    public String getLocationPrefix() {
        return this.isInherited ? " " : " (";
    }

    @NotNull
    public String getLocationSuffix() {
        return this.isInherited ? "" : ")";
    }

    private final TextAttributesKey getElementAttributesKey(boolean isInherited, NavigatablePsiElement navigatablePsiElement) {
        if (isInherited) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        if (navigatablePsiElement instanceof KtModifierListOwner && KtPsiUtil.isDeprecated((KtModifierListOwner)navigatablePsiElement)) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    private final Icon getElementIcon(NavigatablePsiElement navigatablePsiElement, DeclarationDescriptor descriptor2) {
        if (descriptor2 != null) {
            return KotlinDescriptorIconProvider.getIcon(descriptor2, (PsiElement)navigatablePsiElement, 1);
        }
        if (!navigatablePsiElement.isValid()) {
            return null;
        }
        return PsiIconUtil.getProvidersIcon((PsiElement)((PsiElement)navigatablePsiElement), (int)1);
    }

    private final String getElementText(NavigatablePsiElement navigatablePsiElement, DeclarationDescriptor descriptor2) {
        block6: {
            Object object;
            StringBuilder stringBuilder;
            block8: {
                block7: {
                    if (!(navigatablePsiElement instanceof KtObjectDeclaration) || !((KtObjectDeclaration)navigatablePsiElement).isObjectLiteral()) break block6;
                    stringBuilder = new StringBuilder().append("object");
                    object = ((KtObjectDeclaration)navigatablePsiElement).getSuperTypeList();
                    if (object == null || (object = object.getText()) == null) break block7;
                    Object object2 = object;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Object it = object2;
                    String string = " : " + (String)it;
                    stringBuilder = stringBuilder2;
                    object = string;
                    if (object != null) break block8;
                }
                object = "";
            }
            return stringBuilder.append(object).toString();
        }
        if (descriptor2 != null) {
            return DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(descriptor2);
        }
        String text2 = navigatablePsiElement.getName();
        CharSequence charSequence = text2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return text2;
        }
        if (navigatablePsiElement instanceof KtAnonymousInitializer) {
            return "<class initializer>";
        }
        return null;
    }

    private final String getElementLocationString(boolean isInherited, DeclarationDescriptor descriptor2) {
        String string;
        if (!isInherited || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)descriptor2).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION))) {
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            return this.withRightArrow(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(declarationDescriptor));
        }
        Set<CallableMemberDescriptor> overridingDescriptors = OverridingUtil.filterOutOverridden(DescriptorUtils.getAllOverriddenDeclarations((CallableMemberDescriptor)descriptor2));
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)CollectionsKt.firstOrNull((Iterable)overridingDescriptors);
        if (callableMemberDescriptor != null) {
            CallableMemberDescriptor callableMemberDescriptor2;
            CallableMemberDescriptor it = callableMemberDescriptor2 = callableMemberDescriptor;
            DeclarationDescriptor declarationDescriptor = it.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"it.containingDeclaration");
            string = this.withRightArrow(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(declarationDescriptor));
        } else {
            string = null;
        }
        return string;
    }

    private final String withRightArrow(String str) {
        String string;
        char rightArrow = '\u2192';
        if (UIUtil.getLabelFont().canDisplay(rightArrow)) {
            char c = rightArrow;
            string = String.valueOf(c) + str;
        } else {
            string = "->" + str;
        }
        return string;
    }

    public KotlinStructureElementPresentation(boolean isInherited, @NotNull NavigatablePsiElement navigatablePsiElement, @Nullable DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)navigatablePsiElement, (String)"navigatablePsiElement");
        this.isInherited = isInherited;
        this.attributesKey = this.getElementAttributesKey(this.isInherited, navigatablePsiElement);
        this.elementText = this.getElementText(navigatablePsiElement, descriptor2);
        this.locationString = this.getElementLocationString(this.isInherited, descriptor2);
        this.icon = this.getElementIcon(navigatablePsiElement, descriptor2);
    }
}

