/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureForResolvedCallKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;

public class ResolutionResultsHandler {
    private final OverloadingConflictResolver<MutableResolvedCall<?>> overloadingConflictResolver;

    public ResolutionResultsHandler(@NotNull KotlinBuiltIns builtIns, @NotNull TypeSpecificityComparator specificityComparator) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "<init>"));
        }
        if (specificityComparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specificityComparator", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "<init>"));
        }
        this.overloadingConflictResolver = FlatSignatureForResolvedCallKt.createOverloadingConflictResolver(builtIns, specificityComparator);
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Collection<MutableResolvedCall<D>> candidates2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        LinkedHashSet successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates2) {
            ResolutionStatus status2 = candidateCall.getStatus();
            assert (status2 != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status2.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeSuccessfulResult(context, tracing, successfulCandidates, incompleteCandidates, context.checkArguments, languageVersionSettings);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!failedCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeFailedResult(tracing, context.trace, failedCandidates, context.checkArguments, languageVersionSettings);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(context.trace, candidatesWithWrongReceiver);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        tracing.unresolvedReference(context.trace);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(@NotNull CallResolutionContext context, @NotNull TracingStrategy tracing, @NotNull Set<MutableResolvedCall<D>> successfulCandidates, @NotNull Set<MutableResolvedCall<D>> incompleteCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (successfulCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (incompleteCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompleteCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        LinkedHashSet successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results2 = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true, context.isDebuggerContext, checkArgumentsMode, languageVersionSettings);
        if (results2.isSingleResult()) {
            ResolvedCall resultingCall = results2.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(context.trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (results2.isAmbiguity()) {
            tracing.recordAmbiguity(context.trace, results2.getResultingCalls());
            boolean allCandidatesIncomplete = ResolutionResultsHandler.allIncomplete(results2.getResultingCalls());
            if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS || !CallUtilKt.hasUnresolvedArguments(context.call, context)) {
                if (allCandidatesIncomplete) {
                    tracing.cannotCompleteResolve(context.trace, results2.getResultingCalls());
                } else {
                    tracing.ambiguity(context.trace, results2.getResultingCalls());
                }
            }
            if (allCandidatesIncomplete) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(results2.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results2;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Set<MutableResolvedCall<D>> failedCandidates, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates.size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, failedCandidates);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
            }
            return overloadResolutionResultsImpl;
        }
        for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
            LinkedHashSet thisLevel = Sets.newLinkedHashSet();
            for (MutableResolvedCall<D> candidate : failedCandidates) {
                if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                thisLevel.add(candidate);
            }
            if (thisLevel.isEmpty()) continue;
            if (severityLevel.contains((Object)ResolutionStatus.ARGUMENTS_MAPPING_ERROR)) {
                OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, myResolver.filterOutEquivalentCalls(new LinkedHashSet(thisLevel)));
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                }
                return overloadResolutionResultsImpl;
            }
            OverloadResolutionResultsImpl<D> results2 = this.chooseAndReportMaximallySpecific(thisLevel, false, false, checkArgumentsMode, languageVersionSettings);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(tracing, trace, results2.getResultingCalls());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
            }
            return overloadResolutionResultsImpl;
        }
        throw new AssertionError((Object)("Should not be reachable, cause every status must belong to some level: " + failedCandidates));
    }

    @NotNull
    private static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> recordFailedInfo(@NotNull TracingStrategy tracing, @NotNull BindingTrace trace, @NotNull Collection<MutableResolvedCall<D>> candidates2) {
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates2.size() == 1) {
            MutableResolvedCall<D> failed = candidates2.iterator().next();
            failed.getTrace().moveAllMyDataTo(trace);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(failed);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
            }
            return overloadResolutionResultsImpl;
        }
        tracing.noneApplicable(trace, candidates2);
        tracing.recordAmbiguity(trace, candidates2);
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(candidates2);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        return overloadResolutionResultsImpl;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results2) {
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "allIncomplete"));
        }
        for (MutableResolvedCall<D> result2 : results2) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates2, boolean discriminateGenerics, boolean isDebuggerContext, @NotNull CheckArgumentTypesMode checkArgumentsMode, @NotNull LanguageVersionSettings languageVersionSettings) {
        Set<MutableResolvedCall<D>> specificCalls;
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (checkArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArgumentsMode", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        OverloadingConflictResolver<MutableResolvedCall<?>> myResolver = this.overloadingConflictResolver;
        Set<MutableResolvedCall<D>> refinedCandidates = candidates2;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.RefinedSamAdaptersPriority)) {
            HashSet<MutableResolvedCall<D>> nonSynthesized = new HashSet<MutableResolvedCall<D>>();
            for (MutableResolvedCall<D> candidate : candidates2) {
                if (TowerUtilsKt.isSynthesized(candidate.getCandidateDescriptor())) continue;
                nonSynthesized.add(candidate);
            }
            if (!nonSynthesized.isEmpty()) {
                refinedCandidates = nonSynthesized;
            }
        }
        if ((specificCalls = myResolver.chooseMaximallySpecificCandidates(refinedCandidates, checkArgumentsMode, discriminateGenerics, isDebuggerContext)).size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(specificCalls.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(specificCalls);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        return overloadResolutionResultsImpl;
    }
}

