/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ExpressionTypingUtils {
    @Nullable
    public static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull KtExpression expression2, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getExpressionReceiver"));
        }
        KotlinType type2 = facade.getTypeInfo(expression2, context).getType();
        if (type2 == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(expression2, type2, context.trace.getBindingContext());
    }

    @NotNull
    public static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull KtExpression expression2, ExpressionTypingContext context) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        KotlinType type2 = ExpressionTypingUtils.safeGetType(facade.safeGetTypeInfo(expression2, context));
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(expression2, type2, context.trace.getBindingContext());
        if (expressionReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetExpressionReceiver"));
        }
        return expressionReceiver;
    }

    @NotNull
    public static KotlinType safeGetType(@NotNull KotlinTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        KotlinType type2 = typeInfo.getType();
        assert (type2 != null) : "safeGetType should be invoked on safe KotlinTypeInfo; safeGetTypeInfo should return @NotNull type";
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "safeGetType"));
        }
        return kotlinType;
    }

    @NotNull
    public static LexicalWritableScope newWritableScopeImpl(@NotNull ExpressionTypingContext context, @NotNull LexicalScopeKind scopeKind, @NotNull OverloadChecker overloadChecker) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        if (scopeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeKind", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        if (overloadChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadChecker", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        LexicalWritableScope lexicalWritableScope = new LexicalWritableScope(context.scope, context.scope.getOwnerDescriptor(), false, new TraceBasedLocalRedeclarationChecker(context.trace, overloadChecker), scopeKind);
        if (lexicalWritableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "newWritableScopeImpl"));
        }
        return lexicalWritableScope;
    }

    public static KtExpression createFakeExpressionOfType(@NotNull Project project, @NotNull BindingTrace trace, @NotNull String argumentName2, @NotNull KotlinType argumentType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentName", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        if (argumentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentType", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "createFakeExpressionOfType"));
        }
        KtExpression fakeExpression = KtPsiFactoryKt.KtPsiFactory(project, false).createExpression(argumentName2);
        trace.recordType(fakeExpression, argumentType);
        trace.record(BindingContext.PROCESSED, fakeExpression);
        return fakeExpression;
    }

    public static void checkVariableShadowing(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull VariableDescriptor variableDescriptor) {
        PsiElement declaration2;
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "checkVariableShadowing"));
        }
        VariableDescriptor oldDescriptor = ScopeUtilsKt.findLocalVariable(scope2, variableDescriptor.getName());
        if (oldDescriptor != null && ExpressionTypingUtils.isLocal(variableDescriptor.getContainingDeclaration(), oldDescriptor) && (declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(variableDescriptor)) != null) {
            PsiElement oldElement;
            if (declaration2 instanceof KtDestructuringDeclarationEntry && declaration2.getParent().getParent() instanceof KtParameter && (oldElement = DescriptorToSourceUtils.descriptorToDeclaration(oldDescriptor)) != null && oldElement.getParent().equals(declaration2.getParent().getParent().getParent())) {
                return;
            }
            trace.report(Errors.NAME_SHADOWING.on(declaration2, variableDescriptor.getName().asString()));
        }
    }

    public static ObservableBindingTrace makeTraceInterceptingTypeMismatch(@NotNull BindingTrace trace, final @NotNull KtElement expressionToWatch, final @NotNull boolean[] mismatchFound) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (expressionToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToWatch", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        if (mismatchFound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mismatchFound", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "makeTraceInterceptingTypeMismatch"));
        }
        return new ObservableBindingTrace(trace){

            @Override
            public void report(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils$1", "report"));
                }
                DiagnosticFactory<?> factory2 = diagnostic.getFactory();
                if (Errors.TYPE_MISMATCH_ERRORS.contains(factory2) && diagnostic.getPsiElement() == expressionToWatch) {
                    mismatchFound[0] = true;
                }
                if (Errors.TYPE_INFERENCE_ERRORS.contains(factory2) && PsiTreeUtil.isAncestor((PsiElement)expressionToWatch, (PsiElement)diagnostic.getPsiElement(), (boolean)false)) {
                    mismatchFound[0] = true;
                }
                super.report(diagnostic);
            }
        };
    }

    @NotNull
    public static KotlinTypeInfo getTypeInfoOrNullType(@Nullable KtExpression expression2, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        KotlinTypeInfo kotlinTypeInfo = expression2 != null ? facade.getTypeInfo(expression2, context) : TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getTypeInfoOrNullType"));
        }
        return kotlinTypeInfo;
    }

    public static boolean isBinaryExpressionDependentOnExpectedType(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isBinaryExpressionDependentOnExpectedType"));
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        return operationType == KtTokens.IDENTIFIER || OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)operationType) || operationType == KtTokens.ELVIS;
    }

    public static boolean isUnaryExpressionDependentOnExpectedType(@NotNull KtUnaryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "isUnaryExpressionDependentOnExpectedType"));
        }
        return expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL;
    }

    public static boolean isExclExclExpression(@Nullable KtExpression expression2) {
        return expression2 instanceof KtUnaryExpression && ((KtUnaryExpression)expression2).getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL;
    }

    @NotNull
    public static List<KotlinType> getValueParametersTypes(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        ArrayList<KotlinType> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingUtils", "getValueParametersTypes"));
        }
        return arrayList;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent2 = candidate.getContainingDeclaration();
        if (!(parent2 instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)parent2;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor2) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnExpectedType(@Nullable KtExpression expression2) {
        KtExpression expr = KtPsiUtil.deparenthesize(expression2);
        if (expr == null) {
            return false;
        }
        if (expr instanceof KtBinaryExpressionWithTypeRHS) {
            return false;
        }
        if (expr instanceof KtBinaryExpression) {
            return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType((KtBinaryExpression)expr);
        }
        if (expr instanceof KtUnaryExpression) {
            return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType((KtUnaryExpression)expr);
        }
        return true;
    }

    private ExpressionTypingUtils() {
    }

    public static boolean isFunctionLiteral(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof AnonymousFunctionDescriptor;
    }

    public static boolean isLocalFunction(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 != null && descriptor2.getClass() == SimpleFunctionDescriptorImpl.class) {
            return ((SimpleFunctionDescriptorImpl)descriptor2).getVisibility() == Visibilities.LOCAL;
        }
        return false;
    }

    public static boolean isFunctionExpression(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionExpressionDescriptor;
    }
}

