/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.util.BitUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssPrefixInfo {
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final Collection<CssPrefix> myEnabledPrefixes;

    public CssPrefixInfo(@NotNull String propertyName, CssPrefix ... enabledPrefixes) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo", "<init>"));
        }
        this.myPropertyName = propertyName;
        this.myEnabledPrefixes = Sets.newHashSet((Object[])enabledPrefixes);
        for (CssPrefix prefix : enabledPrefixes) {
            this.setValue(prefix, true);
        }
    }

    public CssPrefixInfo(@NotNull String propertyName, Collection<CssPrefix> enabledPrefixes) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo", "<init>"));
        }
        this.myPropertyName = propertyName;
        this.myEnabledPrefixes = Sets.newHashSet(enabledPrefixes);
        for (CssPrefix prefix : enabledPrefixes) {
            this.setValue(prefix, true);
        }
    }

    @NotNull
    public Collection<CssPrefix> getEnabledPrefixes() {
        Collection<CssPrefix> collection = this.myEnabledPrefixes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo", "getEnabledPrefixes"));
        }
        return collection;
    }

    public void setValue(CssPrefix prefix, boolean value) {
        if (value) {
            this.myEnabledPrefixes.add(prefix);
        } else {
            this.myEnabledPrefixes.remove((Object)prefix);
        }
    }

    public boolean getValue(CssPrefix prefix) {
        return this.myEnabledPrefixes.contains((Object)prefix);
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo", "getPropertyName"));
        }
        return string;
    }

    public static CssPrefixInfo fromIntegerValue(String propertyName, Integer value) {
        if (value == null) {
            return new CssPrefixInfo(propertyName, new CssPrefix[0]);
        }
        ArrayList enabledPrefixes = Lists.newArrayList();
        for (CssPrefix prefix : CssPrefix.values()) {
            if (!BitUtil.isSet((int)value, (int)prefix.myIntMask)) continue;
            enabledPrefixes.add(prefix);
        }
        return new CssPrefixInfo(propertyName, enabledPrefixes);
    }

    public int toIntegerValue() {
        int result = 0;
        for (CssPrefix prefix : this.myEnabledPrefixes) {
            if (!this.getValue(prefix)) continue;
            result |= prefix.myIntMask;
        }
        return result;
    }

    public String toString() {
        return "CssPrefixInfo{myPropertyName='" + this.myPropertyName + '\'' + ", myEnabledPrefixes=" + this.myEnabledPrefixes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssPrefixInfo that = (CssPrefixInfo)o;
        if (!this.myEnabledPrefixes.equals(that.myEnabledPrefixes)) {
            return false;
        }
        return this.myPropertyName.equals(that.myPropertyName);
    }

    public int hashCode() {
        int result = this.myPropertyName.hashCode();
        result = 31 * result + this.myEnabledPrefixes.hashCode();
        return result;
    }
}

