/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class OgnlBlock
implements ASTBlock {
    private final ASTNode astNode;
    private final SpacingBuilder spacingBuilder;
    private List<Block> blocks;

    OgnlBlock(ASTNode astNode, SpacingBuilder spacingBuilder) {
        this.astNode = astNode;
        this.spacingBuilder = spacingBuilder;
    }

    public ASTNode getNode() {
        return this.astNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.astNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ognl/formatting/OgnlBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.blocks == null) {
            this.blocks = this.buildSubBlocks();
        }
        ArrayList<Block> arrayList = new ArrayList<Block>(this.blocks);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ognl/formatting/OgnlBlock", "getSubBlocks"));
        }
        return arrayList;
    }

    private List<Block> buildSubBlocks() {
        ArrayList<OgnlBlock> myBlocks = new ArrayList<OgnlBlock>();
        for (ASTNode child = this.astNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getTextRange().getLength() == 0 || child.getElementType() == TokenType.WHITE_SPACE) continue;
            myBlocks.add(new OgnlBlock(child, this.spacingBuilder));
        }
        return Collections.unmodifiableList(myBlocks);
    }

    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return Indent.getNoneIndent();
    }

    public Alignment getAlignment() {
        return null;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/ognl/formatting/OgnlBlock", "getSpacing"));
        }
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ognl/formatting/OgnlBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return this.astNode.getFirstChildNode() == null;
    }
}

