/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.processing;

import android.databinding.tool.processing.ScopedErrorReport;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.FileScopeProvider;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class Scope {
    private static ThreadLocal<ScopeEntry> sScopeItems = new ThreadLocal();
    static List<ScopedException> sDeferredExceptions = new ArrayList<ScopedException>();

    public static void enter(final Location location) {
        Scope.enter(new LocationScopeProvider(){

            @Override
            public List<Location> provideScopeLocation() {
                return Collections.singletonList(location);
            }
        });
    }

    public static void enter(ScopeProvider scopeProvider) {
        ScopeEntry peek = sScopeItems.get();
        ScopeEntry entry = new ScopeEntry(scopeProvider, peek);
        sScopeItems.set(entry);
    }

    public static void exit() {
        ScopeEntry entry = sScopeItems.get();
        Preconditions.checkNotNull(entry, "Inconsistent scope exit", new Object[0]);
        sScopeItems.set(entry.mParent);
    }

    public static void defer(ScopedException exception) {
        sDeferredExceptions.add(exception);
    }

    private static void registerErrorInternal(String msg, int scopeIndex, ScopeProvider ... scopeProviders) {
        if (scopeProviders == null || scopeProviders.length <= scopeIndex) {
            Scope.defer(new ScopedException(msg, new Object[0]));
        } else if (scopeProviders[scopeIndex] == null) {
            Scope.registerErrorInternal(msg, scopeIndex + 1, scopeProviders);
        } else {
            try {
                Scope.enter(scopeProviders[scopeIndex]);
                Scope.registerErrorInternal(msg, scopeIndex + 1, scopeProviders);
            }
            finally {
                Scope.exit();
            }
        }
    }

    public static void registerError(String msg, ScopeProvider ... scopeProviders) {
        Scope.registerErrorInternal(msg, 0, scopeProviders);
    }

    public static void assertNoError() {
        if (sDeferredExceptions.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> messages = new HashSet<String>();
        for (ScopedException ex : sDeferredExceptions) {
            String message = ex.getMessage();
            if (messages.contains(message)) continue;
            sb.append(message).append("\n");
            messages.add(message);
        }
        throw new RuntimeException("Found data binding errors.\n" + sb.toString());
    }

    static String produceScopeLog() {
        StringBuilder sb = new StringBuilder();
        sb.append("full scope log\n");
        ScopeEntry top = sScopeItems.get();
        while (top != null) {
            ScopeProvider provider = top.mProvider;
            sb.append("---").append(provider).append("\n");
            if (provider instanceof FileScopeProvider) {
                sb.append("file:").append(((FileScopeProvider)provider).provideScopeFilePath()).append("\n");
            }
            if (provider instanceof LocationScopeProvider) {
                LocationScopeProvider loc = (LocationScopeProvider)provider;
                sb.append("loc:");
                List<Location> locations = loc.provideScopeLocation();
                if (locations == null) {
                    sb.append("null\n");
                } else {
                    for (Location location : locations) {
                        sb.append(location).append("\n");
                    }
                }
            }
            top = top.mParent;
        }
        sb.append("---\n");
        return sb.toString();
    }

    static ScopedErrorReport createReport() {
        ScopeEntry top = sScopeItems.get();
        String filePath = null;
        List<Location> locations = null;
        while (top != null && (filePath == null || locations == null)) {
            ScopeProvider provider = top.mProvider;
            if (locations == null && provider instanceof LocationScopeProvider) {
                locations = Scope.findAbsoluteLocationFrom(top, (LocationScopeProvider)provider);
            }
            if (filePath == null && provider instanceof FileScopeProvider) {
                filePath = ((FileScopeProvider)provider).provideScopeFilePath();
            }
            top = top.mParent;
        }
        return new ScopedErrorReport(filePath, locations);
    }

    private static List<Location> findAbsoluteLocationFrom(ScopeEntry entry, LocationScopeProvider top) {
        List<Location> locations = top.provideScopeLocation();
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        if (locations.size() == 1) {
            return Collections.singletonList(locations.get(0).toAbsoluteLocation());
        }
        ArrayList<Location> chosen = new ArrayList<Location>();
        for (Location location : locations) {
            Location absLocation = location.toAbsoluteLocation();
            if (!Scope.validatedContained(entry.mParent, absLocation)) continue;
            chosen.add(absLocation);
        }
        return chosen.isEmpty() ? locations : chosen;
    }

    private static boolean validatedContained(ScopeEntry parent, Location absLocation) {
        if (parent == null) {
            return true;
        }
        ScopeProvider provider = parent.mProvider;
        if (!(provider instanceof LocationScopeProvider)) {
            return Scope.validatedContained(parent.mParent, absLocation);
        }
        List<Location> absoluteParents = Scope.findAbsoluteLocationFrom(parent, (LocationScopeProvider)provider);
        if (absoluteParents != null) {
            for (Location location : absoluteParents) {
                if (!location.contains(absLocation)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ScopeEntry {
        ScopeProvider mProvider;
        ScopeEntry mParent;

        public ScopeEntry(ScopeProvider scopeProvider, ScopeEntry parent) {
            this.mProvider = scopeProvider;
            this.mParent = parent;
        }
    }
}

