/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.zkm.ZKMBundle;
import com.intellij.zkm.ZKMLog;
import com.intellij.zkm.ZKMLogReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZKMUnscrambleSupport
implements UnscrambleSupport<JComponent> {
    @NotNull
    public String getPresentableName() {
        String string = ZKMBundle.message("zkm.unscrambler.presentable.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/ZKMUnscrambleSupport", "getPresentableName"));
        }
        return string;
    }

    public JComponent createSettingsComponent() {
        return new JLabel(ZKMBundle.message("zkm.unscrambler.notice", new Object[0]));
    }

    @Nullable
    public String unscramble(@NotNull Project project, @NotNull String text, @NotNull String logName, JComponent settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/zkm/ZKMUnscrambleSupport", "unscramble"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/zkm/ZKMUnscrambleSupport", "unscramble"));
        }
        if (logName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logName", "com/intellij/zkm/ZKMUnscrambleSupport", "unscramble"));
        }
        try {
            ZKMLog log = ZKMLogReader.readLog(logName);
            log.setProject(project);
            return log.unscrambleStackTrace(ZKMUnscrambleSupport.mergeLines(text));
        }
        catch (IOException e) {
            Messages.showMessageDialog((Project)project, (String)(e.getMessage() + "\n" + e.toString()), (String)ZKMBundle.message("zkm.error.reading.log.file", new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    private static String mergeLines(String text) {
        text = StringUtil.replace((String)text, (String)"\r\n", (String)"\n");
        text = StringUtil.replace((String)text, (String)"\r", (String)"\n");
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        StringBuilder tempBuffer = new StringBuilder();
        while (tokenizer.hasMoreElements()) {
            String s = (String)tokenizer.nextElement();
            if (s.endsWith(" at") || s.endsWith("\tat ")) {
                s = s + ' ';
            }
            s = s + "\n";
            if (tempBuffer.length() == 0 && !ZKMUnscrambleSupport.isStartOfStackLine(s)) {
                result.append(s);
                continue;
            }
            tempBuffer.append(s);
            if (s.indexOf(41) == -1) continue;
            String line = tempBuffer.toString();
            tempBuffer.setLength(0);
            line = ZKMUnscrambleSupport.removeLineBreaks(line);
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    private static String removeLineBreaks(String lines) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(lines, "\n");
        while (tokenizer.hasMoreElements()) {
            String s = (String)tokenizer.nextElement();
            if (buffer.length() > 0 && StringUtil.startsWithChar((CharSequence)s, (char)'>')) {
                if (s.startsWith("> ")) {
                    if (!StringUtil.startsWithConcatenation((String)s, (String[])new String[]{"> ", "at "})) {
                        s = s.substring(2);
                    }
                } else {
                    s = s.substring(1);
                }
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    private static boolean isStartOfStackLine(String s) {
        return s.contains(" at") || s.contains("\tat ") || s.startsWith("at ");
    }
}

