/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.zkm.bytecode.ClassProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectClasses
implements ClassProvider {
    private final Project myProject;

    ProjectClasses(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean contains(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/ProjectClasses", "contains"));
        }
        return this.findClassFile(className) != null;
    }

    @Nullable
    private VirtualFile findClassFile(@NotNull String className) {
        VirtualFile productionPath;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/ProjectClasses", "findClassFile"));
        }
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)className);
        if (psiClass == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance((Module)module);
        if (moduleExtension == null) {
            return null;
        }
        String relativeClassPath = className.replace('.', '/') + ".class";
        VirtualFile productionOutputBase = moduleExtension.getCompilerOutputPath();
        VirtualFile virtualFile = productionPath = productionOutputBase != null ? productionOutputBase.findFileByRelativePath(relativeClassPath) : null;
        if (productionPath != null) {
            return productionPath;
        }
        VirtualFile testOutputBase = moduleExtension.getCompilerOutputPathForTests();
        return testOutputBase != null ? testOutputBase.findFileByRelativePath(relativeClassPath) : null;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull String className) throws IOException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/ProjectClasses", "getInputStream"));
        }
        VirtualFile classFile = this.findClassFile(className);
        if (classFile == null) {
            throw new NoSuchElementException(className);
        }
        InputStream inputStream = classFile.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/ProjectClasses", "getInputStream"));
        }
        return inputStream;
    }
}

