/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Modifier;
import com.intellij.zkm.bytecode.Named;
import com.intellij.zkm.bytecode.Type;
import com.intellij.zkm.bytecode.Utilities;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class Signature
implements Named {
    private final Set<Modifier> myModifiers;
    private final Type myReturnType;
    private final String myName;
    private final List<Type> myParameterTypes;

    Signature(@NotNull Set<Modifier> modifiers, @NotNull Type returnType, @NotNull String name, @NotNull List<Type> parameterTypes) {
        if (modifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/zkm/bytecode/Signature", "<init>"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "com/intellij/zkm/bytecode/Signature", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/zkm/bytecode/Signature", "<init>"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/zkm/bytecode/Signature", "<init>"));
        }
        this.myModifiers = modifiers;
        this.myReturnType = returnType;
        this.myName = name;
        this.myParameterTypes = parameterTypes;
    }

    @NotNull
    Set<Modifier> getModifiers() {
        Set<Modifier> set = Collections.unmodifiableSet(this.myModifiers);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Signature", "getModifiers"));
        }
        return set;
    }

    @NotNull
    Type getReturnType() {
        Type type = this.myReturnType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Signature", "getReturnType"));
        }
        return type;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Signature", "getName"));
        }
        return string;
    }

    @NotNull
    List<Type> getParameterTypes() {
        List<Type> list = Collections.unmodifiableList(this.myParameterTypes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/Signature", "getParameterTypes"));
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature that = (Signature)o;
        if (!this.myModifiers.equals(that.myModifiers)) {
            return false;
        }
        if (!this.myReturnType.equals(that.myReturnType)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myParameterTypes.equals(that.myParameterTypes);
    }

    public int hashCode() {
        int result = this.myModifiers.hashCode();
        result = 31 * result + this.myReturnType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myParameterTypes.hashCode();
        return result;
    }

    public String toString() {
        List<String> modifiers = Named.namesOf(this.myModifiers).stream().sorted().collect(Collectors.toList());
        return String.format("%s %s %s(%s)", Utilities.join(modifiers, " "), this.myReturnType, this.myName, Utilities.join(Named.namesOf(this.myParameterTypes)));
    }
}

