/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.Properties;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.ShowJavadocAction;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyEditorAdapter;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.properties.BorderProperty;
import com.intellij.uiDesigner.propertyInspector.properties.ButtonGroupProperty;
import com.intellij.uiDesigner.propertyInspector.properties.ClassToBindProperty;
import com.intellij.uiDesigner.propertyInspector.properties.ClientPropertiesProperty;
import com.intellij.uiDesigner.propertyInspector.properties.CustomCreateProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HSizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HorzAlignProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IndentProperty;
import com.intellij.uiDesigner.propertyInspector.properties.LayoutManagerProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MarginProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MaximumSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MinimumSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.PreferredSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.SameSizeHorizontallyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.SameSizeVerticallyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.UseParentLayoutProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VSizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VertAlignProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.IndentedIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import icons.UIDesignerIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyInspectorTable
extends Table
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.PropertyInspectorTable");
    public static final DataKey<PropertyInspectorTable> DATA_KEY = DataKey.create((String)PropertyInspectorTable.class.getName());
    private static final Color SYNTETIC_PROPERTY_BACKGROUND = new JBColor((Color)Gray._230, UIUtil.getPanelBackground().brighter());
    private static final Color SYNTETIC_SUBPROPERTY_BACKGROUND = new JBColor((Color)Gray._240, UIUtil.getPanelBackground().brighter());
    private final ComponentTree myComponentTree;
    private final ArrayList<Property> myProperties;
    private final MyModel myModel;
    private final MyCompositeTableCellRenderer myCellRenderer;
    private final MyCellEditor myCellEditor;
    private GuiEditor myEditor;
    private final MyPropertyEditorListener myPropertyEditorListener;
    private final MyLafManagerListener myLafManagerListener;
    private final HashSet<String> myExpandedProperties;
    @NotNull
    private final List<RadComponent> mySelection;
    private boolean myShowExpertProperties;
    private final Map<HighlightSeverity, SimpleTextAttributes> myHighlightAttributes;
    private final Map<HighlightSeverity, SimpleTextAttributes> myModifiedHighlightAttributes;
    private final ClassToBindProperty myClassToBindProperty;
    private final BindingProperty myBindingProperty;
    private final BorderProperty myBorderProperty;
    private final LayoutManagerProperty myLayoutManagerProperty;
    private final ButtonGroupProperty myButtonGroupProperty;
    private boolean myInsideSynch;
    private boolean myStoppingEditing;
    private final Project myProject;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.inspector";

    PropertyInspectorTable(Project project, @NotNull ComponentTree componentTree) {
        if (componentTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTree", "com/intellij/uiDesigner/propertyInspector/PropertyInspectorTable", "<init>"));
        }
        this.mySelection = new ArrayList<RadComponent>();
        this.myHighlightAttributes = new HashMap<HighlightSeverity, SimpleTextAttributes>();
        this.myModifiedHighlightAttributes = new HashMap<HighlightSeverity, SimpleTextAttributes>();
        this.myLayoutManagerProperty = new LayoutManagerProperty();
        this.myButtonGroupProperty = new ButtonGroupProperty();
        this.myProject = project;
        this.myClassToBindProperty = new ClassToBindProperty(project);
        this.myBindingProperty = new BindingProperty(project);
        this.myBorderProperty = new BorderProperty(project);
        this.myPropertyEditorListener = new MyPropertyEditorListener();
        this.myLafManagerListener = new MyLafManagerListener();
        this.myComponentTree = componentTree;
        this.myProperties = new ArrayList();
        this.myExpandedProperties = new HashSet();
        this.myModel = new MyModel();
        this.setModel(this.myModel);
        this.setSelectionMode(0);
        this.myCellRenderer = new MyCompositeTableCellRenderer();
        this.myCellEditor = new MyCellEditor();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = PropertyInspectorTable.this.rowAtPoint(e.getPoint());
                int column = PropertyInspectorTable.this.columnAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                Property property = (Property)PropertyInspectorTable.this.myProperties.get(row);
                int indent = PropertyInspectorTable.getPropertyIndentDepth(property) * PropertyInspectorTable.getPropertyIndentWidth();
                Rectangle rect = PropertyInspectorTable.this.getCellRect(row, PropertyInspectorTable.this.convertColumnIndexToView(0), false);
                Component rendererComponent = PropertyInspectorTable.this.myCellRenderer.getTableCellRendererComponent((JTable)((Object)PropertyInspectorTable.this), property, false, false, row, column);
                if (!rect.contains(e.getX(), e.getY()) || !(rendererComponent instanceof ColoredTableCellRenderer) || ((ColoredTableCellRenderer)rendererComponent).findFragmentAt(e.getX()) != -2 || e.getX() < rect.x + indent) {
                    return;
                }
                Property[] children = PropertyInspectorTable.this.getPropChildren(property);
                if (children.length == 0) {
                    return;
                }
                if (PropertyInspectorTable.this.isPropertyExpanded(property)) {
                    PropertyInspectorTable.this.collapseProperty(row);
                } else {
                    PropertyInspectorTable.this.expandProperty(row);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                Property property;
                int row = PropertyInspectorTable.this.rowAtPoint(e.getPoint());
                int column = PropertyInspectorTable.this.columnAtPoint(e.getPoint());
                if (row >= 0 && column == 0 && PropertyInspectorTable.this.getPropChildren(property = (Property)PropertyInspectorTable.this.myProperties.get(row)).length == 0) {
                    PropertyInspectorTable.this.startEditing(row);
                    return true;
                }
                return false;
            }
        }.installOn((Component)((Object)this));
        AnAction quickJavadocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        new ShowJavadocAction().registerCustomShortcutSet(quickJavadocAction.getShortcutSet(), (JComponent)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)((ActionGroup)ActionManager.getInstance().getAction("GuiDesigner.PropertyInspectorPopupMenu")), (String)"GuiDesigner.PropertyInspectorPopup", (ActionManager)ActionManager.getInstance());
    }

    public void setEditor(GuiEditor editor) {
        this.finishEditing();
        this.myEditor = editor;
        if (this.myEditor == null) {
            this.mySelection.clear();
            this.myProperties.clear();
            this.myModel.fireTableDataChanged();
        }
    }

    @Nullable
    public IntrospectedProperty getSelectedIntrospectedProperty() {
        Property property = this.getSelectedProperty();
        if (property == null || !(property instanceof IntrospectedProperty)) {
            return null;
        }
        return (IntrospectedProperty)property;
    }

    @Nullable
    public Property getSelectedProperty() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= this.getRowCount()) {
            return null;
        }
        return this.myProperties.get(selectedRow);
    }

    public PsiClass getComponentClass() {
        Module module = this.myEditor.getModule();
        if (this.mySelection.size() == 0) {
            return null;
        }
        String className = this.mySelection.get(0).getComponentClassName();
        for (int i = 1; i < this.mySelection.size(); ++i) {
            if (Comparing.equal((String)this.mySelection.get(i).getComponentClassName(), (String)className)) continue;
            return null;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    public Object getData(String dataId) {
        if (((Object)((Object)this)).getClass().getName().equals(dataId)) {
            return this;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            IntrospectedProperty introspectedProperty = this.getSelectedIntrospectedProperty();
            if (introspectedProperty == null) {
                return null;
            }
            PsiClass aClass = this.getComponentClass();
            if (aClass == null) {
                return null;
            }
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
            if (getter != null) {
                return getter;
            }
            return PropertyUtil.findPropertySetter((PsiClass)aClass, (String)introspectedProperty.getName(), (boolean)false, (boolean)true);
        }
        if (CommonDataKeys.PSI_FILE.is(dataId) && this.myEditor != null) {
            return PsiManager.getInstance((Project)this.myEditor.getProject()).findFile(this.myEditor.getFile());
        }
        if (GuiEditor.DATA_KEY.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            GuiEditor designer = this.myProject.isDisposed() ? null : DesignerToolWindowManager.getInstance(this.myProject).getActiveFormEditor();
            return designer == null ? null : designer.getEditor();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        return null;
    }

    void setShowExpertProperties(boolean showExpertProperties) {
        if (this.myShowExpertProperties == showExpertProperties) {
            return;
        }
        this.myShowExpertProperties = showExpertProperties;
        if (this.myEditor != null) {
            this.synchWithTree(true);
        }
    }

    public void addNotify() {
        super.addNotify();
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this.myLafManagerListener);
    }

    public void removeNotify() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this.myLafManagerListener);
        super.removeNotify();
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        ActionMap actionMap = this.getActionMap();
        InputMap focusedInputMap = this.getInputMap(0);
        InputMap ancestorInputMap = this.getInputMap(1);
        actionMap.put("selectPreviousRow", new MySelectPreviousRowAction());
        actionMap.put("selectNextRow", new MySelectNextRowAction());
        actionMap.put("startEditing", new MyStartEditingAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(113, 0));
        actionMap.put("smartEnter", new MyEnterAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(10, 0), "smartEnter");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        ancestorInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("expandCurrent", new MyExpandCurrentAction(true));
        focusedInputMap.put(KeyStroke.getKeyStroke(107, 0), "expandCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(107, 0));
        actionMap.put("collapseCurrent", new MyExpandCurrentAction(false));
        focusedInputMap.put(KeyStroke.getKeyStroke(109, 0), "collapseCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(109, 0));
    }

    public void setValueAt(Object aValue, int row, int column) {
        Property property = this.myProperties.get(row);
        super.setValueAt(aValue, row, column);
        if (property.needRefreshPropertyList()) {
            this.synchWithTree(true);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchWithTree(boolean forceSynch) {
        if (this.myInsideSynch) {
            return;
        }
        this.myInsideSynch = true;
        try {
            RadComponent[] newSelection = this.myComponentTree.getSelectedComponents();
            if (!forceSynch && this.mySelection.size() == newSelection.length) {
                boolean anyChanges = false;
                for (RadComponent c : newSelection) {
                    if (this.mySelection.contains(c)) continue;
                    anyChanges = true;
                    break;
                }
                if (!anyChanges) {
                    return;
                }
            }
            this.mySelection.clear();
            Collections.addAll(this.mySelection, newSelection);
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            int selectedRow = this.getSelectedRow();
            Property selectedProperty = null;
            if (selectedRow >= 0 && selectedRow < this.myProperties.size()) {
                selectedProperty = this.myProperties.get(selectedRow);
            }
            this.collectPropertiesForSelection();
            this.myModel.fireTableDataChanged();
            ArrayList<Property> reversePath = new ArrayList<Property>(2);
            while (selectedProperty != null) {
                reversePath.add(selectedProperty);
                selectedProperty = selectedProperty.getParent();
            }
            int indexToSelect = -1;
            for (int i = reversePath.size() - 1; i >= 0; --i) {
                Property property = (Property)reversePath.get(i);
                int index = PropertyInspectorTable.findPropertyByName(this.myProperties, property.getName());
                if (index == -1 && indexToSelect != -1) {
                    this.expandProperty(indexToSelect);
                    index = PropertyInspectorTable.findPropertyByName(this.myProperties, property.getName());
                    if (index == -1) break;
                    indexToSelect = index;
                    continue;
                }
                indexToSelect = index;
            }
            if (indexToSelect != -1) {
                this.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
            } else if (this.getRowCount() > 0) {
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
            TableUtil.scrollSelectionToVisible((JTable)((Object)this));
        }
        finally {
            this.myInsideSynch = false;
        }
    }

    private void collectPropertiesForSelection() {
        this.myProperties.clear();
        if (this.mySelection.size() > 0) {
            this.collectProperties(this.mySelection.get(0), this.myProperties);
            for (int propIndex = this.myProperties.size() - 1; propIndex >= 0; --propIndex) {
                if (this.myProperties.get(propIndex).appliesToSelection(this.mySelection)) continue;
                this.myProperties.remove(propIndex);
            }
            for (int i = 1; i < this.mySelection.size(); ++i) {
                ArrayList<Property> otherProperties = new ArrayList<Property>();
                this.collectProperties(this.mySelection.get(i), otherProperties);
                block2: for (int propIndex = this.myProperties.size() - 1; propIndex >= 0; --propIndex) {
                    Property[] otherChildren;
                    Property prop = this.myProperties.get(propIndex);
                    int otherPropIndex = PropertyInspectorTable.findPropertyByName(otherProperties, prop.getName());
                    if (otherPropIndex < 0) {
                        this.myProperties.remove(propIndex);
                        continue;
                    }
                    Property otherProp = otherProperties.get(otherPropIndex);
                    if (!otherProp.getClass().equals(prop.getClass())) {
                        this.myProperties.remove(propIndex);
                        continue;
                    }
                    Property[] children = prop.getChildren(this.mySelection.get(0));
                    if (children.length != (otherChildren = otherProp.getChildren(this.mySelection.get(i))).length) {
                        this.myProperties.remove(propIndex);
                        continue;
                    }
                    for (int childIndex = 0; childIndex < children.length; ++childIndex) {
                        if (Comparing.equal((String)children[childIndex].getName(), (String)otherChildren[childIndex].getName())) continue;
                        this.myProperties.remove(propIndex);
                        continue block2;
                    }
                }
            }
        }
    }

    private static int findPropertyByName(ArrayList<Property> properties, String name) {
        for (int i = properties.size() - 1; i >= 0; --i) {
            Property property = properties.get(i);
            if (!property.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private void collectProperties(RadComponent component, ArrayList<Property> result) {
        if (component instanceof RadRootContainer) {
            this.addProperty(result, this.myClassToBindProperty);
        } else {
            RadContainer parent;
            if (!(component instanceof RadVSpacer) && !(component instanceof RadHSpacer)) {
                this.addProperty(result, this.myBindingProperty);
                this.addProperty(result, CustomCreateProperty.getInstance(this.myProject));
            }
            if (component instanceof RadContainer) {
                RadContainer container = (RadContainer)component;
                if (container.getLayoutManager().getName() != null) {
                    this.addProperty(result, this.myLayoutManagerProperty);
                }
                this.addProperty(result, this.myBorderProperty);
                Property[] containerProperties = container.getLayoutManager().getContainerProperties(this.myProject);
                this.addApplicableProperties(containerProperties, container, result);
            }
            if ((parent = component.getParent()) != null) {
                Property[] properties = parent.getLayoutManager().getComponentProperties(this.myProject, component);
                this.addApplicableProperties(properties, component, result);
            }
            if (component.getDelegee() instanceof AbstractButton && !(component.getDelegee() instanceof JButton)) {
                this.addProperty(result, this.myButtonGroupProperty);
            }
            if (!(component instanceof RadVSpacer) && !(component instanceof RadHSpacer)) {
                this.addProperty(result, ClientPropertiesProperty.getInstance(this.myProject));
            }
            if (component.hasIntrospectedProperties()) {
                Class componentClass = component.getComponentClass();
                IntrospectedProperty[] introspectedProperties = Palette.getInstance(this.myEditor.getProject()).getIntrospectedProperties(component);
                Properties properties = Properties.getInstance();
                for (IntrospectedProperty property : introspectedProperties) {
                    if (!property.appliesTo(component) || !this.myShowExpertProperties && properties.isExpertProperty(component.getModule(), componentClass, property.getName()) && !this.isModifiedForSelection(property)) continue;
                    this.addProperty(result, property);
                }
            }
        }
    }

    private void addApplicableProperties(Property[] containerProperties, RadComponent component, ArrayList<Property> result) {
        for (Property prop : containerProperties) {
            if (!prop.appliesTo(component)) continue;
            this.addProperty(result, prop);
        }
    }

    private void addProperty(ArrayList<Property> result, Property property) {
        result.add(property);
        if (this.isPropertyExpanded(property)) {
            for (Property child : this.getPropChildren(property)) {
                this.addProperty(result, child);
            }
        }
    }

    private boolean isPropertyExpanded(Property property) {
        return this.myExpandedProperties.contains(PropertyInspectorTable.getDottedName(property));
    }

    private static String getDottedName(Property property) {
        Property parent = property.getParent();
        if (parent != null) {
            return parent.getName() + "." + property.getName();
        }
        return property.getName();
    }

    private static int getPropertyIndentDepth(Property property) {
        Property parent = property.getParent();
        if (parent != null) {
            return parent.getParent() != null ? 2 : 1;
        }
        return 0;
    }

    private static int getPropertyIndentWidth() {
        return JBUI.scale((int)11);
    }

    private Property[] getPropChildren(Property property) {
        return property.getChildren(this.mySelection.get(0));
    }

    public TableCellEditor getCellEditor(int row, int column) {
        PropertyEditor editor = this.myProperties.get(row).getEditor();
        editor.removePropertyEditorListener(this.myPropertyEditorListener);
        editor.addPropertyEditorListener(this.myPropertyEditorListener);
        this.myCellEditor.setEditor(editor);
        return this.myCellEditor;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.myCellRenderer;
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        boolean result = super.editCellAt(row, column, e);
        Rectangle cellRect = this.getCellRect(row, column, true);
        this.repaint(cellRect);
        return result;
    }

    private void startEditing(int index) {
        Property property = this.myProperties.get(index);
        PropertyEditor editor = property.getEditor();
        if (editor == null) {
            return;
        }
        this.editCellAt(index, this.convertColumnIndexToView(1));
        LOG.assertTrue(this.editorComp != null);
        JComponent prefComponent = editor.getPreferredFocusedComponent((JComponent)this.editorComp);
        if (prefComponent == null) {
            prefComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((JComponent)this.editorComp));
        }
        if (prefComponent != null) {
            prefComponent.requestFocusInWindow();
        }
    }

    private void finishEditing() {
        if (this.editingRow == -1) {
            return;
        }
        this.editingStopped(new ChangeEvent(this.cellEditor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingStopped(ChangeEvent ignored) {
        LOG.assertTrue(this.isEditing());
        LOG.assertTrue(this.editingRow != -1);
        if (this.myStoppingEditing) {
            return;
        }
        this.myStoppingEditing = true;
        Property property = this.myProperties.get(this.editingRow);
        PropertyEditor editor = property.getEditor();
        editor.removePropertyEditorListener(this.myPropertyEditorListener);
        try {
            if (this.myEditor != null && !this.myEditor.isUndoRedoInProgress()) {
                Object value = editor.getValue();
                this.setValueAt(value, this.editingRow, this.editingColumn);
            }
        }
        catch (Exception exc) {
            PropertyInspectorTable.showInvalidInput(exc);
        }
        finally {
            this.removeEditor();
            this.myStoppingEditing = false;
        }
    }

    private static void showInvalidInput(Exception exc) {
        Throwable cause = exc.getCause();
        String message = cause != null ? cause.getMessage() : exc.getMessage();
        if (message == null || message.length() == 0) {
            message = UIDesignerBundle.message("error.no.message", new Object[0]);
        }
        Messages.showMessageDialog((String)UIDesignerBundle.message("error.setting.value", message), (String)UIDesignerBundle.message("title.invalid.input", new Object[0]), (Icon)Messages.getErrorIcon());
    }

    private void expandProperty(int index) {
        int selectedRow = this.getSelectedRow();
        Property property = this.myProperties.get(index);
        String dottedName = PropertyInspectorTable.getDottedName(property);
        if (this.myExpandedProperties.contains(dottedName)) {
            return;
        }
        this.myExpandedProperties.add(dottedName);
        Property[] children = this.getPropChildren(property);
        for (int i = 0; i < children.length; ++i) {
            this.myProperties.add(index + i + 1, children[i]);
        }
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void collapseProperty(int index) {
        int selectedRow = this.getSelectedRow();
        Property property = this.myProperties.get(index);
        LOG.assertTrue(this.isPropertyExpanded(property));
        this.myExpandedProperties.remove(PropertyInspectorTable.getDottedName(property));
        Property[] children = this.getPropChildren(property);
        for (int i = 0; i < children.length; ++i) {
            this.myProperties.remove(index + 1);
        }
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    @Nullable
    ErrorInfo getErrorInfoForRow(int row) {
        LOG.assertTrue(row < this.myProperties.size());
        if (this.mySelection.size() != 1) {
            return null;
        }
        RadComponent component = this.mySelection.get(0);
        Property property = this.myProperties.get(row);
        ErrorInfo errorInfo = null;
        if (this.myClassToBindProperty.equals(property)) {
            errorInfo = (ErrorInfo)component.getClientProperty("classToBindError");
        } else if (this.myBindingProperty.equals(property)) {
            errorInfo = (ErrorInfo)component.getClientProperty("bindingError");
        } else {
            ArrayList errors = (ArrayList)component.getClientProperty("errorArray");
            if (errors != null) {
                for (ErrorInfo err : errors) {
                    if (!property.getName().equals(err.getPropertyName())) continue;
                    errorInfo = err;
                    break;
                }
            }
        }
        return errorInfo;
    }

    @Nullable
    private String getErrorForRow(int row) {
        LOG.assertTrue(row < this.myProperties.size());
        ErrorInfo errorInfo = this.getErrorInfoForRow(row);
        return errorInfo != null ? errorInfo.myDescription : null;
    }

    public String getToolTipText(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        if (row == -1) {
            return null;
        }
        return this.getErrorForRow(row);
    }

    private Object getSelectionValue(Property property) {
        if (this.mySelection.size() == 0) {
            return null;
        }
        Object result = property.getValue(this.mySelection.get(0));
        for (int i = 1; i < this.mySelection.size(); ++i) {
            Object otherValue = null;
            if (property instanceof IntrospectedProperty) {
                IntrospectedProperty[] props;
                for (IntrospectedProperty otherProperty : props = Palette.getInstance(this.myProject).getIntrospectedProperties(this.mySelection.get(i))) {
                    if (!otherProperty.getName().equals(property.getName())) continue;
                    otherValue = otherProperty.getValue(this.mySelection.get(i));
                    break;
                }
            } else {
                otherValue = property.getValue(this.mySelection.get(i));
            }
            if (Comparing.equal(result, otherValue)) continue;
            return null;
        }
        return result;
    }

    private boolean setSelectionValue(Property property, Object newValue) {
        if (!PropertyInspectorTable.setPropValue(property, this.mySelection.get(0), newValue)) {
            return false;
        }
        block0: for (int i = 1; i < this.mySelection.size(); ++i) {
            if (property instanceof IntrospectedProperty) {
                IntrospectedProperty[] props;
                for (IntrospectedProperty otherProperty : props = Palette.getInstance(this.myProject).getIntrospectedProperties(this.mySelection.get(i))) {
                    if (!otherProperty.getName().equals(property.getName())) continue;
                    if (PropertyInspectorTable.setPropValue(otherProperty, this.mySelection.get(i), newValue)) continue block0;
                    return false;
                }
                continue;
            }
            if (PropertyInspectorTable.setPropValue(property, this.mySelection.get(i), newValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean setPropValue(Property property, RadComponent c, Object newValue) {
        try {
            property.setValue(c, newValue);
        }
        catch (Throwable e) {
            LOG.debug(e);
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            Messages.showMessageDialog((String)e.getMessage(), (String)UIDesignerBundle.message("title.invalid.input", new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public boolean isModifiedForSelection(Property property) {
        for (RadComponent c : this.mySelection) {
            if (!property.isModified(c)) continue;
            return true;
        }
        return false;
    }

    private final class MyLafManagerListener
    implements LafManagerListener {
        private MyLafManagerListener() {
        }

        private void updateUI(Property property) {
            PropertyRenderer renderer = property.getRenderer();
            renderer.updateUI();
            PropertyEditor editor = property.getEditor();
            if (editor != null) {
                editor.updateUI();
            }
            Property[] children = property.getChildren(null);
            for (int i = children.length - 1; i >= 0; --i) {
                Property child = children[i];
                if (child instanceof IntrospectedProperty) continue;
                this.updateUI(child);
            }
        }

        public void lookAndFeelChanged(LafManager source) {
            this.updateUI(PropertyInspectorTable.this.myBorderProperty);
            this.updateUI(MarginProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(HGapProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(VGapProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(HSizePolicyProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(VSizePolicyProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(HorzAlignProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(VertAlignProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(IndentProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(UseParentLayoutProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(MinimumSizeProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(PreferredSizeProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(MaximumSizeProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(PropertyInspectorTable.this.myButtonGroupProperty);
            this.updateUI(PropertyInspectorTable.this.myLayoutManagerProperty);
            this.updateUI(SameSizeHorizontallyProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(SameSizeVerticallyProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(CustomCreateProperty.getInstance(PropertyInspectorTable.this.myProject));
            this.updateUI(ClientPropertiesProperty.getInstance(PropertyInspectorTable.this.myProject));
        }
    }

    private class MyExpandCurrentAction
    extends AbstractAction {
        private final boolean myExpand;

        public MyExpandCurrentAction(boolean expand) {
            this.myExpand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyInspectorTable.this.getSelectedRow();
            if (PropertyInspectorTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property = (Property)PropertyInspectorTable.this.myProperties.get(selectedRow);
            if (PropertyInspectorTable.this.getPropChildren(property).length > 0) {
                if (this.myExpand) {
                    if (!PropertyInspectorTable.this.isPropertyExpanded(property)) {
                        PropertyInspectorTable.this.expandProperty(selectedRow);
                    }
                } else if (PropertyInspectorTable.this.isPropertyExpanded(property)) {
                    PropertyInspectorTable.this.collapseProperty(selectedRow);
                }
            }
        }
    }

    private final class MyEnterAction
    extends AbstractAction {
        private MyEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyInspectorTable.this.getSelectedRow();
            if (PropertyInspectorTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property = (Property)PropertyInspectorTable.this.myProperties.get(selectedRow);
            if (PropertyInspectorTable.this.getPropChildren(property).length > 0) {
                if (PropertyInspectorTable.this.isPropertyExpanded(property)) {
                    PropertyInspectorTable.this.collapseProperty(selectedRow);
                } else {
                    PropertyInspectorTable.this.expandProperty(selectedRow);
                }
            } else {
                PropertyInspectorTable.this.startEditing(selectedRow);
            }
        }
    }

    private final class MyStartEditingAction
    extends AbstractAction {
        private MyStartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyInspectorTable.this.getSelectedRow();
            if (selectedRow == -1 || PropertyInspectorTable.this.isEditing()) {
                return;
            }
            PropertyInspectorTable.this.startEditing(selectedRow);
        }
    }

    private final class MySelectNextRowAction
    extends AbstractAction {
        private MySelectNextRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowCount = PropertyInspectorTable.this.getRowCount();
            LOG.assertTrue(rowCount > 0);
            int selectedRow = (PropertyInspectorTable.this.getSelectedRow() + 1) % rowCount;
            if (PropertyInspectorTable.this.isEditing()) {
                PropertyInspectorTable.this.finishEditing();
                PropertyInspectorTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyInspectorTable.this.scrollRectToVisible(PropertyInspectorTable.this.getCellRect(selectedRow, 0, true));
                PropertyInspectorTable.this.startEditing(selectedRow);
            } else {
                PropertyInspectorTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyInspectorTable.this.scrollRectToVisible(PropertyInspectorTable.this.getCellRect(selectedRow, 0, true));
            }
        }
    }

    private final class MySelectPreviousRowAction
    extends AbstractAction {
        private MySelectPreviousRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowCount = PropertyInspectorTable.this.getRowCount();
            LOG.assertTrue(rowCount > 0);
            int selectedRow = PropertyInspectorTable.this.getSelectedRow();
            if (selectedRow != -1) {
                --selectedRow;
            }
            selectedRow = (selectedRow + rowCount) % rowCount;
            if (PropertyInspectorTable.this.isEditing()) {
                PropertyInspectorTable.this.finishEditing();
                PropertyInspectorTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyInspectorTable.this.scrollRectToVisible(PropertyInspectorTable.this.getCellRect(selectedRow, 0, true));
                PropertyInspectorTable.this.startEditing(selectedRow);
            } else {
                PropertyInspectorTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyInspectorTable.this.scrollRectToVisible(PropertyInspectorTable.this.getCellRect(selectedRow, 0, true));
            }
        }
    }

    private final class MyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private PropertyEditor myEditor;

        private MyCellEditor() {
        }

        public void setEditor(@NotNull PropertyEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/propertyInspector/PropertyInspectorTable$MyCellEditor", "setEditor"));
            }
            this.myEditor = editor;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                return this.myEditor.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, @NotNull Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/PropertyInspectorTable$MyCellEditor", "getTableCellEditorComponent"));
            }
            Property property = (Property)value;
            try {
                JComponent c = this.myEditor.getComponent((RadComponent)PropertyInspectorTable.this.mySelection.get(0), PropertyInspectorTable.this.getSelectionValue(property), null);
                if (c instanceof JComboBox) {
                    c.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                } else if (c instanceof JCheckBox) {
                    c.putClientProperty("JComponent.sizeVariant", UIUtil.isUnderAquaLookAndFeel() ? "small" : null);
                }
                return c;
            }
            catch (Exception ex) {
                LOG.debug((Throwable)ex);
                SimpleColoredComponent errComponent = new SimpleColoredComponent();
                errComponent.append(UIDesignerBundle.message("error.getting.value", ex.getMessage()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                return errComponent;
            }
        }
    }

    private final class MyCompositeTableCellRenderer
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myPropertyNameRenderer;
        private final ColoredTableCellRenderer myErrorRenderer;
        private final Icon myExpandIcon;
        private final Icon myCollapseIcon;
        private final Icon myIndentedExpandIcon;
        private final Icon myIndentedCollapseIcon;
        private final Icon[] myIndentIcons = new Icon[3];

        public MyCompositeTableCellRenderer() {
            this.myPropertyNameRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    this.setPaintFocusBorder(false);
                    this.setFocusBorderAroundIcon(true);
                }
            };
            this.myErrorRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    this.setPaintFocusBorder(false);
                }
            };
            this.myExpandIcon = UIUtil.isUnderDarcula() ? AllIcons.Mac.Tree_white_right_arrow : UIDesignerIcons.ExpandNode;
            this.myCollapseIcon = UIUtil.isUnderDarcula() ? AllIcons.Mac.Tree_white_down_arrow : UIDesignerIcons.CollapseNode;
            for (int i = 0; i < this.myIndentIcons.length; ++i) {
                this.myIndentIcons[i] = EmptyIcon.create((int)(this.myExpandIcon.getIconWidth() + PropertyInspectorTable.getPropertyIndentWidth() * i), (int)this.myExpandIcon.getIconHeight());
            }
            this.myIndentedExpandIcon = new IndentedIcon(this.myExpandIcon, PropertyInspectorTable.getPropertyIndentWidth());
            this.myIndentedCollapseIcon = new IndentedIcon(this.myCollapseIcon, PropertyInspectorTable.getPropertyIndentWidth());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, @NotNull Object value, boolean selected, boolean hasFocus, int row, int column) {
            Color background;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/PropertyInspectorTable$MyCompositeTableCellRenderer", "getTableCellRendererComponent"));
            }
            this.myPropertyNameRenderer.getTableCellRendererComponent(table, value, selected, hasFocus, row, column);
            column = table.convertColumnIndexToModel(column);
            Property property = (Property)value;
            Property parent = property.getParent();
            if (property instanceof IntrospectedProperty) {
                background = table.getBackground();
            } else {
                Color color = background = parent == null ? SYNTETIC_PROPERTY_BACKGROUND : SYNTETIC_SUBPROPERTY_BACKGROUND;
            }
            if (!selected) {
                this.myPropertyNameRenderer.setBackground(background);
            }
            if (column == 0) {
                SimpleTextAttributes attrs = this.getTextAttributes(row, property);
                this.myPropertyNameRenderer.append(property.getName(), attrs);
                if (PropertyInspectorTable.this.getPropChildren(property).length > 0) {
                    if (parent != null) {
                        if (PropertyInspectorTable.this.isPropertyExpanded(property)) {
                            this.myPropertyNameRenderer.setIcon(this.myIndentedCollapseIcon);
                        } else {
                            this.myPropertyNameRenderer.setIcon(this.myIndentedExpandIcon);
                        }
                    } else if (PropertyInspectorTable.this.isPropertyExpanded(property)) {
                        this.myPropertyNameRenderer.setIcon(this.myCollapseIcon);
                    } else {
                        this.myPropertyNameRenderer.setIcon(this.myExpandIcon);
                    }
                } else {
                    this.myPropertyNameRenderer.setIcon(this.myIndentIcons[PropertyInspectorTable.getPropertyIndentDepth(property)]);
                }
            } else {
                if (column == 1) {
                    try {
                        PropertyRenderer<Object> renderer = property.getRenderer();
                        JComponent component = renderer.getComponent(PropertyInspectorTable.this.myEditor.getRootContainer(), PropertyInspectorTable.this.getSelectionValue(property), selected, hasFocus);
                        if (!selected) {
                            component.setBackground(background);
                        }
                        if (PropertyInspectorTable.this.isModifiedForSelection(property)) {
                            component.setFont(table.getFont().deriveFont(1));
                        } else {
                            component.setFont(table.getFont());
                        }
                        if (component instanceof JCheckBox) {
                            component.putClientProperty("JComponent.sizeVariant", UIUtil.isUnderAquaLookAndFeel() ? "small" : null);
                        }
                        return component;
                    }
                    catch (Exception ex) {
                        LOG.debug((Throwable)ex);
                        this.myErrorRenderer.clear();
                        this.myErrorRenderer.append(UIDesignerBundle.message("error.getting.value", ex.getMessage()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                        return this.myErrorRenderer;
                    }
                }
                throw new IllegalArgumentException("wrong column: " + column);
            }
            if (!selected) {
                this.myPropertyNameRenderer.setForeground(PropertyInspectorTable.this.getForeground());
                if (property instanceof IntrospectedProperty) {
                    RadComponent component = (RadComponent)PropertyInspectorTable.this.mySelection.get(0);
                    Class componentClass = component.getComponentClass();
                    if (Properties.getInstance().isExpertProperty(component.getModule(), componentClass, property.getName())) {
                        this.myPropertyNameRenderer.setForeground(Color.LIGHT_GRAY);
                    }
                }
            }
            return this.myPropertyNameRenderer;
        }

        private SimpleTextAttributes getTextAttributes(int row, Property property) {
            SimpleTextAttributes result;
            boolean modified;
            ErrorInfo errInfo = PropertyInspectorTable.this.getErrorInfoForRow(row);
            try {
                modified = PropertyInspectorTable.this.isModifiedForSelection(property);
            }
            catch (Exception ex) {
                modified = false;
            }
            if (errInfo == null) {
                result = modified ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            } else {
                HighlightSeverity severity;
                Map cache = modified ? PropertyInspectorTable.this.myModifiedHighlightAttributes : PropertyInspectorTable.this.myHighlightAttributes;
                result = (SimpleTextAttributes)cache.get(severity = errInfo.getHighlightDisplayLevel().getSeverity());
                if (result == null) {
                    TextAttributesKey attrKey = SeverityRegistrar.getSeverityRegistrar((Project)PropertyInspectorTable.this.myProject).getHighlightInfoTypeBySeverity(severity).getAttributesKey();
                    TextAttributes textAttrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attrKey);
                    if (modified) {
                        textAttrs = textAttrs.clone();
                        textAttrs.setFontType(textAttrs.getFontType() | 1);
                    }
                    result = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttrs);
                    cache.put(severity, result);
                }
            }
            if (property instanceof IntrospectedProperty) {
                RadComponent c = (RadComponent)PropertyInspectorTable.this.mySelection.get(0);
                if (Properties.getInstance().isPropertyDeprecated(c.getModule(), c.getComponentClass(), property.getName())) {
                    return new SimpleTextAttributes(result.getBgColor(), result.getFgColor(), result.getWaveColor(), result.getStyle() | 4);
                }
            }
            return result;
        }
    }

    private final class MyPropertyEditorListener
    extends PropertyEditorAdapter {
        private MyPropertyEditorListener() {
        }

        @Override
        public void valueCommitted(PropertyEditor source, boolean continueEditing, boolean closeEditorOnError) {
            if (PropertyInspectorTable.this.isEditing()) {
                Object value;
                TableCellEditor tableCellEditor = PropertyInspectorTable.this.cellEditor;
                try {
                    value = tableCellEditor.getCellEditorValue();
                }
                catch (Exception exc) {
                    PropertyInspectorTable.showInvalidInput(exc);
                    return;
                }
                boolean valueAccepted = PropertyInspectorTable.this.myModel.setValueAtRow(PropertyInspectorTable.this.editingRow, value);
                if (valueAccepted) {
                    if (!continueEditing) {
                        tableCellEditor.stopCellEditing();
                    }
                } else if (closeEditorOnError) {
                    tableCellEditor.cancelCellEditing();
                }
            }
        }

        @Override
        public void editingCanceled(PropertyEditor source) {
            if (PropertyInspectorTable.this.isEditing()) {
                PropertyInspectorTable.this.cellEditor.cancelCellEditing();
            }
        }
    }

    private final class MyModel
    extends AbstractTableModel {
        private final String[] myColumnNames = new String[]{UIDesignerBundle.message("column.property", new Object[0]), UIDesignerBundle.message("column.value", new Object[0])};

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.myColumnNames[column];
        }

        @Override
        public int getRowCount() {
            return PropertyInspectorTable.this.myProperties.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && ((Property)PropertyInspectorTable.this.myProperties.get(row)).getEditor() != null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return PropertyInspectorTable.this.myProperties.get(row);
        }

        @Override
        public void setValueAt(Object newValue, int row, int column) {
            if (column != 1) {
                throw new IllegalArgumentException("wrong index: " + column);
            }
            this.setValueAtRow(row, newValue);
        }

        boolean setValueAtRow(int row, Object newValue) {
            Property property = (Property)PropertyInspectorTable.this.myProperties.get(row);
            Object oldValue = PropertyInspectorTable.this.getSelectionValue(property);
            boolean retVal = true;
            if (!Comparing.equal((Object)oldValue, (Object)newValue)) {
                GuiEditor editor = PropertyInspectorTable.this.myEditor;
                if (!editor.ensureEditable()) {
                    return false;
                }
                Ref result = new Ref((Object)Boolean.FALSE);
                CommandProcessor.getInstance().executeCommand(PropertyInspectorTable.this.myProject, () -> {
                    result.set((Object)PropertyInspectorTable.this.setSelectionValue(property, newValue));
                    editor.refreshAndSave(false);
                }, UIDesignerBundle.message("command.set.property.value", new Object[0]), null);
                retVal = (Boolean)result.get();
            }
            if (property.needRefreshPropertyList() && retVal) {
                PropertyInspectorTable.this.synchWithTree(true);
            }
            return retVal;
        }
    }
}

