/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.klint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.klint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.klint.ApiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinIfSurrounder;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/android/inspections/klint/AddTargetVersionCheckQuickFix;", "Lorg/jetbrains/android/inspections/klint/AndroidLintQuickFix;", "api", "", "(I)V", "getApi", "()I", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lorg/jetbrains/android/inspections/klint/AndroidQuickfixContexts$Context;", "getName", "", "getTargetExpression", "element", "isApplicable", "", "contextType", "Lorg/jetbrains/android/inspections/klint/AndroidQuickfixContexts$ContextType;", "Companion", "lint-idea"})
public final class AddTargetVersionCheckQuickFix
implements AndroidLintQuickFix {
    private final int api;
    private static final KotlinIfSurrounder IF_SURROUNDER;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement targetExpression = this.getTargetExpression(startElement);
        PsiElement psiElement = targetExpression;
        if (psiElement == null || (psiElement = psiElement.getProject()) == null) {
            return;
        }
        PsiElement project = psiElement;
        Editor editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)targetExpression);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile file = targetExpression.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElement[] psiElementArray = new PsiElement[]{targetExpression};
        Editor editor3 = editor2;
        PsiElement psiElement2 = project;
        KotlinIfSurrounder kotlinIfSurrounder = AddTargetVersionCheckQuickFix.Companion.getIF_SURROUNDER();
        void var16_14 = elements$iv;
        TextRange textRange = kotlinIfSurrounder.surroundElements((Project)psiElement2, editor3, (PsiElement[])var16_14);
        if (textRange == null) {
            return;
        }
        TextRange conditionRange = textRange;
        String conditionText = "android.os.Build.VERSION.SDK_INT >= " + ApiUtilsKt.getVersionField(this.api, true);
        document2.replaceString(conditionRange.getStartOffset(), conditionRange.getEndOffset(), (CharSequence)conditionText);
        documentManager.commitDocument(document2);
        PsiFile psiFile = documentManager.getPsiFile(document2);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        ShortenReferences.DEFAULT.process((KtFile)psiFile, conditionRange.getStartOffset(), conditionRange.getStartOffset() + conditionText.length());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)contextType, (String)"contextType");
        return this.getTargetExpression(startElement) != null;
    }

    @Override
    @NotNull
    public String getName() {
        return "Surround with if (VERSION.SDK_INT >= VERSION_CODES." + ApiUtilsKt.getVersionField(this.api, false) + ") { ... }";
    }

    private final PsiElement getTargetExpression(PsiElement element) {
        KtExpression current = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)element, KtExpression.class);
        while (!(current == null || current.getParent() instanceof KtBlockExpression || current.getParent() instanceof KtContainerNode || current.getParent() instanceof KtWhenEntry || current.getParent() instanceof KtFunction)) {
            current = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)current), KtExpression.class, (boolean)true);
        }
        return (PsiElement)current;
    }

    public final int getApi() {
        return this.api;
    }

    public AddTargetVersionCheckQuickFix(int api) {
        this.api = api;
    }

    static {
        Companion = new Companion(null);
        IF_SURROUNDER = new KotlinIfSurrounder();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/android/inspections/klint/AddTargetVersionCheckQuickFix$Companion;", "", "()V", "IF_SURROUNDER", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinIfSurrounder;", "getIF_SURROUNDER", "()Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinIfSurrounder;", "lint-idea"})
    public static final class Companion {
        private final KotlinIfSurrounder getIF_SURROUNDER() {
            return IF_SURROUNDER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

