/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.WithModulePackagingElement;
import com.intellij.dmserver.artifacts.WithModulePackagingElementType;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DMArtifactTypeBase<E extends WithModulePackagingElement, T extends WithModulePackagingElementType<E>, F extends DMFacetBase<?>>
extends ArtifactType {
    private static final Logger LOG = Logger.getInstance((String)("#" + DMArtifactTypeBase.class.getName()));

    public DMArtifactTypeBase(@NonNls String id, String title) {
        super(id, title);
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "getDefaultPathFor"));
        }
        return "/";
    }

    protected E addOrFindModuleReference(CompositePackagingElement<?> destinationElement, Module module) {
        Object moduleRef = ((WithModulePackagingElementType)((Object)this.getModulePackagingElementType())).createFor(module);
        moduleRef = (WithModulePackagingElement)destinationElement.addOrFindChild(moduleRef);
        return moduleRef;
    }

    protected static void addOrFindModuleOutputReference(CompositePackagingElement<?> destinationElement, Module module) {
        PackagingElement moduleOutput = PackagingElementFactory.getInstance().createModuleOutput(module);
        destinationElement.addOrFindChild(moduleOutput);
    }

    public final boolean isCompatibleArtifact(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "isCompatibleArtifact"));
        }
        return artifact.getArtifactType() == this;
    }

    public final VirtualFile findMainFileToDeploy(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "findMainFileToDeploy"));
        }
        return DMArtifactTypeBase.findFileByFilter(artifact, this.getMainFileToDeployFilter(artifact));
    }

    @NotNull
    protected abstract VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact var1);

    private static VirtualFile findFileByFilter(@NotNull Artifact artifact, @NotNull VirtualFileFilter filter) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "findFileByFilter"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "findFileByFilter"));
        }
        VirtualFile output = LocalFileSystem.getInstance().refreshAndFindFileByPath(artifact.getOutputPath());
        if (output == null) {
            LOG.warn("Artifact output doesn't exist, is the artifact built?");
            return null;
        }
        for (VirtualFile nextToDeploy : output.getChildren()) {
            if (!filter.accept(nextToDeploy)) continue;
            return nextToDeploy;
        }
        return null;
    }

    public static VirtualFile findFileByExtension(@NotNull Artifact artifact, String ... extensions) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "findFileByExtension"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/dmserver/artifacts/DMArtifactTypeBase", "findFileByExtension"));
        }
        return DMArtifactTypeBase.findFileByFilter(artifact, new ByExtensionFilter(extensions));
    }

    public abstract Artifact createArtifactFor(@NotNull Module var1, @NotNull F var2);

    public abstract void synchronizeArtifact(@NotNull Artifact var1, @NotNull Module var2, @NotNull F var3);

    public abstract T getModulePackagingElementType();

    protected static class ByExtensionFilter
    implements VirtualFileFilter {
        private final List<String> myExtensions;

        public ByExtensionFilter(String ... extensions) {
            this.myExtensions = new ArrayList<String>(extensions.length);
            for (String next : extensions) {
                this.myExtensions.add(next.toLowerCase());
            }
        }

        public boolean accept(VirtualFile file) {
            if (file.isDirectory()) {
                return false;
            }
            String extension = file.getExtension();
            return this.myExtensions.contains(extension.toLowerCase());
        }
    }
}

