/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.artifacts.DMContainerArtifactTypeBase;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.util.containers.ContainerUtil;
import icons.DmServerSupportIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DMBundleArtifactType
extends DMContainerArtifactTypeBase {
    private static final VirtualFileFilter JAR_OR_WAR_FILE_FILTER = new DMArtifactTypeBase.ByExtensionFilter("jar", "war");

    public static DMBundleArtifactType getInstance() {
        return (DMBundleArtifactType)((Object)ContainerUtil.findInstance((Object[])DMBundleArtifactType.getAllTypes(), DMBundleArtifactType.class));
    }

    public DMBundleArtifactType() {
        super("dm.bundle", DmServerBundle.message("DMBundleArtifactType.title", new Object[0]));
    }

    @Override
    @NotNull
    protected VirtualFileFilter getMainFileToDeployFilter(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "getMainFileToDeployFilter"));
        }
        VirtualFileFilter virtualFileFilter = JAR_OR_WAR_FILE_FILTER;
        if (virtualFileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "getMainFileToDeployFilter"));
        }
        return virtualFileFilter;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DmServerSupportIcons.Bundle;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "createRootElement"));
        }
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "createRootElement"));
        }
        return artifactRootElementImpl;
    }

    @Override
    public Artifact createArtifactFor(@NotNull Module module, @NotNull DMBundleFacet facet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "createArtifactFor"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "createArtifactFor"));
        }
        Project project = module.getProject();
        ArtifactManager manager = ArtifactManager.getInstance((Project)project);
        Artifact artifact = manager.addArtifact(DmServerBundle.message("DMBundleArtifactType.artifact.name", module.getName()), (ArtifactType)DMBundleArtifactType.getInstance(), null);
        this.addOrFindModuleReference(artifact.getRootElement(), module);
        return artifact;
    }

    @Override
    public void synchronizeArtifact(@NotNull Artifact artifact, @NotNull Module module, @NotNull DMBundleFacet facet) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "synchronizeArtifact"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "synchronizeArtifact"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/dmserver/artifacts/DMBundleArtifactType", "synchronizeArtifact"));
        }
    }
}

