/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.WithModuleElementState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WithModulePackagingElement
extends CompositePackagingElement<WithModuleElementState> {
    private final Project myProject;
    private String myModuleName;

    public WithModulePackagingElement(@NotNull PackagingElementType<? extends WithModulePackagingElement> type, @NotNull Project project, @Nullable Module module) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dmserver/artifacts/WithModulePackagingElement", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/artifacts/WithModulePackagingElement", "<init>"));
        }
        super(type);
        this.myProject = project;
        this.myModuleName = module == null ? null : module.getName();
    }

    public void loadState(WithModuleElementState state) {
        this.myModuleName = state.getModuleId();
    }

    public WithModuleElementState getState() {
        WithModuleElementState result = new WithModuleElementState();
        result.setModuleId(this.myModuleName);
        return result;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModulePointer(@NotNull ModulePointer modulePointer) {
        if (modulePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePointer", "com/intellij/dmserver/artifacts/WithModulePackagingElement", "setModulePointer"));
        }
        this.myModuleName = modulePointer.getModuleName();
    }

    public void setModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/WithModulePackagingElement", "setModule"));
        }
        this.myModuleName = module.getName();
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dmserver/artifacts/WithModulePackagingElement", "isEqualTo"));
        }
        return ((Object)((Object)this)).getClass() == element.getClass() && this.myModuleName != null && this.myModuleName.equals(((WithModulePackagingElement)element).myModuleName);
    }

    public Module findModule() {
        if (this.myModuleName == null) {
            return null;
        }
        for (Module next : new DefaultModulesProvider(this.myProject).getModules()) {
            if (!this.myModuleName.equals(next.getName())) continue;
            return next;
        }
        return null;
    }
}

