/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy;

import com.intellij.dmserver.artifacts.DMArtifactTypeBase;
import com.intellij.dmserver.deploy.IDMCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CommandsCollector {
    private final DMServerInstance myServerInstance;
    private final DeploymentModel myModel;

    public CommandsCollector(@NotNull DMServerInstance serverInstance, @NotNull DeploymentModel model) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/dmserver/deploy/CommandsCollector", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dmserver/deploy/CommandsCollector", "<init>"));
        }
        this.myServerInstance = serverInstance;
        this.myModel = model;
    }

    public List<IDMCommand> collectCommands() throws IOException {
        Artifact artifact = this.getModel().getArtifact();
        if (artifact == null) {
            ArtifactPointer artifactPointer = this.getModel().getArtifactPointer();
            throw new IOException("Deployment fails to access artifact " + (artifactPointer == null ? "" : artifactPointer.getArtifactName()));
        }
        ArrayList<IDMCommand> result = new ArrayList<IDMCommand>();
        ArtifactType type = artifact.getArtifactType();
        if (type instanceof DMArtifactTypeBase) {
            this.collectCommandsForDmArtifact(artifact, (DMArtifactTypeBase)type, result);
        } else if (type instanceof WarArtifactType) {
            this.collectCommandsForWarArtifact(artifact, (WarArtifactType)type, result);
        } else {
            throw new IOException("Unexpected artifact type: " + type.getPresentableName() + " found");
        }
        return result;
    }

    protected final DMServerInstance getServerInstance() {
        return this.myServerInstance;
    }

    protected final DeploymentModel getModel() {
        return this.myModel;
    }

    protected abstract void collectCommandsForDmArtifact(@NotNull Artifact var1, @NotNull DMArtifactTypeBase var2, @NotNull List<IDMCommand> var3) throws IOException;

    protected abstract void collectCommandsForWarArtifact(@NotNull Artifact var1, @NotNull WarArtifactType var2, @NotNull List<IDMCommand> var3) throws IOException;
}

