/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy;

import com.intellij.dmserver.common.DeploymentProviderEx;
import com.intellij.dmserver.deploy.DMServerDeploymentModel;
import com.intellij.dmserver.deploy.DeployCommandsCollector;
import com.intellij.dmserver.deploy.DeploymentIdentity;
import com.intellij.dmserver.deploy.IDMCommand;
import com.intellij.dmserver.deploy.UndeployCommandsCollector;
import com.intellij.dmserver.deploy.jmx.ConnectorListBundlesCommand;
import com.intellij.dmserver.deploy.jmx.QueryDeploymentStatusCommand;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.ArtifactType;
import com.springsource.server.management.remote.Bundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nullable;

public class DMServerDeploymentProvider
extends DeploymentProviderEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dmserver.deploy.DMServerDeploymentProvider");
    private static final DeploymentMethod JMX_DEPLOYMENT_METHOD;
    private static final DeploymentMethod DEFAULT_DEPLOYMENT_METHOD;
    private static final DeploymentMethod[] DEPLOYMENT_METHODS;
    private static final Collection<? extends ArtifactType> ourSupportedArtifactTypes;

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new DMServerDeploymentModel(commonModel, source);
    }

    public void updateDeploymentStatus(J2EEServerInstance instance, DeploymentModel model) {
        new DeploymentOperation(){

            @Override
            protected DeploymentStatus doExecute(DMServerInstance dmServerInstance, DeploymentModel model) throws IOException, ExecutionException, TimeoutException {
                Boolean result = (Boolean)new QueryDeploymentStatusCommand(dmServerInstance, model).execute();
                if (result == null) {
                    return DeploymentStatus.UNKNOWN;
                }
                return result != false ? DeploymentStatus.DEPLOYED : DeploymentStatus.NOT_DEPLOYED;
            }

            @Override
            protected DeploymentStatus getErrorStatus() {
                return DeploymentStatus.UNKNOWN;
            }
        }.execute(instance, model);
    }

    public void doDeploy(Project project, J2EEServerInstance instance, DeploymentModel model) {
        new DeploymentOperation(){

            @Override
            protected DeploymentStatus doExecute(DMServerInstance dmServerInstance, DeploymentModel model) throws IOException, ExecutionException, TimeoutException {
                boolean success;
                DeploymentMethod method = model.getDeploymentMethod();
                if (method == null) {
                    method = DEFAULT_DEPLOYMENT_METHOD;
                }
                if (method == JMX_DEPLOYMENT_METHOD) {
                    List<IDMCommand> deployCommands = new DeployCommandsCollector(dmServerInstance, model).collectCommands();
                    success = !deployCommands.isEmpty();
                    for (IDMCommand deployCommand : deployCommands) {
                        Object deployResult = deployCommand.execute();
                        boolean bl = success = deployResult != null;
                        if (success) {
                            if (!(deployResult instanceof DeploymentIdentity)) continue;
                            dmServerInstance.registerDeployment(model, (DeploymentIdentity)deployResult);
                            continue;
                        }
                        break;
                    }
                } else {
                    LOG.error("Unknown deployment method");
                    success = false;
                }
                return success ? DeploymentStatus.DEPLOYED : DeploymentStatus.FAILED;
            }

            @Override
            protected DeploymentStatus getErrorStatus() {
                return DeploymentStatus.FAILED;
            }
        }.execute(instance, model);
    }

    @Nullable
    public static Map<Long, Bundle> listAllDeployedBundles(DMServerInstance serverInstance) {
        try {
            return (Map)new ConnectorListBundlesCommand(serverInstance).execute();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        return ourSupportedArtifactTypes;
    }

    public void startUndeploy(J2EEServerInstance activeInstance, DeploymentModel model) {
        new DeploymentOperation(){

            @Override
            protected DeploymentStatus doExecute(DMServerInstance dmServerInstance, DeploymentModel model) throws IOException, ExecutionException, TimeoutException {
                List<IDMCommand> undeployCommands = new UndeployCommandsCollector(dmServerInstance, model).collectCommands();
                for (IDMCommand undeployCommand : undeployCommands) {
                    undeployCommand.execute();
                }
                return DeploymentStatus.NOT_DEPLOYED;
            }

            @Override
            protected DeploymentStatus getErrorStatus() {
                return DeploymentStatus.UNKNOWN;
            }
        }.execute(activeInstance, model);
    }

    public DeploymentMethod[] getAvailableMethods() {
        return DEPLOYMENT_METHODS;
    }

    public boolean isDeployOrderMatter() {
        return true;
    }

    static {
        DEFAULT_DEPLOYMENT_METHOD = JMX_DEPLOYMENT_METHOD = new DeploymentMethod(DmServerBundle.message("DMServerDeploymentProvider.deploy.method.jmx.name", new Object[0]), true, false);
        DEPLOYMENT_METHODS = new DeploymentMethod[]{JMX_DEPLOYMENT_METHOD};
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(DMBundleFacet.getSupportedArtifactTypes());
        result.addAll(DMCompositeFacet.getSupportedArtifactTypes());
        result.addAll(DMConfigFacet.getSupportedArtifactTypes());
        result.add(WebArtifactUtil.getInstance().getWarArtifactType());
        ourSupportedArtifactTypes = Collections.unmodifiableCollection(result);
    }

    private static abstract class DeploymentOperation {
        private DeploymentOperation() {
        }

        public void execute(J2EEServerInstance serverInstance, DeploymentModel model) {
            try {
                DeploymentStatus status = this.doExecute((DMServerInstance)serverInstance, model);
                DMServerDeploymentProvider.setDeploymentStatus(serverInstance, model, status);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                this.setErrorStatus(serverInstance, model);
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
                this.setErrorStatus(serverInstance, model);
            }
            catch (TimeoutException e) {
                LOG.debug((Throwable)e);
                this.setErrorStatus(serverInstance, model);
            }
        }

        private void setErrorStatus(J2EEServerInstance serverInstance, DeploymentModel model) {
            DMServerDeploymentProvider.setDeploymentStatus(serverInstance, model, this.getErrorStatus());
        }

        protected abstract DeploymentStatus doExecute(DMServerInstance var1, DeploymentModel var2) throws IOException, ExecutionException, TimeoutException;

        protected abstract DeploymentStatus getErrorStatus();
    }
}

