/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleSupportProvider;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import org.jetbrains.annotations.NotNull;

public abstract class DMFacetSupportProviderBase<T extends DMFacetBase<C>, C extends DMFacetConfigurationBase<C>>
extends FacetBasedFrameworkSupportProvider<T> {
    private static final Logger LOG = Logger.getInstance((String)("#" + DMBundleSupportProvider.class.getName()));
    private final FacetTypeId<T> myTypeId;

    public DMFacetSupportProviderBase(FacetTypeId<T> typeId) {
        super(FacetTypeRegistry.getInstance().findFacetType(typeId));
        this.myTypeId = typeId;
    }

    public void addDMSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMFacetSupportProviderBase", "addDMSupport"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/facet/DMFacetSupportProviderBase", "addDMSupport"));
        }
        super.addSupport(module, rootModel, null, null);
    }

    public void finishAddDMSupport(Module module, ModifiableRootModel rootModel, DMServerInstallation installation, C facetConfiguration) {
        DMFacetBase facet = (DMFacetBase)FacetManager.getInstance((Module)module).getFacetByType(this.myTypeId);
        LOG.assertTrue(facet != null);
        facet.getConfigurationImpl().loadState(facetConfiguration);
        this.doFinishAddDMSupport(module, rootModel, installation, facet);
        facet.updateSupportWithArtifact(rootModel, (ModulesProvider)new DefaultModulesProvider(module.getProject()));
    }

    protected void doFinishAddDMSupport(Module module, ModifiableRootModel rootModel, DMServerInstallation installation, T facet) {
    }
}

