/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.integration;

import com.intellij.dmserver.integration.DMServerRepositoryEditor;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.WildcardsFinder;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.UiUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMServerRepositoryFolderDialog<T extends DMServerRepositoryItem>
extends DialogWrapper {
    @NonNls
    protected static final String DEFAULT_WILDCARDS = "{artifact}";
    private JPanel myMainPanel;
    private JRadioButton myWatchedRadioButton;
    private JRadioButton myExternalRadioButton;
    private TextFieldWithBrowseButton myPathTextField;
    private JTextField myNameTextField;
    private JTextField myWatchedIntervalTextField;
    private T myItem;
    private final DMServerRepositoryEditor myParent;

    public DMServerRepositoryFolderDialog(DMServerRepositoryEditor parent) {
        super(null);
        this.myParent = parent;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DmServerBundle.message("DMServerRepositoryFolderDialog.title", objectArray));
        UiUtil.setupDirectoryPicker(this.myPathTextField, DmServerBundle.message("DMServerRepositoryFolderDialog.browse.title", new Object[0]), DmServerBundle.message("DMServerRepositoryFolderDialog.browse.description", new Object[0]), null, new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                return DMServerRepositoryFolderDialog.this.getPathText(component);
            }

            public void setText(JTextField component, @NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dmserver/integration/DMServerRepositoryFolderDialog$1", "setText"));
                }
                DMServerRepositoryFolderDialog.this.setPathText(component, text);
            }
        });
        this.init();
    }

    protected void doOKAction() {
        this.myItem = this.createItem();
        if (this.myItem == null) {
            return;
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public T getItem() {
        return this.myItem;
    }

    protected final boolean checkEmpty(JTextField field, String errorEmptyMessage) {
        if (StringUtil.isEmpty((String)field.getText())) {
            this.setErrorText(errorEmptyMessage, field);
            return true;
        }
        return false;
    }

    protected final JRadioButton getWatchedRadioButton() {
        return this.myWatchedRadioButton;
    }

    protected final JRadioButton getExternalRadioButton() {
        return this.myExternalRadioButton;
    }

    protected final JTextField getNameTextField() {
        return this.myNameTextField;
    }

    protected final TextFieldWithBrowseButton getPathTextField() {
        return this.myPathTextField;
    }

    protected final JTextField getWatchedIntervalTextField() {
        return this.myWatchedIntervalTextField;
    }

    protected final DMServerRepositoryEditor getParent() {
        return this.myParent;
    }

    protected final String getPathWithWildcardsText(JTextField component) {
        WildcardsFinder wildcardsFinder = new WildcardsFinder(component.getText());
        return this.getParent().getParent().getPathResolver().path2Absolute(wildcardsFinder.getPath());
    }

    protected final void setPathWithWildcardsText(JTextField component, String text) {
        WildcardsFinder wildcardsFinder = new WildcardsFinder(component.getText());
        String path = this.getParent().getParent().getPathResolver().path2Relative(text);
        component.setText(wildcardsFinder.hasWildcards() ? path + "/" + wildcardsFinder.getWildcards() : path + "/" + DEFAULT_WILDCARDS);
    }

    @Nullable
    protected abstract T createItem();

    public abstract void setItem(T var1);

    protected abstract String getPathText(JTextField var1);

    protected abstract void setPathText(JTextField var1, @NotNull String var2);

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerRepositoryFolderDialog.path"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myWatchedRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerRepositoryFolderDialog.watched"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExternalRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerRepositoryFolderDialog.external"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerRepositoryFolderDialog.name"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DMServerRepositoryFolderDialog.watch.interval"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWatchedIntervalTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

