/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr.data;

import com.intellij.dmserver.libraries.ProgressListener;
import com.intellij.dmserver.libraries.obr.data.CodeDataDetails;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;

public abstract class AbstractCodeData<T extends CodeDataDetails> {
    private final String myName;
    private final String myVersion;
    private final String myLink;
    private T myDetails;

    public AbstractCodeData(String name, String version, String link) {
        this.myName = name;
        this.myVersion = version;
        this.myLink = link;
    }

    public String getName() {
        return this.myName;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getLink() {
        return this.myLink;
    }

    public void loadDetails(ProgressListener progressListener) throws IOException, XPathExpressionException {
        if (this.myDetails != null) {
            return;
        }
        this.myDetails = this.doLoadDetails(progressListener);
    }

    public T getDetails() {
        return this.myDetails;
    }

    public String getID() {
        return this.getName() + "###" + this.getVersion();
    }

    protected abstract T doLoadDetails(ProgressListener var1) throws IOException, XPathExpressionException;
}

