/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.tree;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.libraries.BundleWrapper;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.tree.ExistingJarElement;
import com.intellij.dmserver.libraries.tree.RepositoryFolderElementBase;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class BundleFolderElement
extends RepositoryFolderElementBase {
    private static final Comparator<BundleWrapper> BY_BUNDLE_FILE_NAME = (o1, o2) -> {
        String name1 = o1.getJarFile().getName();
        String name2 = o2.getJarFile().getName();
        return name1.compareTo(name2);
    };

    public BundleFolderElement(ServerLibrariesContext context, RepositoryPattern repositoryPattern) {
        super(context, repositoryPattern, "bundles-folder");
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(DmServerBundle.message("BundleFolderElement.name", new Object[0]));
        BundleFolderElement.updateIcons(presentation);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<ExistingJarElement> result = new ArrayList<ExistingJarElement>();
        ArrayList<BundleWrapper> bundles = new ArrayList<BundleWrapper>(AvailableBundlesProvider.getInstance(this.getProject()).getRepositoryBundles(this.getRepositoryPattern()));
        Collections.sort(bundles, BY_BUNDLE_FILE_NAME);
        for (BundleWrapper bundle : bundles) {
            result.add(new ExistingJarElement(this.getProject(), bundle));
        }
        ArrayList<ExistingJarElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/libraries/tree/BundleFolderElement", "getChildren"));
        }
        return arrayList;
    }
}

