/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DMConfigurationFactory
extends ConfigurationFactory {
    private final String myName;
    private final boolean myIsLocal;

    public DMConfigurationFactory(J2EEConfigurationType type, @Nls String name, boolean isLocal) {
        super((ConfigurationType)type);
        this.myName = name;
        this.myIsLocal = isLocal;
    }

    @Nls
    public String getName() {
        return this.myName != null ? this.myName : super.getName();
    }

    public RunConfiguration createConfiguration(String name, RunConfiguration template) {
        RunConfiguration result = super.createConfiguration(name, template);
        if (result instanceof CommonModel) {
            ((CommonModel)result).initialize();
        }
        return result;
    }

    public RunConfiguration createTemplateConfiguration(Project project) {
        DMServerIntegration integration = DMServerIntegration.getInstance();
        ServerModel serverModel = this.createServerModel();
        return J2EEConfigurationFactory.getInstance().createJ2EERunConfiguration((ConfigurationFactory)this, project, serverModel, (AppServerIntegration)integration, this.myIsLocal, this.createStartupPolicy());
    }

    protected abstract ServerModel createServerModel();

    protected abstract ExecutableObjectStartupPolicy createStartupPolicy();

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/run/DMConfigurationFactory", "isApplicable"));
        }
        return J2EEConfigurationFactory.getInstance().isConfigurationApplicable((J2EEConfigurationType)this.getType(), project);
    }
}

