/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.Section;

public class ManifestUtils {
    @NonNls
    public static final String IMPORT_BUNDLE_HEADER = "Import-Bundle";
    @NonNls
    public static final String IMPORT_LIBRARY_HEADER = "Import-Library";
    @NonNls
    public static final String VERSION_RANGE_ATTRIBUTE_NAME = "version";
    @NonNls
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    @NonNls
    public static final String WEB_CONTEXT_PATH_HEADER = "Web-ContextPath";
    private static final ManifestUtils ourInstance = new ManifestUtils();

    public static ManifestUtils getInstance() {
        return ourInstance;
    }

    private ManifestUtils() {
    }

    @Nullable
    public String getHeaderValue(@NotNull PsiFile manifestFile, @NotNull String headerName) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/dmserver/util/ManifestUtils", "getHeaderValue"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "getHeaderValue"));
        }
        Header header = this.findHeader(manifestFile, headerName);
        return header != null ? this.getHeaderValue(header) : null;
    }

    @Nullable
    public String getHeaderValue(@NotNull Header header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/intellij/dmserver/util/ManifestUtils", "getHeaderValue"));
        }
        HeaderValue value = header.getHeaderValue();
        return value != null ? value.getUnwrappedText() : null;
    }

    @Nullable
    public Header findHeader(@NotNull PsiFile manifestFile, @NotNull String headerName) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/dmserver/util/ManifestUtils", "findHeader"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "findHeader"));
        }
        List<Header> headers = this.findHeaders(manifestFile, headerName);
        return headers.size() == 0 ? null : headers.get(0);
    }

    @NotNull
    public List<Header> findHeaders(@NotNull PsiFile file, @NotNull String headerName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/util/ManifestUtils", "findHeaders"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "findHeaders"));
        }
        if (!(file instanceof ManifestFile)) {
            List<Header> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/util/ManifestUtils", "findHeaders"));
            }
            return list;
        }
        List list = ContainerUtil.filter((Collection)((ManifestFile)file).getHeaders(), header -> {
            if (headerName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "lambda$findHeaders$0"));
            }
            return headerName.equalsIgnoreCase(header.getName());
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/util/ManifestUtils", "findHeaders"));
        }
        return list;
    }

    public Header createHeader(@NotNull Project project, @NotNull String headerName, @NotNull String headerValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/util/ManifestUtils", "createHeader"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "createHeader"));
        }
        if (headerValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "com/intellij/dmserver/util/ManifestUtils", "createHeader"));
        }
        return this.createHeader(project, this.createHeaderText(headerName, headerValue));
    }

    public String createHeaderText(@NotNull String headerName, @NotNull String headerValue) {
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "com/intellij/dmserver/util/ManifestUtils", "createHeaderText"));
        }
        if (headerValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "com/intellij/dmserver/util/ManifestUtils", "createHeaderText"));
        }
        return MessageFormat.format("{0}: {1}\n", headerName, headerValue);
    }

    public Header createHeader(@NotNull Project project, @NotNull CharSequence headerText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/util/ManifestUtils", "createHeader"));
        }
        if (headerText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerText", "com/intellij/dmserver/util/ManifestUtils", "createHeader"));
        }
        return (Header)ManifestUtils.createDummyFile(project, headerText).getHeaders().get(0);
    }

    private static ManifestFile createDummyFile(@NotNull Project project, @NonNls @NotNull CharSequence content) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/util/ManifestUtils", "createDummyFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/dmserver/util/ManifestUtils", "createDummyFile"));
        }
        return (ManifestFile)PsiFileFactory.getInstance((Project)project).createFileFromText("DUMMY.MF", (FileType)ManifestFileTypeFactory.MANIFEST, content);
    }

    private static Section findSection(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/util/ManifestUtils", "findSection"));
        }
        return file instanceof ManifestFile ? ((ManifestFile)file).getMainSection() : null;
    }

    public void addHeader(@NotNull PsiFile manifestFile, @NotNull Header header) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/dmserver/util/ManifestUtils", "addHeader"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/intellij/dmserver/util/ManifestUtils", "addHeader"));
        }
        Section section = ManifestUtils.findSection(manifestFile);
        if (section == null) {
            Section dummySection = ManifestUtils.findSection((PsiFile)ManifestUtils.createDummyFile(manifestFile.getManager().getProject(), "Header: value"));
            dummySection.deleteChildRange(dummySection.getFirstChild(), dummySection.getLastChild());
            manifestFile.add((PsiElement)dummySection);
            section = ManifestUtils.findSection(manifestFile);
        }
        section.add((PsiElement)header);
    }
}

