/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class SimpleBinaryTransformation
extends BinaryTransformation {
    @NotNull
    private final String myMethod;

    public SimpleBinaryTransformation(@NotNull String method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/SimpleBinaryTransformation", "<init>"));
        }
        this.myMethod = method;
    }

    @Override
    public void apply(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/SimpleBinaryTransformation", "apply"));
        }
        GrExpression lhsParenthesized = this.addParenthesesIfNeeded(this.getLhs(expression));
        GrInspectionUtil.replaceExpression(expression, String.format("%s.%s(%s)", lhsParenthesized.getText(), this.myMethod, this.getRhs(expression).getText()));
    }

    @Override
    @NotNull
    public String getMethod() {
        String string = this.myMethod;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/SimpleBinaryTransformation", "getMethod"));
        }
        return string;
    }
}

