/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0004"}, d2={"highlightKeyword", "", "element", "Lcom/intellij/psi/PsiElement;", "groovy-psi"})
public final class KeywordsKt {
    private static final boolean highlightKeyword(PsiElement element) {
        IElementType tokenType = element.getNode().getElementType();
        PsiElement parent = element.getParent();
        if (parent instanceof GrArgumentLabel) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, GrCodeReferenceElement.class) != null) {
            if (TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(tokenType)) {
                return false;
            }
        } else {
            if (tokenType == GroovyTokenTypes.kDEF && element.getParent() instanceof GrAnnotationNameValuePair) {
                return false;
            }
            if (parent instanceof GrReferenceExpression && element == ((GrReferenceExpression)parent).getReferenceNameElement()) {
                if (tokenType == GroovyTokenTypes.kSUPER && ((GrReferenceExpression)parent).getQualifier() == null) {
                    return true;
                }
                return tokenType == GroovyTokenTypes.kTHIS && ((GrReferenceExpression)parent).getQualifier() == null;
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean access$highlightKeyword(@NotNull PsiElement element) {
        return KeywordsKt.highlightKeyword(element);
    }
}

