/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;

public class InvertIfIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrUnaryExpression unaryCondition;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "processIntention"));
        }
        PsiElement parent = element.getParent();
        if (!"if".equals(element.getText()) || !(parent instanceof GrIfStatement)) {
            throw new IncorrectOperationException("Not invoked on an if");
        }
        GrIfStatement parentIf = (GrIfStatement)parent;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(project);
        GrExpression condition = parentIf.getCondition();
        if (condition == null) {
            throw new IncorrectOperationException("Invoked on an if with empty condition");
        }
        GrExpression negatedCondition = null;
        if (condition instanceof GrUnaryExpression && "!".equals((unaryCondition = (GrUnaryExpression)condition).getOperationToken().getText())) {
            negatedCondition = InvertIfIntention.stripParenthesis(unaryCondition.getOperand());
        }
        if (negatedCondition == null) {
            String negatedExpressionText = (condition = InvertIfIntention.stripParenthesis(condition)) instanceof GrCallExpression || condition instanceof GrReferenceExpression ? "!" + condition.getText() : "!(" + condition.getText() + ")";
            negatedCondition = groovyPsiElementFactory.createExpressionFromText(negatedExpressionText, parentIf);
        }
        GrStatement thenBranch = parentIf.getThenBranch();
        boolean thenIsNotEmpty = InvertIfIntention.isNotEmpty(thenBranch);
        String newIfText = "if (" + negatedCondition.getText() + ") {}";
        if (thenIsNotEmpty) {
            newIfText = newIfText + " else {}";
        }
        GrIfStatement newIf = (GrIfStatement)groovyPsiElementFactory.createStatementFromText(newIfText, parentIf.getContext());
        InvertIfIntention.generateElseBranchTextAndRemoveTailStatements(parentIf, newIf);
        if (thenIsNotEmpty) {
            GrStatement elseBranch = newIf.getElseBranch();
            assert (elseBranch != null);
            elseBranch.replaceWithStatement(thenBranch);
        }
        parentIf.replace(newIf);
    }

    private static boolean isNotEmpty(@Nullable GrStatement thenBranch) {
        return thenBranch != null && (!(thenBranch instanceof GrBlockStatement) || ((GrBlockStatement)thenBranch).getBlock().getStatements().length != 0);
    }

    private static void generateElseBranchTextAndRemoveTailStatements(@NotNull GrIfStatement ifStatement, @NotNull GrIfStatement newIf) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "generateElseBranchTextAndRemoveTailStatements"));
        }
        if (newIf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newIf", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "generateElseBranchTextAndRemoveTailStatements"));
        }
        GrStatement thenBranch = newIf.getThenBranch();
        assert (thenBranch != null);
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            thenBranch.replaceWithStatement(elseBranch);
            return;
        }
        PsiElement parent = ifStatement.getParent();
        if (!(parent instanceof GrStatementOwner)) {
            return;
        }
        if (!InvertIfIntention.isTailAfterIf(ifStatement, (GrStatementOwner)parent)) {
            return;
        }
        PsiElement start = ifStatement.getNextSibling();
        PsiElement end = parent instanceof GrCodeBlock ? ((GrCodeBlock)parent).getRBrace().getPrevSibling() : parent.getLastChild();
        GrOpenBlock block = ((GrBlockStatement)thenBranch).getBlock();
        block.addRangeAfter(start, end, block.getLBrace());
        parent.deleteChildRange(start, end);
    }

    private static boolean isTailAfterIf(@NotNull GrIfStatement ifStatement, @NotNull GrStatementOwner owner) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "isTailAfterIf"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "isTailAfterIf"));
        }
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(ifStatement);
        if (flowOwner == null) {
            return false;
        }
        Instruction[] flow = flowOwner.getControlFlow();
        Object[] statements = owner.getStatements();
        int index = ArrayUtilRt.find((Object[])statements, (Object)ifStatement);
        if (index == statements.length - 1) {
            return false;
        }
        GrStatement then = ifStatement.getThenBranch();
        for (Instruction i : flow) {
            PsiElement element = i.getElement();
            if (element == null || !PsiTreeUtil.isAncestor((PsiElement)then, (PsiElement)element, (boolean)true)) continue;
            for (Instruction succ : i.allSuccessors()) {
                if (!(succ instanceof IfEndInstruction)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static GrExpression stripParenthesis(GrExpression operand) {
        GrExpression innerExpression;
        while (operand instanceof GrParenthesizedExpression && (innerExpression = ((GrParenthesizedExpression)operand).getOperand()) != null) {
            operand = innerExpression;
        }
        GrExpression grExpression = operand;
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "stripParenthesis"));
        }
        return grExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrIfStatement)) {
                    return false;
                }
                if (((GrIfStatement)parent).getCondition() == null) {
                    return false;
                }
                return "if".equals(element.getText());
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

