/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaGlobalMemberLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

class StaticImportInsertHandler
implements InsertHandler<JavaGlobalMemberLookupElement> {
    public static final InsertHandler<JavaGlobalMemberLookupElement> INSTANCE = new StaticImportInsertHandler();

    private StaticImportInsertHandler() {
    }

    private static boolean importAlreadyExists(final PsiMember member, GroovyFile file, PsiElement place) {
        final PsiManager manager = file.getManager();
        PsiScopeProcessor processor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/completion/StaticImportInsertHandler$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/completion/StaticImportInsertHandler$1", "execute"));
                }
                return !manager.areElementsEquivalent(element, (PsiElement)member);
            }

            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/groovy/lang/completion/StaticImportInsertHandler$1", "getHint"));
                }
                return null;
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/lang/completion/StaticImportInsertHandler$1", "handleEvent"));
                }
            }
        };
        boolean skipStaticImports = member instanceof PsiClass;
        GrImportStatement[] imports2 = file.getImportStatements();
        ResolveState initial = ResolveState.initial();
        for (GrImportStatement anImport : imports2) {
            if (skipStaticImports == anImport.isStatic() || anImport.processDeclarations(processor, initial, null, place)) continue;
            return true;
        }
        return false;
    }

    public void handleInsert(InsertionContext context, JavaGlobalMemberLookupElement item) {
        GroovyInsertHandler.INSTANCE.handleInsert(context, (LookupElement)item);
        PsiMember member = item.getObject();
        PsiDocumentManager.getInstance((Project)member.getProject()).commitDocument(context.getDocument());
        GrReferenceExpression ref = (GrReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), GrReferenceExpression.class, (boolean)false);
        if (ref != null && ref.getQualifier() == null && context.getFile() instanceof GroovyFile && !StaticImportInsertHandler.importAlreadyExists(member, (GroovyFile)context.getFile(), ref) && !PsiManager.getInstance((Project)context.getProject()).areElementsEquivalent(ref.resolve(), (PsiElement)member)) {
            ref.bindToElementViaStaticImport(member);
        }
    }
}

