/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.FragmentVariableInfos;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class ReachingDefinitionsCollector {
    private ReachingDefinitionsCollector() {
    }

    @NotNull
    public static FragmentVariableInfos obtainVariableFlowInformation(@NotNull GrStatement first, @NotNull GrStatement last, @NotNull GrControlFlowOwner flowOwner, @NotNull Instruction[] flow) {
        int[] defs;
        String name;
        ReadWriteVariableInstruction rwInstruction;
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "obtainVariableFlowInformation"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "obtainVariableFlowInformation"));
        }
        if (flowOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowOwner", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "obtainVariableFlowInformation"));
        }
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "obtainVariableFlowInformation"));
        }
        DefinitionMap dfaResult = ReachingDefinitionsCollector.inferDfaResult(flow);
        LinkedHashSet<Integer> fragmentInstructions = ReachingDefinitionsCollector.getFragmentInstructions(first, last, flow);
        int[] postorder = OrderUtil.reversedPostOrder(flow);
        LinkedHashSet<Integer> reachableFromFragmentReads = ReachingDefinitionsCollector.getReachable(fragmentInstructions, flow, dfaResult, postorder);
        LinkedHashSet<Integer> fragmentReads = ReachingDefinitionsCollector.filterReads(fragmentInstructions, flow);
        LinkedHashMap<String, VariableInfo> imap = new LinkedHashMap<String, VariableInfo>();
        LinkedHashMap<String, VariableInfo> omap = new LinkedHashMap<String, VariableInfo>();
        PsiManager manager = first.getManager();
        for (Integer ref : fragmentReads) {
            rwInstruction = (ReadWriteVariableInstruction)flow[ref];
            name = rwInstruction.getVariableName();
            defs = dfaResult.getDefinitions(ref);
            if (ReachingDefinitionsCollector.allDefsInFragment(defs, fragmentInstructions)) continue;
            ReachingDefinitionsCollector.addVariable(name, imap, manager, ReachingDefinitionsCollector.getType(rwInstruction.getElement()));
        }
        for (Integer ref : reachableFromFragmentReads) {
            rwInstruction = (ReadWriteVariableInstruction)flow[ref];
            name = rwInstruction.getVariableName();
            defs = dfaResult.getDefinitions(ref);
            if (!ReachingDefinitionsCollector.anyDefInFragment(defs, fragmentInstructions)) continue;
            for (int def : defs) {
                if (!fragmentInstructions.contains(def)) continue;
                PsiType outputType = ReachingDefinitionsCollector.getType(flow[def].getElement());
                ReachingDefinitionsCollector.addVariable(name, omap, manager, outputType);
            }
            if (ReachingDefinitionsCollector.allProperDefsInFragment(defs, ref, fragmentInstructions, postorder)) continue;
            PsiType inputType = ReachingDefinitionsCollector.getType(rwInstruction.getElement());
            ReachingDefinitionsCollector.addVariable(name, imap, manager, inputType);
        }
        ReachingDefinitionsCollector.addClosureUsages(imap, omap, first, last, flowOwner);
        final VariableInfo[] iarr = ReachingDefinitionsCollector.filterNonlocals(imap, last);
        final VariableInfo[] oarr = ReachingDefinitionsCollector.filterNonlocals(omap, last);
        FragmentVariableInfos fragmentVariableInfos = new FragmentVariableInfos(){

            @Override
            public VariableInfo[] getInputVariableNames() {
                return iarr;
            }

            @Override
            public VariableInfo[] getOutputVariableNames() {
                return oarr;
            }
        };
        if (fragmentVariableInfos == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "obtainVariableFlowInformation"));
        }
        return fragmentVariableInfos;
    }

    private static DefinitionMap inferDfaResult(Instruction[] flow) {
        ReachingDefinitionsDfaInstance dfaInstance = new ReachingDefinitionsDfaInstance(flow);
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance, lattice);
        return ReachingDefinitionsCollector.postprocess(engine.performForceDFA(), flow, dfaInstance);
    }

    private static void addClosureUsages(final Map<String, VariableInfo> imap, final Map<String, VariableInfo> omap, final GrStatement first, final GrStatement last, GrControlFlowOwner flowOwner) {
        flowOwner.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$2", "visitClosure"));
                }
                this.addUsagesInClosure(imap, omap, closure, first, last);
                super.visitClosure(closure);
            }

            private void addUsagesInClosure(final Map<String, VariableInfo> imap2, final Map<String, VariableInfo> omap2, final GrClosableBlock closure, final GrStatement first2, final GrStatement last2) {
                closure.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
                        if (refExpr == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$2$1", "visitReferenceExpression"));
                        }
                        if (refExpr.isQualified()) {
                            return;
                        }
                        PsiElement resolved = refExpr.resolve();
                        if (!(resolved instanceof GrVariable)) {
                            return;
                        }
                        GrVariable variable = (GrVariable)resolved;
                        if (PsiTreeUtil.isAncestor((PsiElement)closure, (PsiElement)variable, (boolean)true)) {
                            return;
                        }
                        if (variable instanceof ClosureSyntheticParameter && PsiTreeUtil.isAncestor((PsiElement)closure, (PsiElement)((ClosureSyntheticParameter)variable).getClosure(), (boolean)false)) {
                            return;
                        }
                        String name = variable.getName();
                        if (!(variable instanceof GrField)) {
                            if (!ReachingDefinitionsCollector.isInFragment(first2, last2, resolved)) {
                                if (ReachingDefinitionsCollector.isInFragment(first2, last2, closure)) {
                                    ReachingDefinitionsCollector.addVariable(name, imap2, variable.getManager(), variable.getType());
                                }
                            } else if (!ReachingDefinitionsCollector.isInFragment(first2, last2, closure)) {
                                ReachingDefinitionsCollector.addVariable(name, omap2, variable.getManager(), variable.getType());
                            }
                        }
                    }
                });
            }
        });
    }

    private static void addVariable(String name, Map<String, VariableInfo> map, PsiManager manager, PsiType type) {
        VariableInfoImpl info = (VariableInfoImpl)map.get(name);
        if (info == null) {
            info = new VariableInfoImpl(name, manager);
            map.put(name, info);
        }
        info.addSubtype(type);
    }

    private static LinkedHashSet<Integer> filterReads(LinkedHashSet<Integer> instructions, Instruction[] flow) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Integer i : instructions) {
            Instruction instruction = flow[i];
            if (!ReachingDefinitionsCollector.isReadInsn(instruction)) continue;
            result.add(i);
        }
        return result;
    }

    private static boolean allDefsInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def)) continue;
            return false;
        }
        return true;
    }

    private static boolean allProperDefsInFragment(int[] defs, int ref, LinkedHashSet<Integer> fragmentInstructions, int[] postorder) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def) || postorder[def] >= postorder[ref]) continue;
            return false;
        }
        return true;
    }

    private static boolean anyDefInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (!fragmentInstructions.contains(def)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        if (element instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)element).getType();
        }
        return null;
    }

    private static VariableInfo[] filterNonlocals(Map<String, VariableInfo> infos, GrStatement place) {
        ArrayList<VariableInfo> result = new ArrayList<VariableInfo>();
        Iterator<VariableInfo> iterator = infos.values().iterator();
        while (iterator.hasNext()) {
            GrMember member;
            VariableInfo info = iterator.next();
            String name = info.getName();
            GroovyPsiElement property = ResolveUtil.resolveProperty(place, name);
            if (property instanceof GrVariable) {
                iterator.remove();
            } else if (property instanceof GrReferenceExpression && ((member = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)property, GrMember.class)) == null || !member.hasModifierProperty("static") && member.getContainingClass() instanceof GroovyScriptClass)) continue;
            if (ResolveUtil.resolveClass(place, name) != null) continue;
            result.add(info);
        }
        return result.toArray(new VariableInfo[result.size()]);
    }

    private static LinkedHashSet<Integer> getFragmentInstructions(GrStatement first, GrStatement last, Instruction[] flow) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Instruction instruction : flow) {
            if (!ReachingDefinitionsCollector.isInFragment(instruction, first, last)) continue;
            result.add(instruction.num());
        }
        return result;
    }

    private static boolean isInFragment(Instruction instruction, GrStatement first, GrStatement last) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            return false;
        }
        return ReachingDefinitionsCollector.isInFragment(first, last, element);
    }

    private static boolean isInFragment(GrStatement first, GrStatement last, PsiElement element) {
        PsiElement parent = first.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)element, (boolean)true)) {
            return false;
        }
        PsiElement run = element;
        while (run.getParent() != parent) {
            run = run.getParent();
        }
        return ReachingDefinitionsCollector.isBetween(first, last, run);
    }

    private static boolean isBetween(PsiElement first, PsiElement last, PsiElement run) {
        while (first != null && first != run) {
            first = first.getNextSibling();
        }
        if (first == null) {
            return false;
        }
        while (last != null && last != run) {
            last = last.getPrevSibling();
        }
        return last != null;
    }

    private static LinkedHashSet<Integer> getReachable(LinkedHashSet<Integer> fragmentInsns, Instruction[] flow, DefinitionMap dfaResult, int[] postorder) {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        block0: for (Instruction insn : flow) {
            int ref;
            int[] definitions;
            if (!ReachingDefinitionsCollector.isReadInsn(insn) || (definitions = dfaResult.getDefinitions(ref = insn.num())) == null) continue;
            for (int def : definitions) {
                if (!fragmentInsns.contains(def) || fragmentInsns.contains(ref) && (postorder[ref] >= postorder[def] || !ReachingDefinitionsCollector.checkPathIsOutsideOfFragment(def, ref, flow, fragmentInsns))) continue;
                result.add(ref);
                continue block0;
            }
        }
        return result;
    }

    private static boolean checkPathIsOutsideOfFragment(int def, int ref, Instruction[] flow, LinkedHashSet<Integer> fragmentInsns) {
        Boolean path = ReachingDefinitionsCollector.findPath(flow[def], ref, fragmentInsns, false, new HashMap<Instruction, Boolean>());
        assert (path != null) : "def=" + def + ", ref=" + ref;
        return path;
    }

    @Nullable
    private static Boolean findPath(Instruction cur, int destination, LinkedHashSet<Integer> fragmentInsns, boolean wasOutside, HashMap<Instruction, Boolean> visited) {
        wasOutside = wasOutside || !fragmentInsns.contains(cur.num());
        visited.put(cur, null);
        Iterable<Instruction> instructions = cur.allSuccessors();
        boolean pathExists = false;
        for (Instruction i : instructions) {
            Boolean result;
            if (i.num() == destination) {
                return wasOutside;
            }
            if (visited.containsKey(i)) {
                result = visited.get(i);
            } else {
                result = ReachingDefinitionsCollector.findPath(i, destination, fragmentInsns, wasOutside, visited);
                visited.put(i, result);
            }
            if (result == null) continue;
            if (result.booleanValue()) {
                visited.put(cur, true);
                return true;
            }
            pathExists = true;
        }
        if (pathExists) {
            visited.put(cur, false);
            return false;
        }
        visited.put(cur, null);
        return null;
    }

    private static boolean isReadInsn(Instruction insn) {
        return insn instanceof ReadWriteVariableInstruction && !((ReadWriteVariableInstruction)insn).isWrite();
    }

    private static String dumpDfaResult(ArrayList<TIntObjectHashMap<TIntHashSet>> dfaResult, ReachingDefinitionsDfaInstance dfa) {
        final StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < dfaResult.size(); ++i) {
            TIntObjectHashMap<TIntHashSet> map = dfaResult.get(i);
            buffer.append("At ").append(i).append(":\n");
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntHashSet>(){

                public boolean execute(int i, TIntHashSet defs) {
                    buffer.append(i).append(" -> ");
                    defs.forEach(new TIntProcedure(){

                        public boolean execute(int i) {
                            buffer.append(i).append(" ");
                            return true;
                        }
                    });
                    return true;
                }
            });
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @NotNull
    private static DefinitionMap postprocess(@NotNull List<DefinitionMap> dfaResult, @NotNull Instruction[] flow, @NotNull ReachingDefinitionsDfaInstance dfaInstance) {
        if (dfaResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaResult", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "postprocess"));
        }
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "postprocess"));
        }
        if (dfaInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaInstance", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "postprocess"));
        }
        DefinitionMap result = new DefinitionMap();
        for (int i = 0; i < flow.length; ++i) {
            ReadWriteVariableInstruction rwInsn;
            Instruction insn = flow[i];
            if (!(insn instanceof ReadWriteVariableInstruction) || (rwInsn = (ReadWriteVariableInstruction)insn).isWrite()) continue;
            int idx = dfaInstance.getVarIndex(rwInsn.getVariableName());
            result.copyFrom(dfaResult.get(i), idx, i);
        }
        DefinitionMap definitionMap = result;
        if (definitionMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector", "postprocess"));
        }
        return definitionMap;
    }

    private static class VariableInfoImpl
    implements VariableInfo {
        @NotNull
        private final String myName;
        private final PsiManager myManager;
        @Nullable
        private PsiType myType;

        VariableInfoImpl(@NotNull String name, PsiManager manager) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$VariableInfoImpl", "<init>"));
            }
            this.myName = name;
            this.myManager = manager;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/ReachingDefinitionsCollector$VariableInfoImpl", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiType getType() {
            if (this.myType instanceof PsiIntersectionType) {
                return ((PsiIntersectionType)this.myType).getConjuncts()[0];
            }
            return this.myType;
        }

        void addSubtype(PsiType t) {
            if (t != null) {
                if (this.myType == null) {
                    this.myType = t;
                } else if (!this.myType.isAssignableFrom(t)) {
                    this.myType = t.isAssignableFrom(this.myType) ? t : TypesUtil.getLeastUpperBound(this.myType, t, this.myManager);
                }
            }
        }
    }
}

