/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public abstract class GrTypeDefinitionBodyBase
extends GrStubElementBase<EmptyStub>
implements GrTypeDefinitionBody {
    public GrTypeDefinitionBodyBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase", "<init>"));
        }
        super(node);
    }

    public GrTypeDefinitionBodyBase(EmptyStub stub, IStubElementType classBody) {
        super(stub, classBody);
    }

    @Override
    public abstract void accept(GroovyElementVisitor var1);

    public String toString() {
        return "Type definition body";
    }

    @Override
    public GrField[] getFields() {
        GrVariableDeclaration[] declarations = (GrVariableDeclaration[])this.getStubOrPsiChildren(GroovyElementTypes.VARIABLE_DEFINITION, GrVariableDeclaration.ARRAY_FACTORY);
        ArrayList result = ContainerUtil.newArrayList();
        for (GrVariableDeclaration declaration : declarations) {
            GrVariable[] variables;
            for (GrVariable variable : variables = declaration.getVariables()) {
                if (!(variable instanceof GrField)) continue;
                result.add((GrField)variable);
            }
        }
        return result.toArray(new GrField[result.size()]);
    }

    @Override
    public GrMethod[] getMethods() {
        return (GrMethod[])this.getStubOrPsiChildren(TokenSets.METHOD_DEFS, GrMethod.ARRAY_FACTORY);
    }

    @Override
    public GrMembersDeclaration[] getMemberDeclarations() {
        return (GrMembersDeclaration[])this.findChildrenByClass(GrMembersDeclaration.class);
    }

    @Override
    @Nullable
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findChildByType(GroovyTokenTypes.mRCURLY);
    }

    @Override
    @NotNull
    public GrClassInitializer[] getInitializers() {
        GrClassInitializer[] grClassInitializerArray = (GrClassInitializer[])this.findChildrenByClass(GrClassInitializer.class);
        if (grClassInitializerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase", "getInitializers"));
        }
        return grClassInitializerArray;
    }

    @Override
    @NotNull
    public GrTypeDefinition[] getInnerClasses() {
        GrTypeDefinition[] grTypeDefinitionArray = (GrTypeDefinition[])this.getStubOrPsiChildren(TokenSets.TYPE_DEFINITIONS, GrTypeDefinition.ARRAY_FACTORY);
        if (grTypeDefinitionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase", "getInnerClasses"));
        }
        return grTypeDefinitionArray;
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        PsiElement rBrace = this.getRBrace();
        if (anchor == null && rBrace == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        ASTNode elemNode = declaration.getNode();
        ASTNode anchorNode = anchor != null ? anchor.getNode() : rBrace.getNode();
        this.getNode().addChild(elemNode, anchorNode);
        this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        return (GrVariableDeclaration)elemNode.getPsi();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase", "deleteChildInternal"));
        }
        PsiElement element = child.getPsi();
        if (element instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, element);
        }
        super.deleteChildInternal(child);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrTopStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode afterLast = last.getTreeNext();
        ASTNode child = first;
        while (child != afterLast) {
            ASTNode next = child.getTreeNext();
            if (child.getElementType() == GroovyElementTypes.CONSTRUCTOR_DEFINITION) {
                ASTNode oldIdentifier = child.findChildByType(GroovyTokenTypes.mIDENT);
                ASTNode newIdentifier = ((GrTypeDefinition)this.getParent()).getNameIdentifierGroovy().getNode().copyElement();
                child.replaceChild(oldIdentifier, newIdentifier);
            }
            child = next;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public static class GrEnumBody
    extends GrTypeDefinitionBodyBase
    implements GrEnumDefinitionBody,
    StubBasedPsiElement<EmptyStub> {
        public GrEnumBody(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase$GrEnumBody", "<init>"));
            }
            super(node);
        }

        public GrEnumBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyElementTypes.ENUM_BODY);
        }

        @Override
        @Nullable
        public GrEnumConstantList getEnumConstantList() {
            return (GrEnumConstantList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.ENUM_CONSTANTS);
        }

        @Override
        public void accept(GroovyElementVisitor visitor2) {
            visitor2.visitEnumDefinitionBody(this);
        }
    }

    public static class GrClassBody
    extends GrTypeDefinitionBodyBase
    implements StubBasedPsiElement<EmptyStub> {
        public GrClassBody(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionBodyBase$GrClassBody", "<init>"));
            }
            super(node);
        }

        public GrClassBody(EmptyStub stub) {
            super(stub, (IStubElementType)GroovyElementTypes.CLASS_BODY);
        }

        @Override
        public void accept(GroovyElementVisitor visitor2) {
            visitor2.visitTypeDefinitionBody(this);
        }
    }
}

