/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.transformations.dsl.MemberBuilder;

public interface TransformationContext {
    @NotNull
    public Project getProject();

    @NotNull
    public PsiManager getManager();

    @NotNull
    public JavaPsiFacade getPsiFacade();

    @NotNull
    public GrTypeDefinition getCodeClass();

    @NotNull
    public PsiClassType getClassType();

    @NotNull
    public Collection<PsiMethod> getMethods();

    @NotNull
    public Collection<GrField> getFields();

    @NotNull
    public Collection<PsiClass> getInnerClasses();

    @NotNull
    public List<PsiClassType> getImplementsTypes();

    @NotNull
    public List<PsiClassType> getExtendsTypes();

    @NotNull
    default public List<PsiClassType> getSuperTypes() {
        List list = ContainerUtil.concat(this.getExtendsTypes(), this.getImplementsTypes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContext", "getSuperTypes"));
        }
        return list;
    }

    @NotNull
    default public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.getCodeClass().getResolveScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/TransformationContext", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public String getClassName();

    @Nullable
    public PsiClass getSuperClass();

    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String var1);

    default public boolean isInheritor(@NotNull String fqn) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/plugins/groovy/transformations/TransformationContext", "isInheritor"));
        }
        PsiClass baseClass = this.getPsiFacade().findClass(fqn, this.getResolveScope());
        return baseClass != null && this.isInheritor(baseClass);
    }

    public boolean isInheritor(@NotNull PsiClass var1);

    @NotNull
    public Collection<PsiMethod> findMethodsByName(@NotNull String var1, boolean var2);

    default public void addMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/TransformationContext", "addMethod"));
        }
        this.addMethod(method, false);
    }

    public void addMethod(@NotNull PsiMethod var1, boolean var2);

    public void addMethods(@NotNull PsiMethod[] var1);

    public void addMethods(@NotNull Collection<? extends PsiMethod> var1);

    public void removeMethod(@NotNull PsiMethod var1);

    public void addField(@NotNull GrField var1);

    public void addInnerClass(@NotNull PsiClass var1);

    public void setSuperType(@NotNull String var1);

    public void setSuperType(@NotNull PsiClassType var1);

    public void addInterface(@NotNull String var1);

    public void addInterface(@NotNull PsiClassType var1);

    @NotNull
    public MemberBuilder getMemberBuilder();
}

