/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.util.SdkHomeBean;

public abstract class SdkHomeSettings
implements PersistentStateComponent<SdkHomeBean> {
    private final PsiModificationTrackerImpl myTracker;
    private SdkHomeBean mySdkHome;

    protected SdkHomeSettings(Project project) {
        this.myTracker = (PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker();
    }

    public SdkHomeBean getState() {
        return this.mySdkHome;
    }

    public void loadState(SdkHomeBean state) {
        SdkHomeBean oldState = this.mySdkHome;
        this.mySdkHome = state;
        if (oldState != null) {
            this.myTracker.incCounter();
        }
    }

    @Nullable
    private static VirtualFile calcHome(SdkHomeBean state) {
        if (state == null) {
            return null;
        }
        String sdk_home = state.SDK_HOME;
        if (StringUtil.isEmpty((String)sdk_home)) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(sdk_home);
    }

    @Nullable
    public VirtualFile getSdkHome() {
        return SdkHomeSettings.calcHome(this.mySdkHome);
    }

    public List<VirtualFile> getClassRoots() {
        return SdkHomeSettings.calcRoots(this.getSdkHome());
    }

    private static List<VirtualFile> calcRoots(@Nullable VirtualFile home) {
        if (home == null) {
            return Collections.emptyList();
        }
        VirtualFile lib = home.findChild("lib");
        if (lib == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile file : lib.getChildren()) {
            if (!"jar".equals(file.getExtension())) continue;
            ContainerUtil.addIfNotNull(result, (Object)StandardFileSystems.getJarRootForLocalFile((VirtualFile)file));
        }
        return result;
    }
}

