/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.jpa.JpaDataSourceDetector;
import com.intellij.jpa.JpaDataSourceDetectorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class HibernateDataSourceDetector
extends JpaDataSourceDetectorBase<HibernateFacet> {
    public HibernateDataSourceDetector() {
        super(HibernateFacet.ID);
    }

    protected Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders() {
        return Collections.singletonMap("Hibernate", JpaDataSourceDetector.providerHibernate());
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/hibernate/HibernateDataSourceDetector", "isRelevantFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
        return virtualFile != null && HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA.getFileName().equals(virtualFile.getName()) && !fileIndex.isInTestSourceContent(virtualFile);
    }
}

