/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.actions;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignNamingStrategiesAction
extends AnAction {
    public void update(AnActionEvent e) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        boolean enabled = facet instanceof HibernateFacet;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        if (!(facet instanceof HibernateFacet)) {
            return;
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent((HibernateFacet)facet, e.getPresentation().getText()));
    }

    @NotNull
    private static ArrayList<String> findAllNamingStrategies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/hibernate/actions/AssignNamingStrategiesAction", "findAllNamingStrategies"));
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        HibernateVersion version = HibernateUtil.getHibernateVersion(module);
        ArrayList<String> nameList = new ArrayList<String>();
        for (String s : version.getNamingStrategies()) {
            PsiClass namingStrategyClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(s, searchScope);
            if (namingStrategyClass != null) {
                ClassInheritorsSearch.search((PsiClass)namingStrategyClass, (SearchScope)searchScope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                    String name;
                    if (PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)true) && !nameList.contains(name = psiClass.getQualifiedName())) {
                        nameList.add(name);
                    }
                    return true;
                });
            }
            Collections.sort(nameList);
        }
        ArrayList<String> arrayList = nameList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/actions/AssignNamingStrategiesAction", "findAllNamingStrategies"));
        }
        return arrayList;
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<HibernateFacet, String> {
        private final String myTitle;
        private final ComboBoxTableRenderer<String> myCombo;

        public MyComponent(HibernateFacet facet, String title) {
            super((PersistenceFacet)facet);
            this.myTitle = title;
            ArrayList nameList = AssignNamingStrategiesAction.findAllNamingStrategies(((HibernateFacet)this.myFacet).getModule());
            nameList.add(0, "");
            this.myCombo = new ComboBoxTableRenderer<String>(ArrayUtil.toStringArray((Collection)nameList)){

                public boolean isCellEditable(EventObject event) {
                    return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
                }

                protected String getTextFor(@NotNull String value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent$1", "getTextFor"));
                    }
                    return value.isEmpty() ? "Default naming strategy" : value;
                }

                protected Icon getIconFor(@NotNull String value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent$1", "getIconFor"));
                    }
                    return value.isEmpty() ? EmptyIcon.ICON_16 : PlatformIcons.CLASS_ICON;
                }

                protected void customizeComponent(String value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (!isSelected && (value == null || value.isEmpty())) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }
            };
        }

        @NotNull
        protected ComboBoxTableRenderer<String> getComboBoxTableRenderer() {
            ComboBoxTableRenderer<String> comboBoxTableRenderer = this.myCombo;
            if (comboBoxTableRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent", "getComboBoxTableRenderer"));
            }
            return comboBoxTableRenderer;
        }

        @NotNull
        protected String getValueColumnName() {
            if ("Naming Strategy" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/actions/AssignNamingStrategiesAction$MyComponent", "getValueColumnName"));
            }
            return "Naming Strategy";
        }

        @Nullable
        protected String getSettingValue(PersistencePackage unit) {
            return ((HibernateFacet)this.myFacet).getNamingStrategy(unit);
        }

        protected void setSettingValue(PersistencePackage unit, String value) {
            ((HibernateFacet)this.myFacet).setNamingStrategy(unit, value);
        }

        @Nls
        public String getDisplayName() {
            return this.myTitle;
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }
    }
}

