/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.hibernate.model.converters.MappingClassResolveConverter;
import com.intellij.hibernate.model.enums.HibernateTypeType;
import com.intellij.hibernate.model.xml.impl.mapping.HbmHibernateMappingImpl;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.model.xml.impl.converters.ClassConverterBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.ResolvingConverter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyTypeResolvingConverter
extends ResolvingConverter<PsiType>
implements CustomReferenceConverter {
    public PsiElement getPsiElement(@Nullable PsiType resolvedValue) {
        return resolvedValue instanceof PsiClassType ? ((PsiClassType)resolvedValue).resolve() : null;
    }

    @NotNull
    public Collection<? extends PsiType> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/PropertyTypeResolvingConverter", "getVariants"));
        }
        return list;
    }

    public LookupElement[] getVariantsInner(PersistentAttribute attribute, PsiFile file, HbmHibernateMappingImpl mapping, @Nullable Module module) {
        if (module == null) {
            return LookupElement.EMPTY_ARRAY;
        }
        return this.getVariantsInner(attribute, file, mapping, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    public LookupElement[] getVariantsInner(PersistentAttribute attribute, PsiFile file, HbmHibernateMappingImpl mapping, GlobalSearchScope scope) {
        PsiType existingType;
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        if (attribute != null) {
            PsiType type = attribute.getPsiType();
            existingType = this.getExistingType(AttributeType.getAttributeType((PersistentAttribute)attribute), PersistenceCommonUtil.getTypeInfo((PsiType)type));
        } else {
            existingType = null;
        }
        PropertyTypeResolvingConverter.addStandardTypdefsAndUserTypes(existingType, result, mapping, file, scope);
        return result.toArray(new LookupElement[result.size()]);
    }

    @Nullable
    protected PsiType getExistingType(AttributeType attributeType, JavaTypeInfo typeInfo) {
        return attributeType.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY) && typeInfo.parameters.length > 0 ? typeInfo.parameters[0] : typeInfo.baseType;
    }

    private static void addStandardTypdefsAndUserTypes(PsiType existingType, Collection<LookupElement> result, HbmHibernateMappingImpl mapping, PsiFile file, GlobalSearchScope scope) {
        PsiClass[] userTypeClasses = new PsiClass[]{DomJavaUtil.findClass((String)"org.hibernate.usertype.UserType", (PsiFile)file, null, (GlobalSearchScope)scope), DomJavaUtil.findClass((String)"org.hibernate.usertype.CompositeUserType", (PsiFile)file, null, (GlobalSearchScope)scope)};
        THashMap types = new THashMap();
        for (PsiClass typeClass : userTypeClasses) {
            if (typeClass == null) continue;
            for (PsiClass psiClass : ClassInheritorsSearch.search((PsiClass)typeClass, (SearchScope)scope, (boolean)true)) {
                String qname;
                if (psiClass.isInterface() || PsiUtil.isAbstractClass((PsiClass)psiClass) || (qname = psiClass.getQualifiedName()) == null) continue;
                types.put((Object)qname, (Object)psiClass);
            }
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
        for (HibernateTypeType type : HibernateTypeType.values()) {
            String string = type.getJavaTypeName();
            String boxed = PsiTypesUtil.boxIfPossible((String)type.getJavaTypeName());
            try {
                PsiClass psiClass;
                PsiType psiType = elementFactory.createTypeFromText(boxed, null);
                PsiClass psiClass2 = psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
                if (psiType != null && existingType != null && !psiType.isAssignableFrom(existingType)) continue;
                types.put((Object)boxed, (Object)psiClass);
                if (boxed == string) continue;
                types.put((Object)string, null);
            }
            catch (IncorrectOperationException psiType) {
                // empty catch block
            }
        }
        List<BidirectionalMultiMap<String, String>> typeDefs = PropertyTypeResolvingConverter.getTypeDefs(mapping);
        for (BidirectionalMultiMap<String, String> typeDef : typeDefs) {
            for (String string : typeDef.getKeys()) {
                if (!types.containsKey((Object)string)) {
                    try {
                        PsiType psiType = elementFactory.createTypeFromText(string, null);
                        PsiClass psiClass = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
                        types.put((Object)string, (Object)psiClass);
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                }
                for (String typeDefName : typeDef.getValues((Object)string)) {
                    if (types.containsKey((Object)typeDefName)) continue;
                    types.put((Object)typeDefName, null);
                }
            }
        }
        for (String name : types.keySet()) {
            PsiClass psiClass = (PsiClass)types.get((Object)name);
            if (psiClass != null) {
                String string = psiClass.getQualifiedName();
                result.add((LookupElement)LookupElementBuilder.create((Object)psiClass, (String)string).withPresentableText(psiClass.getName()).withLookupString(psiClass.getName()).withIcon(psiClass.getIcon(0)));
                continue;
            }
            result.add((LookupElement)LookupElementBuilder.create((String)name).bold());
        }
        for (Iterator<Object> iterator : HibernateTypeType.values()) {
            if (!types.contains((Object)((HibernateTypeType)((Object)iterator)).getJavaTypeName()) && !types.contains((Object)PsiTypesUtil.boxIfPossible((String)((HibernateTypeType)((Object)iterator)).getJavaTypeName()))) continue;
            result.add(PrioritizedLookupElement.withGrouping((LookupElement)LookupElementBuilder.create((String)((HibernateTypeType)((Object)iterator)).getValue()), (int)2));
        }
    }

    private static List<BidirectionalMultiMap<String, String>> getTypeDefs(HbmHibernateMappingImpl mapping) {
        if (mapping != null) {
            ArrayList<BidirectionalMultiMap<String, String>> typedefs = new ArrayList<BidirectionalMultiMap<String, String>>();
            typedefs.add(mapping.getTypedefMap());
            for (PersistencePackage unit : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)mapping)) {
                for (GenericValue value : unit.getModelHelper().getMappingFiles(HbmHibernateMappingImpl.class)) {
                    HbmHibernateMappingImpl otherMapping = (HbmHibernateMappingImpl)value.getValue();
                    if (otherMapping == null) continue;
                    typedefs.add(otherMapping.getTypedefMap());
                }
            }
            return typedefs;
        }
        return Collections.emptyList();
    }

    public PsiType fromString(@Nullable @NonNls String s, ConvertContext context) {
        return this.fromStringInner(s, context.getFile().getProject(), MappingClassResolveConverter.getRoot(context));
    }

    public PsiType fromStringInner(String s, Project project, HbmHibernateMappingImpl mapping) {
        if (s == null) {
            return null;
        }
        HibernateTypeType basicType = (HibernateTypeType)NamedEnumUtil.getEnumElementByValue(HibernateTypeType.class, (String)s);
        try {
            String typedefClassName;
            String typeName = basicType == null ? (StringUtil.isNotEmpty((String)(typedefClassName = PropertyTypeResolvingConverter.getFromTypeDefs(s, mapping))) ? typedefClassName : (TypeConversionUtil.isPrimitive((String)s) ? s : ClassConverterBase.getQualifiedClassName((String)s, (String)MappingClassResolveConverter.getPackageName(mapping)))) : basicType.getJavaTypeName();
            assert (typeName != null);
            PsiType type = JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeFromText(typeName, null);
            return type instanceof PsiClassType && ((PsiClassType)type).resolve() == null ? null : type;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static String getFromTypeDefs(String s, HbmHibernateMappingImpl mapping) {
        if (mapping == null) {
            return null;
        }
        Set keys = mapping.getTypedefMap().getKeys((Object)s);
        if (keys != null && !keys.isEmpty()) {
            return (String)keys.iterator().next();
        }
        for (PersistencePackage unit : PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)mapping)) {
            for (GenericValue value : unit.getModelHelper().getMappingFiles(HbmHibernateMappingImpl.class)) {
                HbmHibernateMappingImpl otherMapping = (HbmHibernateMappingImpl)value.getValue();
                if (otherMapping == null || (keys = otherMapping.getTypedefMap().getKeys((Object)s)) == null || keys.isEmpty()) continue;
                return (String)keys.iterator().next();
            }
        }
        return null;
    }

    public String toString(@Nullable PsiType psiType, ConvertContext context) {
        return psiType == null ? null : psiType.getCanonicalText();
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        return ClassConverterBase.getCreateClassQuickFixes((ConvertContext)context, (String)MappingClassResolveConverter.getPackageName(context));
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue genericDomValue, PsiElement element, final ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                PsiType type = PropertyTypeResolvingConverter.this.fromString(genericDomValue.getStringValue(), context);
                if (type instanceof PsiClassType) {
                    return ((PsiClassType)type).resolve();
                }
                if (type != null) {
                    return DomUtil.getValueElement((GenericDomValue)genericDomValue);
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = PropertyTypeResolvingConverter.this.getVariantsInner((PersistentAttribute)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), HbmAttributeBase.class, (boolean)true), (PsiFile)context.getFile(), MappingClassResolveConverter.getRoot(context), context.getSearchScope());
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/PropertyTypeResolvingConverter$1", "getVariants"));
                }
                return objectArray;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/hibernate/model/converters/PropertyTypeResolvingConverter$1", "bindToElement"));
                }
                if (element instanceof PsiClass) {
                    genericDomValue.setStringValue(((PsiClass)element).getQualifiedName());
                    return genericDomValue.getXmlTag();
                }
                return super.bindToElement(element);
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/PropertyTypeResolvingConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

