/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VtlFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/VtlFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/velocity/VtlFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement element = node.getPsi();
        if (!(element instanceof VtlFile)) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlFoldingBuilder", "buildFoldRegions"));
            }
            return FoldingDescriptor.EMPTY;
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        PsiElement firstChild = element.getFirstChild();
        if (firstChild != null && FormatterUtil.containsWhiteSpacesOnly((ASTNode)firstChild.getNode())) {
            firstChild = firstChild.getNextSibling();
        }
        if (firstChild instanceof PsiComment) {
            descriptors.add(new FoldingDescriptor(firstChild.getNode(), firstChild.getTextRange()));
        }
        for (VtlDirective composite : ((VtlFile)element).getDirectiveChildren()) {
            VtlFoldingBuilder.addFoldingDescriptors(descriptors, composite);
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/VtlFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, VtlDirective composite) {
        int start = composite.getFoldingStartOffset();
        int end = composite.getFoldingEndOffset();
        ASTNode node = composite.getNode();
        if (start + 1 >= end || node == null) {
            return;
        }
        descriptors.add(new FoldingDescriptor(node, new TextRange(start, end)));
        for (VtlDirective child : composite.getDirectiveChildren()) {
            VtlFoldingBuilder.addFoldingDescriptors(descriptors, child);
        }
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/VtlFoldingBuilder", "getPlaceholderText"));
        }
        PsiElement psi = node.getPsi();
        if (psi instanceof VtlMacro) {
            return "(" + ((VtlMacro)psi).getName() + ")...";
        }
        if (psi instanceof PsiComment) {
            return "#*...*#";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/VtlFoldingBuilder", "isCollapsedByDefault"));
        }
        if (node instanceof PsiComment) {
            return CodeFoldingSettings.getInstance().COLLAPSE_FILE_HEADER;
        }
        return false;
    }
}

