/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.templateLanguages.TemplateDataHighlighterWrapper;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import com.intellij.velocity.psi.files.VtlSyntaxHighlighter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public VtlEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colors", "com/intellij/velocity/psi/files/VtlEditorHighlighter", "<init>"));
        }
        super((SyntaxHighlighter)new VtlSyntaxHighlighter(), colors);
        SyntaxHighlighter highlighter = VtlEditorHighlighter.getTemplateDataLanguageHighlighter(project, virtualFile);
        this.registerLayer(VtlElementTypes.TEMPLATE_TEXT, new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(highlighter), ""));
    }

    @NotNull
    private static SyntaxHighlighter getTemplateDataLanguageHighlighter(Project project, VirtualFile virtualFile) {
        LanguageFileType type = project == null || virtualFile == null ? null : VtlFileViewProvider.getTemplateDataLanguage(virtualFile, project).getAssociatedFileType();
        LanguageFileType fileType = type == null ? FileTypes.PLAIN_TEXT : type;
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, (VirtualFile)virtualFile);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlEditorHighlighter", "getTemplateDataLanguageHighlighter"));
        }
        return syntaxHighlighter;
    }
}

