/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.inspections.VtlReferencesInspection;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.reference.VelocityNamingUtil;
import com.intellij.velocity.psi.reference.VelocityStyleBeanProperty;
import com.intellij.velocity.psi.reference.VelocityStylePropertyResolveHelper;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VtlVariantsProcessor<T>
extends BaseScopeProcessor {
    private final Set<T> myResult = new LinkedHashSet<T>();
    private final boolean myForCompletion;
    private final boolean myMethodCall;
    private boolean myMacroCall;
    private final PsiElement myParent;
    private final String myReferenceName;
    private final VelocityStylePropertyResolveHelper myPropertyMethods;
    private final JavaMethodResolveHelper myMethods;
    private final PsiClassType myOwnerClassType;

    protected VtlVariantsProcessor(PsiElement parent, boolean propertiesOnly) {
        this(parent, null, propertiesOnly, null);
    }

    protected VtlVariantsProcessor(PsiElement parent, @Nullable String referenceName, boolean propertiesOnly, @Nullable PsiClassType ownerClassType) {
        this.myForCompletion = referenceName == null;
        this.myParent = parent;
        this.myReferenceName = referenceName;
        this.myMethodCall = this.myParent instanceof VtlMethodCallExpression;
        this.myMacroCall = this.myParent instanceof VtlMacroCall;
        if (this.myMacroCall) {
            this.myPropertyMethods = null;
            this.myMethods = null;
            this.myOwnerClassType = null;
            return;
        }
        if (this.myMethodCall && !this.myForCompletion) {
            assert (!propertiesOnly);
            PsiType[] parameterTypes = ((VtlMethodCallExpression)this.myParent).getArgumentTypes();
            this.myMethods = new JavaMethodResolveHelper(parent, parent.getContainingFile(), parameterTypes);
            this.myOwnerClassType = ownerClassType;
            this.myPropertyMethods = null;
        } else {
            this.myPropertyMethods = new VelocityStylePropertyResolveHelper(this.myReferenceName, this.myParent instanceof VtlAssignment);
            this.myMethods = this.myForCompletion && !propertiesOnly ? new JavaMethodResolveHelper(parent, parent.getContainingFile(), null) : null;
            this.myOwnerClassType = null;
        }
    }

    private boolean shouldExposeFields() {
        PsiFile file = this.myParent.getContainingFile();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        InspectionToolWrapper wrapper = profile.getInspectionTool("VtlReferencesInspection", (PsiElement)file);
        if (wrapper == null) {
            return false;
        }
        return ((VtlReferencesInspection)wrapper.getTool()).fieldsExposed;
    }

    public void setMacroCall(boolean macroCall) {
        this.myMacroCall = macroCall;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiMethod method;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/psi/reference/VtlVariantsProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/reference/VtlVariantsProcessor", "execute"));
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        if (StringUtil.isEmpty((String)namedElement.getName())) {
            return true;
        }
        if (namedElement instanceof PsiClass) {
            return true;
        }
        if (this.myMacroCall != namedElement instanceof VtlMacro) {
            return true;
        }
        if (namedElement instanceof PsiModifierListOwner && !((PsiModifierListOwner)namedElement).hasModifierProperty("public")) {
            return true;
        }
        if (namedElement instanceof PsiField && (((PsiField)namedElement).hasModifierProperty("static") || !this.shouldExposeFields())) {
            return true;
        }
        boolean isMethodCall = namedElement instanceof PsiMethod;
        if (isMethodCall) {
            method = (PsiMethod)namedElement;
            if (method.isConstructor()) {
                return true;
            }
            if (this.myForCompletion && VelocityNamingUtil.isWaitOrNotifyOfObject(method)) {
                return true;
            }
            if (!this.myMethodCall) {
                this.myPropertyMethods.checkAndAddMethod(method, (PsiSubstitutor)state.get(PsiSubstitutor.KEY));
            }
            if (this.myMethods == null) {
                return true;
            }
        }
        if (!this.myForCompletion && isMethodCall != this.myMethodCall) {
            return true;
        }
        if (!this.myForCompletion && !this.myReferenceName.equals(namedElement.getName())) {
            return true;
        }
        if (isMethodCall) {
            method = (PsiMethod)namedElement;
            PsiSubstitutor substitutor = this.myOwnerClassType == null ? (PsiSubstitutor)state.get(PsiSubstitutor.KEY) : TypeConversionUtil.getSuperClassSubstitutor((PsiClass)method.getContainingClass(), (PsiClassType)this.myOwnerClassType);
            this.myMethods.addMethod(method, substitutor, false);
            return true;
        }
        boolean resolvedWithError = false;
        if (!this.myForCompletion && this.myMacroCall) {
            int argumentsLength;
            int parametersLength = ((VtlMacro)namedElement).getParameters().length;
            resolvedWithError = parametersLength != (argumentsLength = ((VtlMacroCall)this.myParent).getArguments().length);
        }
        ContainerUtil.addIfNotNull(this.myResult, this.execute(namedElement, resolvedWithError));
        return this.myForCompletion || this.myResult.size() != 1;
    }

    @Nullable
    protected abstract T execute(PsiNamedElement var1, boolean var2);

    public T[] getVariants(T[] array, boolean isFirstCharInLowerCase) {
        if (this.myPropertyMethods != null) {
            for (PsiMethod method : this.myPropertyMethods.getMethods()) {
                String propName;
                BeanProperty property = VelocityStyleBeanProperty.createVelocityStyleBeanProperty(method, propName = this.myReferenceName != null ? this.myReferenceName : VelocityNamingUtil.getPropertyNameFromAccessor(method, isFirstCharInLowerCase));
                if (property == null) continue;
                ContainerUtil.addIfNotNull(this.myResult, this.execute(property.getPsiElement(), false));
            }
        }
        if (this.myMethods != null) {
            for (PsiMethod method : this.myMethods.getMethods()) {
                ContainerUtil.addIfNotNull(this.myResult, this.execute((PsiNamedElement)method.getMethod(), this.myMethods.getResolveError() == JavaMethodResolveHelper.ErrorType.RESOLVE));
            }
        }
        return this.myResult.toArray(array);
    }
}

