/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.SpringElTemplateParser;
import com.intellij.spring.el.contextProviders.SpringElContextProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringElInjector
implements MultiHostInjector {
    private static final Set<String> ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.beans.factory.annotation.Value", "org.springframework.scheduling.annotation.Scheduled"});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        PsiElement parent;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/el/SpringElInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/el/SpringElInjector", "getLanguagesToInject"));
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)host.getProject())) {
            return;
        }
        if (host instanceof XmlAttributeValue) {
            PsiFile file = host.getContainingFile();
            if (!JamCommonUtil.isPlainXmlFile((PsiElement)file)) {
                return;
            }
            if (SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
                SpringElInjector.doRegister(registrar, host);
            }
        } else if (host instanceof PsiLiteralExpression && (parent = host.getParent().getParent()) instanceof PsiAnnotationParameterList && !parent.getProject().isDefault() && SpringElInjector.isSpringElCompatibleAnnotation((PsiAnnotation)parent.getParent())) {
            SpringElInjector.doRegister(registrar, host);
        }
    }

    private static boolean isSpringElCompatibleAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiAnnotation", "com/intellij/spring/el/SpringElInjector", "isSpringElCompatibleAnnotation"));
        }
        return ANNOTATIONS.contains(psiAnnotation.getQualifiedName());
    }

    private static void doRegister(MultiHostRegistrar registrar, PsiElement host) {
        String text = host.getText();
        List<TextRange> ranges = SpringElTemplateParser.parse(text);
        if (!ranges.isEmpty()) {
            for (TextRange textRange : ranges) {
                registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
            }
            host.putUserData(ELContextProvider.ourContextProviderKey, (Object)new SpringElContextProvider(host));
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, PsiLiteralExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringElInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

