/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGwtInspection
extends BaseJavaLocalInspectionTool {
    protected static boolean shouldCheck(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/gwt/inspections/BaseGwtInspection", "shouldCheck"));
        }
        return BaseGwtInspection.getFacet(psiElement) != null;
    }

    protected static boolean hasGwtFacets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/BaseGwtInspection", "hasGwtFacets"));
        }
        return ProjectFacetManager.getInstance((Project)project).hasFacets(GwtFacetType.ID);
    }

    @Nullable
    protected static GwtFacet getFacet(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/gwt/inspections/BaseGwtInspection", "getFacet"));
        }
        return GwtFacet.findFacetBySourceFile(psiElement.getProject(), psiElement.getContainingFile().getVirtualFile());
    }

    @NotNull
    protected static PsiElement getElementToHighlight(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/inspections/BaseGwtInspection", "getElementToHighlight"));
        }
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        Object object = identifier != null ? identifier : psiClass;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/BaseGwtInspection", "getElementToHighlight"));
        }
        return object;
    }

    @NotNull
    protected static PsiElement getElementToHighlight(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/gwt/inspections/BaseGwtInspection", "getElementToHighlight"));
        }
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        Object object = identifier != null ? identifier : psiMethod;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/BaseGwtInspection", "getElementToHighlight"));
        }
        return object;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GwtBundle.message("group.gwt.inspections.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/BaseGwtInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/BaseGwtInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

