/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsPsiUtil {
    public static boolean isAccessedForWriting(@NotNull JSGwtReferenceExpressionImpl expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/gwt/jsinject/JsPsiUtil", "isAccessedForWriting"));
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{JSParenthesizedExpression.class});
        if (JsPsiUtil.isOnAssignmentLeftHand(parent)) {
            return true;
        }
        if (parent instanceof JSReferenceExpression) {
            if ((parent = parent.getParent()) instanceof JSPrefixExpression) {
                IElementType tokenType = ((JSPrefixExpression)parent).getOperationSign();
                return tokenType == JSTokenTypes.PLUSPLUS || tokenType == JSTokenTypes.MINUSMINUS;
            }
            if (parent instanceof JSPostfixExpression) {
                IElementType tokenType = ((JSPostfixExpression)parent).getOperationSign();
                return tokenType == JSTokenTypes.PLUSPLUS || tokenType == JSTokenTypes.MINUSMINUS;
            }
        }
        return false;
    }

    public static boolean isAccessedForReading(@NotNull JSGwtReferenceExpressionImpl expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/gwt/jsinject/JsPsiUtil", "isAccessedForReading"));
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{JSParenthesizedExpression.class});
        return !JsPsiUtil.isOnAssignmentLeftHand(parent) || ((JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSAssignmentExpression.class)).getOperationSign() != JSTokenTypes.EQ;
    }

    private static boolean isOnAssignmentLeftHand(@Nullable PsiElement expr) {
        PsiElement assignment;
        PsiElement definition;
        return expr instanceof JSReferenceExpression && (definition = expr.getParent()) instanceof JSDefinitionExpression && (assignment = definition.getParent()) instanceof JSAssignmentExpression;
    }
}

