/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.GwtUiComponentDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringSetSpinAllocator;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtCompositeXmlElementDescriptor
implements XmlElementDescriptor,
XmlElementDescriptorAwareAboutChildren {
    private GwtUiComponentDescriptor myMainDescriptor;
    private XmlElementDescriptor myAdditionalDescriptor;

    public GwtCompositeXmlElementDescriptor(@NotNull GwtUiComponentDescriptor mainDescriptor, @NotNull XmlElementDescriptor additionalDescriptor) {
        if (mainDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainDescriptor", "com/intellij/gwt/uiBinder/GwtCompositeXmlElementDescriptor", "<init>"));
        }
        if (additionalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalDescriptor", "com/intellij/gwt/uiBinder/GwtCompositeXmlElementDescriptor", "<init>"));
        }
        this.myMainDescriptor = mainDescriptor;
        this.myAdditionalDescriptor = additionalDescriptor;
    }

    public PsiElement getDeclaration() {
        return this.myMainDescriptor.getDeclaration();
    }

    public String getName() {
        return this.myMainDescriptor.getName();
    }

    public String getQualifiedName() {
        return this.myMainDescriptor.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myMainDescriptor.getDefaultName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        boolean addAllComponents = false;
        if (this.myAdditionalDescriptor instanceof XmlElementDescriptorImpl) {
            TypeDescriptor type = ((XmlElementDescriptorImpl)this.myAdditionalDescriptor).getType((XmlElement)context);
            addAllComponents = type instanceof ComplexTypeDescriptor && ((ComplexTypeDescriptor)type).hasAnyInContentModel();
        }
        XmlElementDescriptor[] main = addAllComponents ? this.myMainDescriptor.getComponentDescriptors(context) : EMPTY_ARRAY;
        XmlElementDescriptor[] additional = this.myAdditionalDescriptor.getElementsDescriptors(context);
        if (main.length == 0) {
            return additional;
        }
        if (additional.length == 0) {
            return main;
        }
        ArrayList<XmlElementDescriptor> descriptors = new ArrayList<XmlElementDescriptor>();
        Set names = StringSetSpinAllocator.alloc();
        try {
            for (XmlElementDescriptor descriptor : main) {
                descriptors.add(descriptor);
                names.add(descriptor.getName());
            }
            for (XmlElementDescriptor descriptor : additional) {
                if (names.contains(descriptor.getName())) continue;
                descriptors.add(descriptor);
            }
        }
        finally {
            StringSetSpinAllocator.dispose((Set)names);
        }
        return descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlElementDescriptor descriptor = this.myMainDescriptor.getElementDescriptor(childTag, contextTag);
        return descriptor != null && !(descriptor instanceof AnyXmlElementDescriptor) ? descriptor : this.myAdditionalDescriptor.getElementDescriptor(childTag, contextTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return GwtCompositeXmlElementDescriptor.mergeDescriptors(this.myMainDescriptor.getAttributesDescriptors(context), this.myAdditionalDescriptor.getAttributesDescriptors(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlAttributeDescriptor[] mergeDescriptors(XmlAttributeDescriptor[] main, XmlAttributeDescriptor[] additional) {
        if (main.length == 0) {
            return additional;
        }
        if (additional.length == 0) {
            return main;
        }
        ArrayList<XmlAttributeDescriptor> descriptors = new ArrayList<XmlAttributeDescriptor>();
        Set names = StringSetSpinAllocator.alloc();
        try {
            for (XmlAttributeDescriptor descriptor : main) {
                descriptors.add(descriptor);
                names.add(descriptor.getName());
            }
            for (XmlAttributeDescriptor descriptor : additional) {
                if (names.contains(descriptor.getName())) continue;
                descriptors.add(descriptor);
            }
        }
        finally {
            StringSetSpinAllocator.dispose((Set)names);
        }
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor descriptor = this.myMainDescriptor.getAttributeDescriptor(attributeName, context);
        return descriptor != null ? descriptor : this.myAdditionalDescriptor.getAttributeDescriptor(attributeName, context);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        XmlAttributeDescriptor descriptor = this.myMainDescriptor.getAttributeDescriptor(attribute);
        return descriptor != null ? descriptor : this.myAdditionalDescriptor.getAttributeDescriptor(attribute);
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return this.myMainDescriptor.allowElementsFromNamespace(namespace, context) || this.myAdditionalDescriptor instanceof XmlElementDescriptorAwareAboutChildren && ((XmlElementDescriptorAwareAboutChildren)this.myAdditionalDescriptor).allowElementsFromNamespace(namespace, context);
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myMainDescriptor.getNSDescriptor();
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return this.myMainDescriptor.getContentType();
    }

    public String getDefaultValue() {
        return null;
    }

    public String getName(PsiElement context) {
        return this.myMainDescriptor.getName(context);
    }

    public void init(PsiElement element) {
        this.myAdditionalDescriptor.init(element);
    }

    public Object[] getDependences() {
        return this.myAdditionalDescriptor.getDependences();
    }
}

