/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import org.jetbrains.annotations.NotNull;

public class WebServerConnector
implements RemoteConnector {
    private Deployable myConfig;

    public WebServerConnector(Deployable config) {
        this.myConfig = config;
    }

    public String getId() {
        return this.myConfig.getId();
    }

    @NotNull
    public String getName() {
        String string = this.myConfig.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/WebServerConnector", "getName"));
        }
        return string;
    }

    @NotNull
    public RemoteConnectionType getType() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.DEPLOYMENT_SERVER;
        if (remoteConnectionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/WebServerConnector", "getType"));
        }
        return remoteConnectionType;
    }

    public void produceRemoteCredentials(@NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/plugins/remotesdk/console/WebServerConnector", "produceRemoteCredentials"));
        }
        RemoteSdkCredentialsHolder holder = new RemoteSdkCredentialsHolder("");
        RemoteSdkUtil.initRemoteSdkData((RemoteSdkCredentials)holder, this.myConfig);
        consumer.consume((Object)holder);
    }

    @NotNull
    public Object getConnectorKey() {
        String string = "Deployment: " + this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/WebServerConnector", "getConnectorKey"));
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }
}

