/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.remote.ext.UnknownCredentialsLanguageContribution;
import com.intellij.ui.ClickListener;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AsyncProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkCredentialsProducerImpl;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkDialog;
import com.jetbrains.plugins.remotesdk.ui.CredentialsEditorProvider;
import com.jetbrains.plugins.remotesdk.ui.InvalidCredentialsEditor;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.remotesdk.ui.RemoteCredentialsEditor;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkByDeploymentForm;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import com.jetbrains.plugins.remotesdk.ui.VagrantCredentialsEditor;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.ErrorMessageAndField;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateRemoteSdkForm<T extends RemoteSdkAdditionalData>
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm");
    private JPanel myMainPanel;
    private JBLabel myInterpreterPathLabel;
    protected TextFieldWithBrowseButton myInterpreterPathField;
    protected TextFieldWithBrowseButton myHelpersPathField;
    private JTextField myNameField;
    private JBLabel myNameLabel;
    private JBLabel myHelpersPathLabel;
    protected RemoteCredentialsEditor myCredentialsForm;
    private JBRadioButton myPlainSshRadio;
    private JBRadioButton myVagrantRadio;
    protected JBRadioButton myDeploymentRadio;
    protected RemoteSdkByDeploymentForm myDeploymentForm;
    private JPanel myStatusPanelHolder;
    private final StatusPanel myStatusPanel;
    @Nullable
    private VagrantCredentialsEditor myVagrantCredentialsForm;
    private JPanel myRadioPanel;
    private JPanel myTypesPanel;
    private ButtonGroup myTypeButtonGroup;
    private boolean myNameVisible;
    private final Project myProject;
    private Runnable myValidator;
    @NotNull
    private final BundleAccessor myBundleAccessor;
    private boolean myTempFilesPathVisible;
    private CredentialsType myConnectionType;
    private final Map<CredentialsType, TypeHandler> myCredentialsType2Handler;
    private final Set<CredentialsType> myInvalidTypes;

    public CreateRemoteSdkForm(@NotNull CreateRemoteSdkDialog<T> dialog, @NotNull BundleAccessor bundleAccessor) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        if (bundleAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAccessor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        this(dialog.getProject(), dialog, () -> {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "lambda$new$0"));
            }
            dialog.onValidationPress();
        }, bundleAccessor);
    }

    public CreateRemoteSdkForm(@Nullable Project project, @NotNull RemoteSdkEditorContainer container, @Nullable Runnable validator, @NotNull BundleAccessor bundleAccessor) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        if (bundleAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAccessor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        super(new BorderLayout());
        this.myConnectionType = CredentialsType.SSH_HOST;
        this.$$$setupUI$$$();
        this.myInvalidTypes = new HashSet<CredentialsType>();
        this.myProject = project;
        this.myCredentialsForm = new RemoteCredentialsEditor();
        this.myCredentialsForm.setContainer(container);
        this.myBundleAccessor = bundleAccessor;
        this.myValidator = validator;
        this.add((Component)this.myMainPanel, "Center");
        this.myStatusPanel = new StatusPanel();
        this.myStatusPanelHolder.setLayout(new BorderLayout());
        this.myStatusPanelHolder.add((Component)((Object)this.myStatusPanel), "Center");
        this.setNameVisible(false);
        this.setTempFilesPathVisible(false);
        this.myInterpreterPathLabel.setLabelFor((Component)this.myInterpreterPathField.getTextField());
        this.myInterpreterPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.path.label", new Object[0]));
        this.myHelpersPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.label", new Object[0]));
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction(this.myInterpreterPathField, this.myBundleAccessor.message("remote.interpreter.configure.path.title", new Object[0]), this.getRemoteCredentialsProducer());
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction(this.myHelpersPathField, this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.title", new Object[0]), this.getRemoteCredentialsProducer());
        this.myTypesPanel.setLayout(new ResizingCardLayout());
        this.myCredentialsType2Handler = ContainerUtil.newHashMap();
        this.installStandardTypes(project, container);
        this.installExtendedTypes(project);
        this.initWithDefaultValues();
        this.installRadioListeners(this.myCredentialsType2Handler.values());
        this.radioSelected(true);
    }

    private void installStandardTypes(@Nullable Project project, @NotNull RemoteSdkEditorContainer container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "installStandardTypes"));
        }
        String defaultInterpreterPath = this.myBundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
        this.myTypesPanel.add((Component)this.myCredentialsForm.createEditor(), CredentialsType.SSH_HOST.getName());
        this.myCredentialsType2Handler.put(CredentialsType.SSH_HOST, new TypeHandler(this.myPlainSshRadio, this.myCredentialsForm.createEditor(), this.myCredentialsForm.getPreferredFocusedComponent(), defaultInterpreterPath){

            @Override
            public void onInit() {
                CreateRemoteSdkForm.this.alignEditorFields(CreateRemoteSdkForm.this.myCredentialsForm);
            }

            @Override
            public void onSelected() {
                CreateRemoteSdkForm.this.alignEditorFields(CreateRemoteSdkForm.this.myCredentialsForm);
                CreateRemoteSdkForm.this.plainSshSelected();
            }

            @Override
            public ValidationInfo validate(Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
                RemoteCredentialsVerifiableHolder credentials = new RemoteCredentialsVerifiableHolder();
                FileTransferConfig config = new FileTransferConfig(credentials);
                CreateRemoteSdkForm.this.applyEditorCredentialsTo((MutableRemoteCredentials)credentials);
                config.setAccessType(AccessType.SFTP);
                ValidationInfo validationInfo = CreateRemoteSdkForm.this.validateConnection(config);
                if (validationInfo != null) {
                    return validationInfo;
                }
                if (StringUtil.isEmpty((String)this.getInterpreterPath())) {
                    return new ValidationInfo(CreateRemoteSdkForm.this.myBundleAccessor.message("remote.interpreter.unspecified.interpreter.path", new Object[0]), (JComponent)CreateRemoteSdkForm.this.myInterpreterPathField);
                }
                if (CreateRemoteSdkForm.this.myTempFilesPathVisible && StringUtil.isEmpty((String)CreateRemoteSdkForm.this.getTempFilesPath())) {
                    return new ValidationInfo(CreateRemoteSdkForm.this.myBundleAccessor.message("remote.interpreter.unspecified.temp.files.path", new Object[0]), (JComponent)CreateRemoteSdkForm.this.myHelpersPathField);
                }
                return null;
            }
        });
        VagrantSupport vagrantSupport = VagrantSupport.getInstance();
        if (vagrantSupport == null) {
            this.myVagrantRadio.setVisible(false);
            this.myVagrantCredentialsForm = null;
        } else {
            this.myVagrantCredentialsForm = new VagrantCredentialsEditor(vagrantSupport, this);
            JPanel vagrantCredentialsPanel = this.myVagrantCredentialsForm.getPanel();
            this.myTypesPanel.add((Component)vagrantCredentialsPanel, CredentialsType.VAGRANT.getName());
            this.myCredentialsType2Handler.put(CredentialsType.VAGRANT, new TypeHandler(this.myVagrantRadio, vagrantCredentialsPanel, this.myVagrantCredentialsForm.getPreferredFocusedComponent(), defaultInterpreterPath){

                @Override
                public void onInit() {
                    CreateRemoteSdkForm.this.alignEditorFields(CreateRemoteSdkForm.this.myVagrantCredentialsForm);
                }

                @Override
                public void onSelected() {
                    CreateRemoteSdkForm.this.alignEditorFields(CreateRemoteSdkForm.this.myVagrantCredentialsForm);
                    CreateRemoteSdkForm.this.myVagrantCredentialsForm.onSelected();
                }

                @Override
                public ValidationInfo validate(Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
                    return CreateRemoteSdkForm.this.myVagrantCredentialsForm.validate(configRef, allowSlowActions);
                }
            });
        }
        this.myDeploymentForm = this.createDeploymentForm(project, container.getDisposable());
        this.myTypesPanel.add(this.myDeploymentForm.getMainPanel(), CredentialsType.WEB_DEPLOYMENT.getName());
        this.myCredentialsType2Handler.put(CredentialsType.WEB_DEPLOYMENT, new TypeHandler(this.myDeploymentRadio, this.myDeploymentForm.getMainPanel(), this.myDeploymentForm.getPreferredFocusedComponent(), defaultInterpreterPath){

            @Override
            public void onInit() {
                CreateRemoteSdkForm.this.alignDeploymentEditorFields();
            }

            @Override
            public void onSelected() {
                CreateRemoteSdkForm.this.alignDeploymentEditorFields();
                CreateRemoteSdkForm.this.myDeploymentForm.deploymentSelected();
            }

            @Override
            public ValidationInfo validate(Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
                ValidationInfo validationInfo = CreateRemoteSdkForm.this.myDeploymentForm.validate();
                if (validationInfo != null) {
                    return validationInfo;
                }
                String webServerId = CreateRemoteSdkForm.this.myDeploymentForm.getDeploymentCredentials().getWebServerConfigId();
                RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(CreateRemoteSdkForm.this.myProject, webServerId);
                if (sshCredentials != null) {
                    configRef.set((Object)CreateRemoteSdkForm.credentialsAsFileTransferConfig(sshCredentials));
                }
                return null;
            }
        });
    }

    private void alignEditorFields(@NotNull PanelWithAnchor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "alignEditorFields"));
        }
        this.myInterpreterPathLabel.setAnchor(null);
        editor.setAnchor((JComponent)this.myInterpreterPathLabel);
    }

    private void alignEditorFields(@NotNull CredentialsEditor<?> editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "alignEditorFields"));
        }
        this.myInterpreterPathLabel.setAnchor(null);
        if (editor instanceof PanelWithAnchor) {
            ((PanelWithAnchor)editor).setAnchor((JComponent)this.myInterpreterPathLabel);
        }
    }

    private void alignDeploymentEditorFields() {
        this.myInterpreterPathLabel.setAnchor((JComponent)this.myDeploymentForm.getNavigatableLabel());
    }

    private void installRadioListeners(@NotNull Collection<TypeHandler> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "installRadioListeners"));
        }
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRemoteSdkForm.this.radioSelected(true);
            }
        };
        for (TypeHandler typeHandler : values) {
            typeHandler.getRadioButton().addActionListener(l);
        }
    }

    private void installExtendedTypes(@Nullable Project project) {
        for (final CredentialsTypeEx typeEx : CredentialsManager.getInstance().getExTypes()) {
            CredentialsLanguageContribution contribution2;
            CredentialsEditorProvider editorProvider = (CredentialsEditorProvider)ObjectUtils.tryCast((Object)typeEx, CredentialsEditorProvider.class);
            if (editorProvider == null) continue;
            List<CredentialsLanguageContribution> contributions = this.getContributions();
            if (!contributions.isEmpty()) {
                if (contributions.contains(CredentialsLanguageContribution.NOT_IMPLEMENTED)) {
                    return;
                }
                for (CredentialsLanguageContribution contribution2 : contributions) {
                    if (contribution2.getType() != typeEx || !editorProvider.isAvailable(contribution2)) continue;
                    JBRadioButton typeButton = new JBRadioButton(typeEx.getName());
                    this.myTypeButtonGroup.add((AbstractButton)typeButton);
                    this.myRadioPanel.add((Component)typeButton);
                    CredentialsEditor editor = editorProvider.createEditor(project, contribution2, this.myStatusPanel);
                    JPanel editorMainPanel = editor.getMainPanel();
                    this.myTypesPanel.add((Component)editorMainPanel, typeEx.getName());
                    this.myCredentialsType2Handler.put((CredentialsType)typeEx, new TypeHandlerEx(typeButton, editorMainPanel, null, editorProvider.getDefaultInterpreterPath(this.myBundleAccessor), typeEx, editor));
                }
                continue;
            }
            JBRadioButton typeButton = new JBRadioButton(typeEx.getName());
            this.myTypeButtonGroup.add((AbstractButton)typeButton);
            this.myRadioPanel.add((Component)typeButton);
            contribution2 = new UnknownCredentialsLanguageContribution(typeEx);
            CredentialsEditor editor = editorProvider.createEditor(project, contribution2, this.myStatusPanel);
            editor = new InvalidCredentialsEditor((CredentialsType)typeEx, editor);
            JPanel editorMainPanel = editor.getMainPanel();
            this.myTypesPanel.add((Component)editorMainPanel, typeEx.getName());
            this.myCredentialsType2Handler.put((CredentialsType)typeEx, new TypeHandlerEx(typeButton, editorMainPanel, null, editorProvider.getDefaultInterpreterPath(this.myBundleAccessor), typeEx, editor){

                @Override
                public ValidationInfo validate(Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
                    return new ValidationInfo(CreateRemoteSdkForm.canNotLoadCredentialsTypeMessage((CredentialsType)typeEx));
                }
            });
            this.myInvalidTypes.add((CredentialsType)typeEx);
        }
    }

    @NotNull
    protected List<CredentialsLanguageContribution> getContributions() {
        List<CredentialsLanguageContribution> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getContributions"));
        }
        return list;
    }

    @Deprecated
    public CreateRemoteSdkForm<T> skipPathMappingValidation() {
        return this;
    }

    @NotNull
    protected RemoteSdkByDeploymentForm createDeploymentForm(@Nullable Project project, @NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "createDeploymentForm"));
        }
        RemoteSdkByDeploymentForm remoteSdkByDeploymentForm = new RemoteSdkByDeploymentForm(project, disposable, this.myBundleAccessor){

            @Override
            public void onDeploymentUpdated(@NotNull WebDeploymentCredentialsHolder deploymentCredentials) {
                if (deploymentCredentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentCredentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$6", "onDeploymentUpdated"));
                }
                CreateRemoteSdkForm.this.updateConnectionType(CredentialsType.WEB_DEPLOYMENT);
            }

            @Override
            public void updateCredentials(@Nullable RemoteCredentials credentials, @NotNull JLabel hostLabel, @NotNull JLabel hostUrl, @Nullable Runnable testConnectionCallBack) {
                if (hostLabel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostLabel", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$6", "updateCredentials"));
                }
                if (hostUrl == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostUrl", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$6", "updateCredentials"));
                }
                CreateRemoteSdkForm.this.useReferencedCredentials(credentials, hostLabel, hostUrl, testConnectionCallBack);
            }
        };
        if (remoteSdkByDeploymentForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "createDeploymentForm"));
        }
        return remoteSdkByDeploymentForm;
    }

    protected void updateConnectionType(@NotNull CredentialsType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateConnectionType"));
        }
        this.myConnectionType = type;
    }

    private void radioSelected(boolean propagateEvent) {
        CredentialsType selectedType = this.getSelectedType();
        CardLayout layout = (CardLayout)this.myTypesPanel.getLayout();
        layout.show(this.myTypesPanel, selectedType.getName());
        this.changeWindowHeightToPreferred();
        this.setBrowseButtonsVisible(this.myCredentialsType2Handler.get(selectedType).isBrowsingAvailable());
        if (propagateEvent) {
            this.myStatusPanel.resetState();
            String interpreterPath = this.myInterpreterPathField.getText();
            if (StringUtil.isNotEmpty((String)interpreterPath)) {
                this.myCredentialsType2Handler.get(this.myConnectionType).setInterpreterPath(interpreterPath);
            }
            this.myConnectionType = selectedType;
            TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.myConnectionType);
            this.myInterpreterPathField.setText(typeHandler.getInterpreterPath());
            typeHandler.onSelected();
            if (typeHandler.getPreferredFocusedComponent() != null) {
                typeHandler.getPreferredFocusedComponent().requestFocus();
            }
        } else {
            this.myCredentialsType2Handler.get(selectedType).onInit();
        }
    }

    private void changeWindowHeightToPreferred() {
        Window window = UIUtil.getWindow((Component)this.myMainPanel);
        if (window != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                Dimension currentSize = window.getSize();
                Dimension preferredSize = window.getPreferredSize();
                window.setSize(currentSize.width, preferredSize.height);
            }, ModalityState.stateForComponent((Component)window));
        }
    }

    private CredentialsType getSelectedType() {
        for (Map.Entry<CredentialsType, TypeHandler> type2handler : this.myCredentialsType2Handler.entrySet()) {
            if (!type2handler.getValue().getRadioButton().isSelected()) continue;
            return type2handler.getKey();
        }
        throw new IllegalStateException();
    }

    private void setBrowseButtonsVisible(boolean visible) {
        this.myInterpreterPathField.getButton().setVisible(visible);
        this.myHelpersPathField.getButton().setVisible(visible);
    }

    protected void plainSshSelected() {
        this.myConnectionType = CredentialsType.SSH_HOST;
    }

    @NotNull
    public final RemoteSdkCredentials computeSdkCredentials() throws ExecutionException, InterruptedException {
        T sdkData = this.createSdkDataInner();
        RemoteSdkCredentials remoteSdkCredentials = sdkData.getRemoteSdkCredentials(this.myProject, true);
        if (remoteSdkCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "computeSdkCredentials"));
        }
        return remoteSdkCredentials;
    }

    @NotNull
    public final NullableComputable<RemoteSdkCredentials> getRemoteSdkCredentialsComputable() {
        NullableComputable nullableComputable = () -> {
            try {
                return this.computeSdkCredentials();
            }
            catch (Exception e) {
                return null;
            }
        };
        if (nullableComputable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getRemoteSdkCredentialsComputable"));
        }
        return nullableComputable;
    }

    public final AsyncProducer<RemoteCredentials> getRemoteCredentialsProducer() {
        return consumer -> {
            RemoteSdkCredentials credentials = (RemoteSdkCredentials)this.getRemoteSdkCredentialsComputable().compute();
            if (credentials != null) {
                consumer.consume((Object)credentials);
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myNameVisible) {
            return this.myNameField;
        }
        CredentialsType selectedType = this.getSelectedType();
        TypeHandler typeHandler = this.myCredentialsType2Handler.get(selectedType);
        if (typeHandler != null && typeHandler.getPreferredFocusedComponent() != null) {
            return typeHandler.getPreferredFocusedComponent();
        }
        return this.myTypesPanel;
    }

    public final T createSdkData() {
        T sdkData = this.createSdkDataInner();
        sdkData.completeInitialization();
        return sdkData;
    }

    protected T createSdkDataInner() {
        T sdkData = this.doCreateSdkData(this.getInterpreterPath());
        CredentialsCase[] cases = new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder cred) {
                CreateRemoteSdkForm.this.applyEditorCredentialsTo((MutableRemoteCredentials)cred);
            }
        }, new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder credentials) {
                VagrantBasedCredentialsHolder sourceCredentials = CreateRemoteSdkForm.this.getVagrantCredentials();
                if (sourceCredentials != null) {
                    credentials.setVagrantFolder(sourceCredentials.getVagrantFolder());
                    credentials.setMachineName(sourceCredentials.getMachineName());
                }
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder credentials) {
                WebDeploymentCredentialsHolder sourceCredentials = CreateRemoteSdkForm.this.getDeploymentCredentials();
                if (sourceCredentials != null && sourceCredentials.getWebServerConfigId() != null) {
                    credentials.copyFrom(sourceCredentials);
                }
            }
        }};
        this.myConnectionType.saveCredentials(sdkData, new CaseCollector(){

            @Override
            protected void processEx(CredentialsEditor editor, Object credentials) {
                editor.saveCredentials(credentials);
            }
        }.collectCases(cases));
        sdkData.setHelpersPath(this.getTempFilesPath());
        return sdkData;
    }

    @NotNull
    protected abstract T doCreateSdkData(@NotNull String var1);

    private void initWithDefaultValues() {
        this.myInterpreterPathField.setText(this.myBundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]));
        RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
        credentials.setPort(22);
        credentials.setStorePassphrase(true);
        credentials.setStorePassword(true);
        this.myCredentialsForm.resetEditorFrom((MutableRemoteCredentials)credentials);
    }

    private void setNameVisible(boolean visible) {
        this.myNameField.setVisible(visible);
        this.myNameLabel.setVisible(visible);
        this.myNameVisible = visible;
    }

    public void setSdkName(String name) {
        if (name != null) {
            this.setNameVisible(true);
            this.myNameField.setText(name);
        }
    }

    public void init(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "init"));
        }
        this.myConnectionType = data.connectionCredentials().getRemoteConnectionType();
        TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.myConnectionType);
        if (typeHandler != null) {
            typeHandler.getRadioButton().setSelected(true);
        }
        CredentialsCase[] cases = new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder credentialsHolder) {
                RemoteCredentialsVerifiableHolder credentials = new RemoteCredentialsVerifiableHolder();
                RemoteSdkUtil.copyData((RemoteCredentials)credentialsHolder, credentials);
                credentials.setUserName(credentialsHolder.getUserName());
                credentials.setPassword(credentialsHolder.getPassword());
                credentials.setPassphrase(credentialsHolder.getPassphrase());
                CreateRemoteSdkForm.this.myCredentialsForm.resetFrom(credentials);
            }
        }, new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder cred) {
                if (CreateRemoteSdkForm.this.myVagrantCredentialsForm == null) {
                    VagrantSupport.showMissingVagrantSupportMessage((Project)CreateRemoteSdkForm.this.myProject);
                } else {
                    CreateRemoteSdkForm.this.myVagrantCredentialsForm.initVagrantSettings(cred);
                }
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder cred) {
                CreateRemoteSdkForm.this.myDeploymentForm.init(cred);
            }
        }};
        data.switchOnConnectionType(new CaseCollector(){

            @Override
            protected void processEx(CredentialsEditor editor, Object credentials) {
                editor.init(credentials);
            }
        }.collectCases(cases));
        this.radioSelected(false);
        String interpreterPath = data.getInterpreterPath();
        this.myInterpreterPathField.setText(interpreterPath);
        if (typeHandler != null) {
            typeHandler.setInterpreterPath(interpreterPath);
        }
        if (typeHandler == null || this.myInvalidTypes.contains(this.myConnectionType)) {
            if (this.myConnectionType instanceof CredentialsTypeEx) {
                UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)CreateRemoteSdkForm.canNotLoadCredentialsTypeMessage(this.myConnectionType), (String)"Failed Loading Interpreter"));
            }
            LOG.warn("Can not find handler for interpreter type: " + this.myConnectionType.getName());
        }
        this.setTempFilesPath((RemoteSdkAdditionalData)data);
    }

    @NotNull
    public static String canNotLoadCredentialsTypeMessage(@NotNull CredentialsType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "canNotLoadCredentialsTypeMessage"));
        }
        String string = "Can not load " + type.getName() + " interpreter. Please make sure corresponding plugin is enabled.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "canNotLoadCredentialsTypeMessage"));
        }
        return string;
    }

    private void setTempFilesPath(RemoteSdkAdditionalData data) {
        this.myHelpersPathField.setText(data.getHelpersPath());
        if (!StringUtil.isEmpty((String)data.getHelpersPath())) {
            this.setTempFilesPathVisible(true);
        }
    }

    protected void setTempFilesPathVisible(boolean visible) {
        this.myHelpersPathField.setVisible(visible);
        this.myHelpersPathLabel.setVisible(visible);
        this.myTempFilesPathVisible = visible;
    }

    protected void setInterpreterPathVisible(boolean visible) {
        this.myInterpreterPathField.setVisible(visible);
        this.myInterpreterPathLabel.setVisible(visible);
    }

    public String getInterpreterPath() {
        return this.myInterpreterPathField.getText();
    }

    public String getTempFilesPath() {
        return this.myHelpersPathField.getText();
    }

    @NotNull
    public static FileTransferConfig credentialsAsFileTransferConfig(@NotNull RemoteCredentials remoteCredentials) {
        if (remoteCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteCredentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "credentialsAsFileTransferConfig"));
        }
        RemoteCredentialsVerifiableHolder credentials = new RemoteCredentialsVerifiableHolder();
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)credentials);
        FileTransferConfig fileTransferConfig = new FileTransferConfig(credentials);
        if (fileTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "credentialsAsFileTransferConfig"));
        }
        return fileTransferConfig;
    }

    private VagrantBasedCredentialsHolder getVagrantCredentials() {
        return this.myVagrantCredentialsForm != null ? this.myVagrantCredentialsForm.getVagrantCredentials() : null;
    }

    private WebDeploymentCredentialsHolder getDeploymentCredentials() {
        return this.myDeploymentForm.getDeploymentCredentials();
    }

    private void applyEditorCredentialsTo(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "applyEditorCredentialsTo"));
        }
        try {
            this.myCredentialsForm.applyTo(credentials);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Nullable
    private ValidationInfo validateConnection(FileTransferConfig config) {
        ErrorMessageAndField error = config.validateUiFast();
        return error == null ? null : this.myCredentialsForm.createValidationInfo(error);
    }

    @Nullable
    public ValidationInfo validateRemoteInterpreter() {
        return this.validateRemoteInterpreter(true);
    }

    @Nullable
    public ValidationInfo validateRemoteInterpreter(boolean allowSlowActions) {
        String validation;
        block5: {
            TypeHandler typeHandler = this.myCredentialsType2Handler.get(this.getSelectedType());
            Ref configRef = Ref.create();
            ValidationInfo result = typeHandler.validate((Ref<FileTransferConfig>)configRef, allowSlowActions);
            if (configRef.isNull()) {
                return result;
            }
            if (result != null) {
                return result;
            }
            try {
                validation = ((FileTransferConfig)configRef.get()).validateSlow(500L, false);
            }
            catch (TimeoutException e) {
                validation = "Connection timeout";
                if (e.getMessage() == null) break block5;
                validation = validation + ":" + e.getMessage();
            }
        }
        if (validation != null) {
            return new ValidationInfo(validation);
        }
        return null;
    }

    @Nullable
    public String getSdkName() {
        if (this.myNameVisible) {
            return this.myNameField.getText().trim();
        }
        return null;
    }

    protected void useReferencedCredentials(final @Nullable RemoteCredentials credentials, @NotNull JLabel hostLabel, @NotNull JLabel hostUrl, final @Nullable Runnable testConnectionCallBack) {
        if (hostLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostLabel", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "useReferencedCredentials"));
        }
        if (hostUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostUrl", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "useReferencedCredentials"));
        }
        if (credentials != null) {
            hostUrl.setVisible(true);
            hostLabel.setVisible(true);
            String credentialsString = StringUtil.isNotEmpty((String)credentials.getUserName()) && StringUtil.isNotEmpty((String)credentials.getHost()) ? RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials) : "";
            hostUrl.setText("<html><a href=\"#\">" + credentialsString);
            hostUrl.setCursor(Cursor.getPredefinedCursor(12));
            for (MouseListener ml : hostUrl.getMouseListeners()) {
                hostUrl.removeMouseListener(ml);
            }
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$15", "onClick"));
                    }
                    if (clickCount == 1) {
                        StatusPanel.Action testConnectionAction = CreateRemoteSdkForm.this.myStatusPanel.progress("Testing connection...");
                        if (testConnectionCallBack != null) {
                            testConnectionCallBack.run();
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            if (CreateRemoteSdkForm.this.doTestConnection(credentials)) {
                                testConnectionAction.doneWithResult(WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{credentials.getHost()}));
                            } else {
                                testConnectionAction.failed(WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{credentials.getHost(), ""}));
                                ApplicationManager.getApplication().invokeLater(() -> {
                                    if (CreateRemoteSdkForm.this.myValidator != null) {
                                        CreateRemoteSdkForm.this.myValidator.run();
                                    }
                                }, ModalityState.stateForComponent((Component)CreateRemoteSdkForm.this));
                            }
                        });
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)hostUrl);
        } else {
            hostUrl.setVisible(false);
            hostLabel.setVisible(false);
        }
    }

    private boolean doTestConnection(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "doTestConnection"));
        }
        try {
            return RemoteSdkUtil.doTestConnection(this.myProject, credentials, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public void updateModifiedValues(RemoteSdkCredentials data) {
        this.myHelpersPathField.setText(data.getHelpersPath());
    }

    public void updateHelpersPath(String helpersPath) {
        this.myHelpersPathField.setText(helpersPath);
    }

    public boolean isSdkInConsistentState(@NotNull CredentialsType connectionType) {
        if (connectionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionType", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "isSdkInConsistentState"));
        }
        return this.myCredentialsType2Handler.get(connectionType).getRadioButton().isSelected();
    }

    public String getValidationError() {
        return this.myStatusPanel.getError();
    }

    public void validateWithValidator() {
        if (this.myValidator != null) {
            this.myValidator.run();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public StatusPanel getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getStatusPanel"));
        }
        return statusPanel;
    }

    @NotNull
    public JBLabel getInterpreterPathLabel() {
        JBLabel jBLabel = this.myInterpreterPathLabel;
        if (jBLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getInterpreterPathLabel"));
        }
        return jBLabel;
    }

    public boolean supportsSdkType(@NotNull CredentialsType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "supportsSdkType"));
        }
        return this.myCredentialsType2Handler.containsKey(type);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JTextField jTextField;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), null, null));
        this.myInterpreterPathLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Python interpreter path:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHelpersPathLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Helpers path:");
        jPanel4.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHelpersPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myStatusPanelHolder = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTypesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myRadioPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 5, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myVagrantRadio = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("Vagrant");
        jBRadioButton3.setMnemonic('V');
        jBRadioButton3.setDisplayedMnemonicIndex(0);
        Component component = jPanel.add((Component)jBRadioButton3);
        this.myDeploymentRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Deployment configuration");
        jBRadioButton2.setMnemonic('D');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jBRadioButton2.setSelected(true);
        Component component2 = jPanel.add((Component)jBRadioButton2);
        this.myPlainSshRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("SSH Credentials");
        jBRadioButton.setMnemonic('S');
        jBRadioButton.setDisplayedMnemonicIndex(0);
        jBRadioButton.setSelected(false);
        Component component3 = jPanel.add((Component)jBRadioButton);
        jBLabel.setLabelFor(jTextField);
        this.myTypeButtonGroup = buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static final class ResizingCardLayout
    extends CardLayout {
        private ResizingCardLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getPreferredSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getMinimumSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }
    }

    private abstract class CaseCollector {
        private CaseCollector() {
        }

        public CredentialsCase[] collectCases(CredentialsCase ... cases) {
            ArrayList<1> exCases = new ArrayList<1>();
            for (TypeHandler typeHandler : CreateRemoteSdkForm.this.myCredentialsType2Handler.values()) {
                final TypeHandlerEx handlerEx = (TypeHandlerEx)ObjectUtils.tryCast((Object)typeHandler, TypeHandlerEx.class);
                if (handlerEx == null) continue;
                exCases.add(new CredentialsCase(){

                    public CredentialsType getType() {
                        return handlerEx.getType();
                    }

                    public void process(Object credentials) {
                        CaseCollector.this.processEx(handlerEx.getEditor(), credentials);
                    }
                });
            }
            return (CredentialsCase[])ArrayUtil.mergeArrays((Object[])cases, (Object[])exCases.toArray(new CredentialsCase[exCases.size()]));
        }

        protected abstract void processEx(CredentialsEditor var1, Object var2);
    }

    private class TypeHandlerEx
    extends TypeHandler {
        private final CredentialsTypeEx myType;
        private final CredentialsEditor myEditor;

        public TypeHandlerEx(JBRadioButton radioButton, @Nullable JPanel panel, JComponent preferredFocusedComponent, String defaultInterpreterPath, CredentialsTypeEx type, CredentialsEditor editor) {
            super(radioButton, panel, preferredFocusedComponent, defaultInterpreterPath);
            this.myType = type;
            this.myEditor = editor;
        }

        public CredentialsEditor getEditor() {
            return this.myEditor;
        }

        @Override
        public void onInit() {
            CreateRemoteSdkForm.this.alignEditorFields(this.myEditor);
        }

        @Override
        public void onSelected() {
            CreateRemoteSdkForm.this.alignEditorFields(this.myEditor);
            CreateRemoteSdkForm.this.myConnectionType = (CredentialsType)this.myType;
            this.myEditor.onSelected();
        }

        @Override
        public ValidationInfo validate(Ref<FileTransferConfig> configRef, boolean allowSlowActions) {
            return this.myEditor.validate();
        }

        public CredentialsType getType() {
            return this.myType;
        }

        @Override
        public boolean isBrowsingAvailable() {
            return this.myType.isBrowsingAvailable();
        }
    }

    private static abstract class TypeHandler {
        private final JBRadioButton myRadioButton;
        private final Component myPanel;
        @Nullable
        private final JComponent myPreferredFocusedComponent;
        private String myInterpreterPath;

        public TypeHandler(JBRadioButton radioButton, Component panel, @Nullable JComponent preferredFocusedComponent, String defaultInterpreterPath) {
            this.myRadioButton = radioButton;
            this.myPanel = panel;
            this.myPreferredFocusedComponent = preferredFocusedComponent;
            this.myInterpreterPath = defaultInterpreterPath;
        }

        public JBRadioButton getRadioButton() {
            return this.myRadioButton;
        }

        public void setInterpreterPath(String interpreterPath) {
            this.myInterpreterPath = interpreterPath;
        }

        public String getInterpreterPath() {
            return this.myInterpreterPath;
        }

        public void updateVisibility() {
            this.myPanel.setVisible(this.myRadioButton.isSelected());
        }

        public abstract void onInit();

        public abstract void onSelected();

        public boolean isBrowsingAvailable() {
            return true;
        }

        public abstract ValidationInfo validate(Ref<FileTransferConfig> var1, boolean var2);

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myPreferredFocusedComponent;
        }
    }

    public static interface BundleAccessor {
        @NotNull
        public String message(@NotNull String var1, Object ... var2);

        @Nullable
        public String messageOrNull(@NotNull String var1, Object ... var2);
    }
}

