/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassesDependencyMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

class DependencyVisitor
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dsm.model.classes.DependencyVisitor");
    private final ClassesDependencyMap myDependencyMap = new ClassesDependencyMap();
    private final AnnotationDependencyVisitor myAnnotationVisitor = new AnnotationDependencyVisitor();
    private final DependencySignatureVisitor mySignatureVisitor = new DependencySignatureVisitor();
    private final DependencyFieldVisitor myFieldVisitor = new DependencyFieldVisitor();
    String myCurrentClassName;
    private final Map<String, String> mySlotNames = new HashMap<String, String>();

    DependencyVisitor() {
        super(393216);
    }

    public void processFile(File file) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            this.processStream(is);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void processStream(InputStream is) throws IOException {
        ClassReader cr = new ClassReader(is);
        cr.accept((ClassVisitor)this, 4);
    }

    public ClassesDependencyMap getDependencies() {
        return this.myDependencyMap;
    }

    public void setCurrentModule(Module currentModule) {
        this.myDependencyMap.setCurrentModule(currentModule);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myCurrentClassName = this.getSlotName(name);
        if (signature == null) {
            this.addName(superName);
            this.addNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    private String getSlotName(String name) {
        String result = this.mySlotNames.get(name);
        if (result == null) {
            result = name.replace("/", ".");
            int idx = result.indexOf("$");
            if (idx >= 0) {
                result = result.substring(0, idx);
            }
            this.mySlotNames.put(name, result);
        }
        return result;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.addDesc(desc);
        return this.myAnnotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.myFieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) == 0) {
            if (signature == null) {
                this.addMethodDesc(desc);
            } else {
                this.addSignature(signature);
            }
            this.addNames(exceptions);
        }
        if ((access & 0x400) != 0) {
            return null;
        }
        return new DependencyMethodVisitor();
    }

    private void addName(String name) {
        if (name == null) {
            return;
        }
        if ((name = this.getSlotName(name)).equals(this.myCurrentClassName)) {
            return;
        }
        this.myDependencyMap.addDependency(this.myCurrentClassName, name);
    }

    private void addNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addName(names[i]);
        }
    }

    private void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    private void addHandle(Handle h) {
        this.addName(h.getOwner());
        this.addMethodDesc(h.getDesc());
    }

    private void addMethodDesc(String desc) {
        Type[] types;
        this.addType(Type.getReturnType((String)desc));
        for (Type type : types = Type.getArgumentTypes((String)desc)) {
            this.addType(type);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getClassName().replace('.', '/'));
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    private void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)this.mySignatureVisitor);
        }
    }

    public String getCurrentClassName() {
        return this.myCurrentClassName;
    }

    private class DependencySignatureVisitor
    extends SignatureVisitor {
        public DependencySignatureVisitor() {
            super(393216);
        }

        public void visitClassType(String name) {
            DependencyVisitor.this.addName(name);
        }

        public void visitInnerClassType(String name) {
            DependencyVisitor.this.addName(name);
        }
    }

    private class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        public AnnotationDependencyVisitor() {
            super(393216);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                DependencyVisitor.this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            DependencyVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            DependencyVisitor.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }

    private class DependencyFieldVisitor
    extends FieldVisitor {
        public DependencyFieldVisitor() {
            super(393216);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }
    }

    private class DependencyMethodVisitor
    extends MethodVisitor {
        private Label myFirstLabel;

        public DependencyMethodVisitor() {
            super(393216);
            this.myFirstLabel = null;
        }

        public void visitLabel(Label label) {
            if (this.myFirstLabel == null) {
                this.myFirstLabel = label;
            }
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (187 == opcode) {
                return;
            }
            if (desc.charAt(0) == '[') {
                DependencyVisitor.this.addDesc(desc);
            } else {
                DependencyVisitor.this.addName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            DependencyVisitor.this.addName(owner);
            DependencyVisitor.this.addDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            DependencyVisitor.this.addName(owner);
            DependencyVisitor.this.addMethodDesc(desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                DependencyVisitor.this.addType((Type)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            DependencyVisitor.this.addDesc(desc);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            DependencyVisitor.this.addName(type);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (this.myFirstLabel == start) {
                return;
            }
            DependencyVisitor.this.addTypeSignature(signature == null ? desc : signature);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            DependencyVisitor.this.addDesc(desc);
            for (Object arg : bsmArgs) {
                if (!(arg instanceof Handle)) continue;
                DependencyVisitor.this.addHandle((Handle)arg);
            }
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            DependencyVisitor.this.addDesc(desc);
            return DependencyVisitor.this.myAnnotationVisitor;
        }
    }
}

