/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.connection;

import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.search.dfs.AbstractDfsVisitor;
import org.gga.graph.search.dfs.DepthFirstSearch;
import org.gga.graph.util.IntStack;

public class StrongComponents {
    public static int strongComponents(Graph graph, int[] componentMap, int[] rootMap) {
        assert (graph.isDirected());
        TarjanSccVisitor visitor = new TarjanSccVisitor(rootMap, componentMap, new int[graph.V()]);
        DepthFirstSearch.depthFirstSearch(graph, visitor);
        return visitor.currentComponent;
    }

    private static class TarjanSccVisitor
    extends AbstractDfsVisitor {
        private final int[] rootMap;
        private final int[] componentMap;
        private final int[] discoverTime;
        private int dfsTime = 0;
        private int currentComponent = 0;
        private final IntStack stack = new IntStack();

        public TarjanSccVisitor(int[] rootMap, int[] componentMap, int[] discoverTime) {
            this.rootMap = rootMap;
            this.componentMap = componentMap;
            this.discoverTime = discoverTime;
        }

        @Override
        public void discoverVertex(int v, Graph graph) {
            this.rootMap[v] = v;
            this.componentMap[v] = Integer.MAX_VALUE;
            ++this.dfsTime;
            this.stack.push(v);
        }

        @Override
        public void finishVertex(int v, Graph graph) {
            Iterator<Edge> i = graph.getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                int w = e.other(v);
                if (this.componentMap[w] != Integer.MAX_VALUE) continue;
                this.rootMap[v] = this.minDiscoverTime(this.rootMap[v], this.rootMap[w]);
            }
            if (this.rootMap[v] == v) {
                int w;
                do {
                    w = this.stack.pop();
                    this.componentMap[w] = this.currentComponent++;
                    this.rootMap[w] = v;
                } while (w != v);
            }
        }

        private int minDiscoverTime(int v, int w) {
            return this.discoverTime[v] < this.discoverTime[w] ? v : w;
        }
    }
}

