/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myEventDispatcher.getMulticaster(), this));
        }
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "addVirtualFileListener"));
        }
        this.myEventDispatcher.addListener(listener);
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "deleteFile"));
        }
        throw this.unsupported("deleteFile", vFile);
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName2) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        throw this.unsupported("renameFile", vFile);
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        throw this.unsupported("createChildFile", vDir);
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        throw this.unsupported("createChildDirectory", vDir);
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        throw this.unsupported("copyFile", vFile);
    }

    private UnsupportedOperationException unsupported(String op, VirtualFile vFile) {
        return new UnsupportedOperationException(op + '(' + vFile + ") not supported by " + this.getClass().getName());
    }
}

