/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.ListIterator;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.inline.MaxStackFrameSizeAndLocalsCalculator;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SMAPAndMethodNode;
import org.jetbrains.kotlin.codegen.inline.SMAPParser;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicArrayConstructorsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InlineCodegenUtil {
    public static final boolean GENERATE_SMAP = true;
    public static final int API = 327680;
    public static final String THIS$0 = "this$0";
    public static final String THIS = "this";
    public static final String FIRST_FUN_LABEL = "$$$$$ROOT$$$$$";
    public static final String NUMBERED_FUNCTION_PREFIX = "kotlin/jvm/functions/Function";
    public static final String SPECIAL_TRANSFORMATION_NAME = "$special";
    public static final String INLINE_TRANSFORMATION_SUFFIX = "$inlined";
    public static final String INLINE_CALL_TRANSFORMATION_SUFFIX = "$$inlined";
    public static final String INLINE_FUN_THIS_0_SUFFIX = "$inline_fun";
    public static final String INLINE_FUN_VAR_SUFFIX = "$iv";

    @Nullable
    public static SMAPAndMethodNode getMethodNode(byte[] classData, final String methodName, final String methodDescriptor, ClassId classId) {
        ClassReader cr = new ClassReader(classData);
        final MethodNode[] node = new MethodNode[1];
        final String[] debugInfo2 = new String[2];
        final int[] lines = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        cr.accept(new ClassVisitor(327680){

            @Override
            public void visitSource(String source, String debug) {
                super.visitSource(source, debug);
                debugInfo2[0] = source;
                debugInfo2[1] = debug;
            }

            @Override
            public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, String signature, String[] exceptions) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (desc == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (methodName.equals(name) && methodDescriptor.equals(desc)) {
                    node[0] = new MethodNode(327680, access, name, desc, signature, exceptions){

                        @Override
                        public void visitLineNumber(int line, @NotNull Label start) {
                            if (start == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitLineNumber(line, start);
                            lines[0] = Math.min(lines[0], line);
                            lines[1] = Math.max(lines[1], line);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1$1", "visitLineNumber"));
                        }
                    };
                    return node[0];
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "desc";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil$1";
                objectArray[2] = "visitMethod";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 4);
        if (node[0] == null) {
            return null;
        }
        if (classId.equals(IntrinsicArrayConstructorsKt.getClassId())) {
            debugInfo2[0] = null;
        }
        SMAP smap = SMAPParser.parseOrCreateDefault(debugInfo2[1], debugInfo2[0], classId.asString(), lines[0], lines[1]);
        return new SMAPAndMethodNode(node[0], smap);
    }

    public static void initDefaultSourceMappingIfNeeded(@NotNull CodegenContext context, @NotNull MemberCodegen codegen, @NotNull GenerationState state2) {
        if (context == null) {
            InlineCodegenUtil.$$$reportNull$$$0(0);
        }
        if (codegen == null) {
            InlineCodegenUtil.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(2);
        }
        if (state2.isInlineDisabled()) {
            return;
        }
        for (CodegenContext parentContext = context.getParentContext(); parentContext != null; parentContext = parentContext.getParentContext()) {
            if (!parentContext.isInlineMethodContext()) continue;
            codegen.getOrCreateSourceMapper();
            break;
        }
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull GenerationState state2, @NotNull ClassId classId) {
        if (state2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(3);
        }
        if (classId == null) {
            InlineCodegenUtil.$$$reportNull$$$0(4);
        }
        return VirtualFileFinder.SERVICE.getInstance(state2.getProject()).findVirtualFileWithHeader(classId);
    }

    @Nullable
    private static VirtualFile findVirtualFileImprecise(@NotNull GenerationState state2, @NotNull String internalClassName) {
        if (state2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(5);
        }
        if (internalClassName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(6);
        }
        FqName packageFqName = JvmClassName.byInternalName(internalClassName).getPackageFqName();
        String classNameWithDollars = StringsKt.substringAfterLast(internalClassName, "/", internalClassName);
        return InlineCodegenUtil.findVirtualFile(state2, new ClassId(packageFqName, Name.identifier(classNameWithDollars)));
    }

    @NotNull
    public static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull KotlinTypeMapper typeMapper, @NotNull JvmFileClassesProvider fileClassesManager) {
        if (codegenContext == null) {
            InlineCodegenUtil.$$$reportNull$$$0(7);
        }
        if (typeMapper == null) {
            InlineCodegenUtil.$$$reportNull$$$0(8);
        }
        if (fileClassesManager == null) {
            InlineCodegenUtil.$$$reportNull$$$0(9);
        }
        String string = InlineCodegenUtil.getInlineName(codegenContext, codegenContext.getContextDescriptor(), typeMapper, fileClassesManager);
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull DeclarationDescriptor currentDescriptor, @NotNull KotlinTypeMapper typeMapper, @NotNull JvmFileClassesProvider fileClassesProvider) {
        ClassDescriptor descriptor2;
        if (codegenContext == null) {
            InlineCodegenUtil.$$$reportNull$$$0(11);
        }
        if (currentDescriptor == null) {
            InlineCodegenUtil.$$$reportNull$$$0(12);
        }
        if (typeMapper == null) {
            InlineCodegenUtil.$$$reportNull$$$0(13);
        }
        if (fileClassesProvider == null) {
            InlineCodegenUtil.$$$reportNull$$$0(14);
        }
        if (currentDescriptor instanceof PackageFragmentDescriptor) {
            KtFile file2 = DescriptorToSourceUtils.getContainingFile(codegenContext.getContextDescriptor());
            Type implementationOwnerType = file2 == null ? CodegenContextUtil.getImplementationOwnerClassType(codegenContext) : FileClasses.getFileClassType(fileClassesProvider, file2);
            if (implementationOwnerType == null) {
                Object contextDescriptor = codegenContext.getContextDescriptor();
                throw new RuntimeException("Couldn't find declaration for " + contextDescriptor.getContainingDeclaration().getName() + "." + contextDescriptor.getName() + "; context: " + codegenContext);
            }
            String string = implementationOwnerType.getInternalName();
            if (string == null) {
                InlineCodegenUtil.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (currentDescriptor instanceof ClassifierDescriptor) {
            Type type2 = typeMapper.mapType((ClassifierDescriptor)currentDescriptor);
            String string = type2.getInternalName();
            if (string == null) {
                InlineCodegenUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (currentDescriptor instanceof FunctionDescriptor && (descriptor2 = typeMapper.getBindingContext().get(CodegenBinding.CLASS_FOR_CALLABLE, (FunctionDescriptor)currentDescriptor)) != null) {
            String string = typeMapper.mapType(descriptor2).getInternalName();
            if (string == null) {
                InlineCodegenUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String suffix = currentDescriptor.getName().isSpecial() ? "" : currentDescriptor.getName().asString();
        String string = InlineCodegenUtil.getInlineName(codegenContext, currentDescriptor.getContainingDeclaration(), typeMapper, fileClassesProvider) + "$" + suffix;
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static boolean isInvokeOnLambda(@NotNull String owner, @NotNull String name) {
        if (owner == null) {
            InlineCodegenUtil.$$$reportNull$$$0(19);
        }
        if (name == null) {
            InlineCodegenUtil.$$$reportNull$$$0(20);
        }
        return OperatorNameConventions.INVOKE.asString().equals(name) && owner.startsWith(NUMBERED_FUNCTION_PREFIX) && InlineCodegenUtil.isInteger(owner.substring(NUMBERED_FUNCTION_PREFIX.length()));
    }

    public static boolean isAnonymousConstructorCall(@NotNull String internalName, @NotNull String methodName) {
        if (internalName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(21);
        }
        if (methodName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(22);
        }
        return "<init>".equals(methodName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isWhenMappingAccess(@NotNull String internalName, @NotNull String fieldName) {
        if (internalName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(23);
        }
        if (fieldName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(24);
        }
        return fieldName.startsWith("$EnumSwitchMapping$") && internalName.endsWith("$WhenMappings");
    }

    public static boolean isAnonymousSingletonLoad(@NotNull String internalName, @NotNull String fieldName) {
        if (internalName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(25);
        }
        if (fieldName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(26);
        }
        return "INSTANCE".equals(fieldName) && InlineCodegenUtil.isAnonymousClass(internalName);
    }

    public static boolean isAnonymousClass(@NotNull String internalName) {
        String shortName;
        int index2;
        if (internalName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(27);
        }
        if ((index2 = (shortName = InlineCodegenUtil.getLastNamePart(internalName)).lastIndexOf("$")) < 0) {
            return false;
        }
        String suffix = shortName.substring(index2 + 1);
        return InlineCodegenUtil.isInteger(suffix);
    }

    @NotNull
    private static String getLastNamePart(@NotNull String internalName) {
        int index2;
        if (internalName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(28);
        }
        String string = (index2 = internalName.lastIndexOf("/")) < 0 ? internalName : internalName.substring(index2 + 1);
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static MethodVisitor wrapWithMaxLocalCalc(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            InlineCodegenUtil.$$$reportNull$$$0(30);
        }
        MaxStackFrameSizeAndLocalsCalculator maxStackFrameSizeAndLocalsCalculator = new MaxStackFrameSizeAndLocalsCalculator(327680, methodNode.access, methodNode.desc, methodNode);
        if (maxStackFrameSizeAndLocalsCalculator == null) {
            InlineCodegenUtil.$$$reportNull$$$0(31);
        }
        return maxStackFrameSizeAndLocalsCalculator;
    }

    private static boolean isInteger(@NotNull String string) {
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(32);
        }
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCapturedFieldName(@NotNull String fieldName) {
        if (fieldName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(33);
        }
        return fieldName.startsWith("$") && !fieldName.startsWith("$$") || THIS$0.equals(fieldName) || "receiver$0".equals(fieldName);
    }

    public static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static boolean isMarkedReturn(@NotNull AbstractInsnNode returnIns) {
        if (returnIns == null) {
            InlineCodegenUtil.$$$reportNull$$$0(34);
        }
        return InlineCodegenUtil.getMarkedReturnLabelOrNull(returnIns) != null;
    }

    @Nullable
    public static String getMarkedReturnLabelOrNull(@NotNull AbstractInsnNode returnInsn) {
        if (returnInsn == null) {
            InlineCodegenUtil.$$$reportNull$$$0(35);
        }
        if (!InlineCodegenUtil.isReturnOpcode(returnInsn.getOpcode())) {
            return null;
        }
        AbstractInsnNode previous = returnInsn.getPrevious();
        if (previous instanceof MethodInsnNode) {
            MethodInsnNode marker = (MethodInsnNode)previous;
            if ("$$$$$NON_LOCAL_RETURN$$$$$".equals(marker.owner)) {
                return marker.name;
            }
        }
        return null;
    }

    public static void generateGlobalReturnFlag(@NotNull InstructionAdapter iv, @NotNull String labelName) {
        if (iv == null) {
            InlineCodegenUtil.$$$reportNull$$$0(36);
        }
        if (labelName == null) {
            InlineCodegenUtil.$$$reportNull$$$0(37);
        }
        iv.invokestatic("$$$$$NON_LOCAL_RETURN$$$$$", labelName, "()V", false);
    }

    @NotNull
    public static Type getReturnType(int opcode) {
        switch (opcode) {
            case 177: {
                Type type2 = Type.VOID_TYPE;
                if (type2 == null) {
                    InlineCodegenUtil.$$$reportNull$$$0(38);
                }
                return type2;
            }
            case 172: {
                Type type3 = Type.INT_TYPE;
                if (type3 == null) {
                    InlineCodegenUtil.$$$reportNull$$$0(39);
                }
                return type3;
            }
            case 175: {
                Type type4 = Type.DOUBLE_TYPE;
                if (type4 == null) {
                    InlineCodegenUtil.$$$reportNull$$$0(40);
                }
                return type4;
            }
            case 174: {
                Type type5 = Type.FLOAT_TYPE;
                if (type5 == null) {
                    InlineCodegenUtil.$$$reportNull$$$0(41);
                }
                return type5;
            }
            case 173: {
                Type type6 = Type.LONG_TYPE;
                if (type6 == null) {
                    InlineCodegenUtil.$$$reportNull$$$0(42);
                }
                return type6;
            }
        }
        Type type7 = AsmTypes.OBJECT_TYPE;
        if (type7 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(43);
        }
        return type7;
    }

    public static void insertNodeBefore(@NotNull MethodNode from, @NotNull MethodNode to, @NotNull AbstractInsnNode beforeNode) {
        if (from == null) {
            InlineCodegenUtil.$$$reportNull$$$0(44);
        }
        if (to == null) {
            InlineCodegenUtil.$$$reportNull$$$0(45);
        }
        if (beforeNode == null) {
            InlineCodegenUtil.$$$reportNull$$$0(46);
        }
        ListIterator<AbstractInsnNode> iterator2 = from.instructions.iterator();
        while (iterator2.hasNext()) {
            AbstractInsnNode next = iterator2.next();
            to.instructions.insertBefore(beforeNode, next);
        }
    }

    @NotNull
    public static MethodNode createEmptyMethodNode() {
        MethodNode methodNode = new MethodNode(327680, 0, "fake", "()V", null, null);
        if (methodNode == null) {
            InlineCodegenUtil.$$$reportNull$$$0(47);
        }
        return methodNode;
    }

    @NotNull
    public static LabelNode firstLabelInChain(@NotNull LabelNode node) {
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(48);
        }
        LabelNode curNode = node;
        while (curNode.getPrevious() instanceof LabelNode) {
            curNode = (LabelNode)curNode.getPrevious();
        }
        LabelNode labelNode = curNode;
        if (labelNode == null) {
            InlineCodegenUtil.$$$reportNull$$$0(49);
        }
        return labelNode;
    }

    @NotNull
    public static String getNodeText(@Nullable MethodNode node) {
        Textifier textifier = new Textifier();
        if (node == null) {
            if ("Not generated" == null) {
                InlineCodegenUtil.$$$reportNull$$$0(50);
            }
            return "Not generated";
        }
        node.accept(new TraceMethodVisitor(textifier));
        StringWriter sw = new StringWriter();
        textifier.print(new PrintWriter(sw));
        sw.flush();
        String string = node.name + " " + node.desc + ":\n" + sw.getBuffer().toString();
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static String getInsnText(@Nullable AbstractInsnNode node) {
        if (node == null) {
            if ("<null>" == null) {
                InlineCodegenUtil.$$$reportNull$$$0(52);
            }
            return "<null>";
        }
        Textifier textifier = new Textifier();
        node.accept(new TraceMethodVisitor(textifier));
        StringWriter sw = new StringWriter();
        textifier.print(new PrintWriter(sw));
        sw.flush();
        String string = sw.toString().trim();
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public static String getInsnOpcodeText(@Nullable AbstractInsnNode node) {
        String string = node == null ? "null" : Printer.OPCODES[node.getOpcode()];
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    static ClassReader buildClassReaderByInternalName(@NotNull GenerationState state2, @NotNull String internalName) {
        block8: {
            ClassReader classReader;
            block9: {
                block6: {
                    ClassReader classReader2;
                    block7: {
                        if (state2 == null) {
                            InlineCodegenUtil.$$$reportNull$$$0(55);
                        }
                        if (internalName == null) {
                            InlineCodegenUtil.$$$reportNull$$$0(56);
                        }
                        try {
                            OutputFile outputFile = state2.getFactory().get(internalName + ".class");
                            if (outputFile == null) break block6;
                            classReader2 = new ClassReader(outputFile.asByteArray());
                            if (classReader2 != null) break block7;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        InlineCodegenUtil.$$$reportNull$$$0(57);
                    }
                    return classReader2;
                }
                VirtualFile file2 = InlineCodegenUtil.findVirtualFileImprecise(state2, internalName);
                if (file2 == null) break block8;
                classReader = new ClassReader(file2.contentsToByteArray());
                if (classReader != null) break block9;
                InlineCodegenUtil.$$$reportNull$$$0(58);
            }
            return classReader;
        }
        throw new RuntimeException("Couldn't find virtual file for " + internalName);
    }

    public static void generateFinallyMarker(@NotNull InstructionAdapter v, int depth, boolean start) {
        if (v == null) {
            InlineCodegenUtil.$$$reportNull$$$0(59);
        }
        v.iconst(depth);
        v.invokestatic("kotlin/jvm/internal/InlineMarker", start ? "finallyStart" : "finallyEnd", "(I)V", false);
    }

    public static boolean isFinallyEnd(@NotNull AbstractInsnNode node) {
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(60);
        }
        return InlineCodegenUtil.isFinallyMarker(node, "finallyEnd");
    }

    public static boolean isFinallyStart(@NotNull AbstractInsnNode node) {
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(61);
        }
        return InlineCodegenUtil.isFinallyMarker(node, "finallyStart");
    }

    public static boolean isFinallyMarker(@Nullable AbstractInsnNode node) {
        return node != null && (InlineCodegenUtil.isFinallyStart(node) || InlineCodegenUtil.isFinallyEnd(node));
    }

    private static boolean isFinallyMarker(@NotNull AbstractInsnNode node, String name) {
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(62);
        }
        if (!(node instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode method = (MethodInsnNode)node;
        return "kotlin/jvm/internal/InlineMarker".equals(method.owner) && name.equals(method.name);
    }

    public static boolean isFinallyMarkerRequired(@NotNull MethodContext context) {
        if (context == null) {
            InlineCodegenUtil.$$$reportNull$$$0(63);
        }
        return context.isInlineMethodContext() || context instanceof InlineLambdaContext;
    }

    public static int getConstant(@NotNull AbstractInsnNode ins) {
        int opcode;
        if (ins == null) {
            InlineCodegenUtil.$$$reportNull$$$0(64);
        }
        if ((opcode = ins.getOpcode()) >= 3 && opcode <= 8) {
            return opcode - 3;
        }
        if (opcode == 16 || opcode == 17) {
            return ((IntInsnNode)ins).operand;
        }
        LdcInsnNode index2 = (LdcInsnNode)ins;
        return (Integer)index2.cst;
    }

    public static void removeFinallyMarkers(@NotNull MethodNode intoNode) {
        if (intoNode == null) {
            InlineCodegenUtil.$$$reportNull$$$0(65);
        }
        InsnList instructions = intoNode.instructions;
        AbstractInsnNode curInstr = instructions.getFirst();
        while (curInstr != null) {
            if (InlineCodegenUtil.isFinallyMarker(curInstr)) {
                AbstractInsnNode marker = curInstr;
                InlineCodegenUtil.getConstant(marker.getPrevious());
                curInstr = curInstr.getNext();
                instructions.remove(marker.getPrevious());
                instructions.remove(marker);
                continue;
            }
            curInstr = curInstr.getNext();
        }
    }

    public static void addInlineMarker(@NotNull InstructionAdapter v, boolean isStartNotEnd) {
        if (v == null) {
            InlineCodegenUtil.$$$reportNull$$$0(66);
        }
        v.visitMethodInsn(184, "kotlin/jvm/internal/InlineMarker", isStartNotEnd ? "beforeInlineCall" : "afterInlineCall", "()V", false);
    }

    public static boolean isInlineMarker(@NotNull AbstractInsnNode insn) {
        if (insn == null) {
            InlineCodegenUtil.$$$reportNull$$$0(67);
        }
        return InlineCodegenUtil.isInlineMarker(insn, null);
    }

    private static boolean isInlineMarker(@NotNull AbstractInsnNode insn, @Nullable String name) {
        if (insn == null) {
            InlineCodegenUtil.$$$reportNull$$$0(68);
        }
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
        return insn.getOpcode() == 184 && methodInsnNode.owner.equals("kotlin/jvm/internal/InlineMarker") && (name != null ? methodInsnNode.name.equals(name) : methodInsnNode.name.equals("beforeInlineCall") || methodInsnNode.name.equals("afterInlineCall"));
    }

    public static boolean isBeforeInlineMarker(@NotNull AbstractInsnNode insn) {
        if (insn == null) {
            InlineCodegenUtil.$$$reportNull$$$0(69);
        }
        return InlineCodegenUtil.isInlineMarker(insn, "beforeInlineCall");
    }

    public static boolean isAfterInlineMarker(@NotNull AbstractInsnNode insn) {
        if (insn == null) {
            InlineCodegenUtil.$$$reportNull$$$0(70);
        }
        return InlineCodegenUtil.isInlineMarker(insn, "afterInlineCall");
    }

    public static int getLoadStoreArgSize(int opcode) {
        return opcode == 57 || opcode == 55 || opcode == 24 || opcode == 22 ? 2 : 1;
    }

    public static boolean isStoreInstruction(int opcode) {
        return opcode >= 54 && opcode <= 58;
    }

    public static int calcMarkerShift(@NotNull Parameters parameters2, @NotNull MethodNode node) {
        if (parameters2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(71);
        }
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(72);
        }
        int markerShiftTemp = InlineCodegenUtil.getIndexAfterLastMarker(node);
        return markerShiftTemp - parameters2.getRealParametersSizeOnStack() + parameters2.getArgsSizeOnStack();
    }

    private static int getIndexAfterLastMarker(@NotNull MethodNode node) {
        if (node == null) {
            InlineCodegenUtil.$$$reportNull$$$0(73);
        }
        int result2 = -1;
        for (LocalVariableNode variable : node.localVariables) {
            if (!InlineCodegenUtil.isFakeLocalVariableForInline(variable.name)) continue;
            result2 = Math.max(result2, variable.index + 1);
        }
        return result2;
    }

    public static boolean isFakeLocalVariableForInline(@NotNull String name) {
        if (name == null) {
            InlineCodegenUtil.$$$reportNull$$$0(74);
        }
        return name.startsWith("$i$f$") || name.startsWith("$i$a$");
    }

    public static boolean isThis0(@NotNull String name) {
        if (name == null) {
            InlineCodegenUtil.$$$reportNull$$$0(75);
        }
        return THIS$0.equals(name);
    }

    public static boolean isSpecialEnumMethod(@NotNull FunctionDescriptor functionDescriptor) {
        DeclarationDescriptor containingDeclaration;
        if (functionDescriptor == null) {
            InlineCodegenUtil.$$$reportNull$$$0(76);
        }
        if (!((containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof PackageFragmentDescriptor)) {
            return false;
        }
        if (!((PackageFragmentDescriptor)containingDeclaration).getFqName().equals(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME)) {
            return false;
        }
        if (functionDescriptor.getTypeParameters().size() != 1) {
            return false;
        }
        String name = functionDescriptor.getName().asString();
        List<ValueParameterDescriptor> parameters2 = functionDescriptor.getValueParameters();
        return "enumValues".equals(name) && parameters2.size() == 0 || "enumValueOf".equals(name) && parameters2.size() == 1 && KotlinBuiltIns.isString(parameters2.get(0).getType());
    }

    public static MethodNode createSpecialEnumMethodBody(@NotNull ExpressionCodegen codegen, @NotNull String name, @NotNull KotlinType type2, @NotNull KotlinTypeMapper typeMapper) {
        if (codegen == null) {
            InlineCodegenUtil.$$$reportNull$$$0(77);
        }
        if (name == null) {
            InlineCodegenUtil.$$$reportNull$$$0(78);
        }
        if (type2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(79);
        }
        if (typeMapper == null) {
            InlineCodegenUtil.$$$reportNull$$$0(80);
        }
        boolean isValueOf = "enumValueOf".equals(name);
        Type invokeType = typeMapper.mapType(type2);
        String desc = InlineCodegenUtil.getSpecialEnumFunDescriptor(invokeType, isValueOf);
        MethodNode node = new MethodNode(327680, 8, "fake", desc, null, null);
        codegen.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.ENUM_REIFIED, new InstructionAdapter(node));
        if (isValueOf) {
            node.visitInsn(1);
            node.visitVarInsn(25, 0);
            node.visitMethodInsn(184, AsmTypes.ENUM_TYPE.getInternalName(), "valueOf", Type.getMethodDescriptor(AsmTypes.ENUM_TYPE, AsmTypes.JAVA_CLASS_TYPE, AsmTypes.JAVA_STRING_TYPE), false);
        } else {
            node.visitInsn(3);
            node.visitTypeInsn(189, AsmTypes.ENUM_TYPE.getInternalName());
        }
        node.visitInsn(176);
        node.visitMaxs(isValueOf ? 3 : 2, isValueOf ? 1 : 0);
        return node;
    }

    @NotNull
    public static String getSpecialEnumFunDescriptor(@NotNull Type type2, boolean isValueOf) {
        if (type2 == null) {
            InlineCodegenUtil.$$$reportNull$$$0(81);
        }
        String string = isValueOf ? Type.getMethodDescriptor(type2, AsmTypes.JAVA_STRING_TYPE) : Type.getMethodDescriptor(AsmUtil.getArrayType(type2), new Type[0]);
        if (string == null) {
            InlineCodegenUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalClassName";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegenContext";
                break;
            }
            case 8: 
            case 13: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClassesManager";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClassesProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 20: 
            case 74: 
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnIns";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnInsn";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeNode";
                break;
            }
            case 48: 
            case 60: 
            case 61: 
            case 62: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ins";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intoNode";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insn";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/inline/InlineCodegenUtil";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastNamePart";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithMaxLocalCalc";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyMethodNode";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLabelInChain";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsnText";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsnOpcodeText";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassReaderByInternalName";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialEnumFunDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initDefaultSourceMappingIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFileImprecise";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInlineName";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 82: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInvokeOnLambda";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousConstructorCall";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isWhenMappingAccess";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousSingletonLoad";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousClass";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLastNamePart";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMaxLocalCalc";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInteger";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isCapturedFieldName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isMarkedReturn";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMarkedReturnLabelOrNull";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "generateGlobalReturnFlag";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "insertNodeBefore";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "firstLabelInChain";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "buildClassReaderByInternalName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "generateFinallyMarker";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isFinallyEnd";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isFinallyStart";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isFinallyMarker";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isFinallyMarkerRequired";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getConstant";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeFinallyMarkers";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addInlineMarker";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isInlineMarker";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeInlineMarker";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isAfterInlineMarker";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "calcMarkerShift";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getIndexAfterLastMarker";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isFakeLocalVariableForInline";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isThis0";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialEnumMethod";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createSpecialEnumMethodBody";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialEnumFunDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 29: 
            case 31: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

